/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.monitoring;

import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.deploymentinfo.AbstractDeploymentInfo;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.dao.UnifiedMonitoringSettingsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ActivityMetricsFetchingService {
    private final TransactionService transactionService;
    private final UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO;
    private final APIServiceDeploymentsService apiServiceDeploymentsService;
    public static final String ACTIVITY_METRICS_PATH = "run/endpoint-activity-metrics";
    public static final String DEPLOYMENTS_ACTIVITY_METRICS_PATH = "run/endpoint-activity-metrics/deployments";
    public static final String SCOPES_ACTIVITY_METRICS_PATH = "run/endpoint-activity-metrics/scopes";
    public static final int QUERY_TIME_STEP_SECONDS = 60;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.monitoring.activityMetricsFetchingService");

    protected Pair<Instant, Instant> getMetricsRequestRange(int endTimeDelayMinutes) throws IOException {
        Instant end = Instant.now().minus(endTimeDelayMinutes, ChronoUnit.MINUTES);
        Instant start = end.minus(this.getSchedulerDefaultBatchFrequency_NT(), ChronoUnit.MINUTES);
        return new Pair((Object)start, (Object)end);
    }

    @Autowired
    protected ActivityMetricsFetchingService(TransactionService transactionService, UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO, APIServiceDeploymentsService apiServiceDeploymentsService) {
        this.transactionService = transactionService;
        this.unifiedMonitoringSettingsDAO = unifiedMonitoringSettingsDAO;
        this.apiServiceDeploymentsService = apiServiceDeploymentsService;
    }

    protected int getSchedulerDefaultBatchFrequency_NT() throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            int n = this.unifiedMonitoringSettingsDAO.read().endpointsBatchFrequencyInMinutes;
            return n;
        }
    }

    @Nonnull
    protected <T extends AbstractDeploymentInfo> List<DeploymentAndEndpoint<T>> getDeploymentAndEndpoints(String infraId, AuthCtx authCtx) throws IOException {
        List<AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo> deployments;
        ArrayList<DeploymentAndEndpoint<T>> result = new ArrayList<DeploymentAndEndpoint<T>>();
        try (Transaction t = this.transactionService.beginRead();){
            deployments = this.apiServiceDeploymentsService.listBasicInfoForInfraUnsafe_Check(infraId, authCtx);
        }
        for (AbstractDeploymentBasicInfo abstractDeploymentBasicInfo : deployments) {
            AbstractDeploymentBasicInfo.FullyManagedDeploymentBasicInfo deployment = (AbstractDeploymentBasicInfo.FullyManagedDeploymentBasicInfo)abstractDeploymentBasicInfo;
            if (!deployment.enabled) continue;
            if (!deployment.generationsMapping.isSingleGeneration()) {
                logger.warn((Object)("Won't consider deployment " + deployment.id + ", because it is not single generation."));
                continue;
            }
            String endpointId = deployment.endpointId;
            if (StringUtils.isBlank((CharSequence)endpointId)) {
                logger.warn((Object)("Won't consider deployment " + deployment.id + ", because it does not have a selected Endpoint"));
                continue;
            }
            Object deploymentInfo = deployment.deploymentInfo;
            if (deploymentInfo != null) {
                result.add(new DeploymentAndEndpoint(deployment.id, endpointId, deploymentInfo));
                continue;
            }
            logger.info((Object)("Won't consider deployment " + deployment.id + ", because it was never deployed."));
        }
        return result;
    }

    static <T extends AbstractDeploymentInfo> void fillSparseActivityMetrics(ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint timeAndMetricsByDeploymentAndEndpoint, Collection<DeploymentAndEndpoint<T>> deploymentAndEndpoints, long firstDataTimestampSeconds, long lastDataTimestampSeconds) {
        for (DeploymentAndEndpoint<T> deploymentAndEndpoint : deploymentAndEndpoints) {
            ActivityMetric.TimeAndMetricsForDeployment timeAndMetricsForDeployment = timeAndMetricsByDeploymentAndEndpoint.computeIfAbsent(deploymentAndEndpoint.deploymentId, ActivityMetric.TimeAndMetricsForDeployment::new);
            ActivityMetric.TimeAndMetricsForEndpoint timeAndMetricsForEndpoint = timeAndMetricsForDeployment.timeAndMetricsForEndpoint.computeIfAbsent(deploymentAndEndpoint.endpointId, ActivityMetric.TimeAndMetricsForEndpoint::new);
            ActivityMetricsFetchingService.fillSparseActivityMetrics(timeAndMetricsForEndpoint.timeAndMetricsOrderedByTime, firstDataTimestampSeconds, lastDataTimestampSeconds);
        }
    }

    protected static void fillSparseActivityMetrics(ActivityMetric.TimeAndMetricsByEndpoint timeAndMetricsByEndpoint, Collection<String> externalApiEndpointNames, long firstDataTimestampSeconds, long lastDataTimestampSeconds) {
        for (String endpointName : externalApiEndpointNames) {
            ActivityMetric.TimeAndMetricsForEndpoint timeAndMetricsForEndpoint = timeAndMetricsByEndpoint.computeIfAbsent(endpointName, ActivityMetric.TimeAndMetricsForEndpoint::new);
            ActivityMetricsFetchingService.fillSparseActivityMetrics(timeAndMetricsForEndpoint.timeAndMetricsOrderedByTime, firstDataTimestampSeconds, lastDataTimestampSeconds);
        }
    }

    private static void fillSparseActivityMetrics(ActivityMetric.TimeAndMetricsByTime timeAndMetricsOrderedByTime, long firstDataTimestampSeconds, long lastDataTimestampSeconds) {
        for (long t = firstDataTimestampSeconds; t <= lastDataTimestampSeconds; t += 60L) {
            ActivityMetric.TimeAndMetrics metrics = timeAndMetricsOrderedByTime.computeIfAbsent(t, ActivityMetric.TimeAndMetrics::new);
            metrics.activityMetricsByType.computeIfAbsent(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S, ty -> new ActivityMetric((ActivityMetric.Type)ty, 0.0));
            metrics.activityMetricsByType.computeIfAbsent(ActivityMetric.Type.ERROR_REQUESTS_IN_COUNT_PER_S, ty -> new ActivityMetric((ActivityMetric.Type)ty, 0.0));
        }
    }

    protected static class DeploymentAndEndpoint<T extends AbstractDeploymentInfo> {
        public String deploymentId;
        public String endpointId;
        public T deploymentInfo;

        public DeploymentAndEndpoint(String deploymentId, String endpointId, T deploymentInfo) {
            this.deploymentId = deploymentId;
            this.endpointId = endpointId;
            this.deploymentInfo = deploymentInfo;
        }
    }

    protected static class EndpointNotFoundException
    extends Exception {
        public EndpointNotFoundException(String message) {
            super(message);
        }
    }
}

