/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.monitoring;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.AzureMLDeploymentInfo;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.apideployer.monitoring.ActivityMetricsFetchingService;
import com.dataiku.dip.apideployer.monitoring.ApiEndpointActivityMonitoringService;
import com.dataiku.dip.connections.AzureMLConnection;
import com.dataiku.dip.dao.UnifiedMonitoringSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineEndpoint;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMonitor;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLHttpClient;
import com.dataiku.dip.externalinfras.azureml.http.AzureMonitorHttpClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScope;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AzureMLActivityMetricsFetchingService
extends ActivityMetricsFetchingService {
    private static final int AZUREMONITOR_DELAY_MINUTES = 3;
    private static final String QUERY_INTERVAL = "PT1M";
    private static final String REQUESTS_METRIC_NAME = "RequestsPerMinute";
    private static final String AVG_LATENCY_METRIC_NAME = "RequestLatency";
    private static final String P95_LATENCY_METRIC_NAME = "RequestLatency_P95";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.monitoring.azureMLActivityMetricsFetchingService");

    @Autowired
    public AzureMLActivityMetricsFetchingService(TransactionService transactionService, UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO, APIServiceDeploymentsService apiServiceDeploymentsService) {
        super(transactionService, unifiedMonitoringSettingsDAO, apiServiceDeploymentsService);
    }

    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getInfraActivityMetrics_NT(AuthCtx authCtx, AzureMLAPIDeploymentInfra infra, int connectTimeout, int socketTimeout, String overridingConnectionName) {
        TransactionContext.assertNoAttachedTransaction();
        String usedConnection = overridingConnectionName != null ? overridingConnectionName : infra.authConnection;
        String displayedUsedConnection = overridingConnectionName != null ? overridingConnectionName : infra.getDisplayedConnectionName();
        logger.infoV("Getting activity metrics from Azure Monitor for infrastructure %s using connection %s", new Object[]{infra.id, displayedUsedConnection});
        List<ActivityMetricsFetchingService.DeploymentAndEndpoint<AzureMLDeploymentInfo>> deployments = this.getDeploymentAndEndpoints(infra.id, authCtx);
        logger.infoV("Will fetch activity metrics from Azure Monitor for %d dss endpoints for infrastructure %s using connection %s", new Object[]{deployments.size(), infra.id, displayedUsedConnection});
        AzureMLConnection azureMLConnection = (AzureMLConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, usedConnection);
        TokenCredential credentials = AzureMLUtils.getAzureMLCredentials_NT(authCtx, azureMLConnection);
        ProxySettings proxySettings = ExternalInfrasUtils.getProxy(azureMLConnection);
        Map<String, List<ActivityMetricsFetchingService.DeploymentAndEndpoint<AzureMLDeploymentInfo>>> deploymentAndEndpointsByLocation = this.getDeploymentAndEndpointsByLocation(authCtx, usedConnection, deployments, infra, connectTimeout, socketTimeout);
        AzureMonitorHttpClient azureMonitoringClient = new AzureMonitorHttpClient(proxySettings, credentials, connectTimeout, socketTimeout);
        try {
            ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint timeAndMetricsByDeploymentAndEndpoint = this.getDssActivityMetricsFromAzureMonitor(azureMonitoringClient, deploymentAndEndpointsByLocation, infra);
            azureMonitoringClient.close();
            return timeAndMetricsByDeploymentAndEndpoint;
        }
        catch (Throwable throwable) {
            try {
                try {
                    azureMonitoringClient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DKUSecurityException | AzureMLUtils.AzureAuthenticationException | IOException | URISyntaxException e) {
                logger.errorV(e, "Failed to fetch activity metrics from Azure Monitor for infrastructure %s using connection %s", new Object[]{infra.id, displayedUsedConnection});
                return new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint.None();
            }
        }
    }

    public ActivityMetric.TimeAndMetricsByEndpoint getScopeActivityMetrics_NT(AuthCtx authCtx, UnifiedMonitoringExternalEndpointsScope.AzureML externalEndpointsScope, int connectTimeout, int socketTimeout) {
        TransactionContext.assertNoAttachedTransaction();
        logger.infoV("Getting activity metrics from Azure Monitor for scope %s using connection %s", new Object[]{externalEndpointsScope.name, externalEndpointsScope.connectionName});
        AzureMLConnection azureMLConnection = (AzureMLConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, externalEndpointsScope.connectionName);
        TokenCredential credentials = AzureMLUtils.getAzureMLCredentials_NT(authCtx, azureMLConnection);
        ProxySettings proxySettings = ExternalInfrasUtils.getProxy(azureMLConnection);
        Map<String, List<String>> endpointsByLocation = this.getAzEndpointNamesByLocation(authCtx, externalEndpointsScope, connectTimeout, socketTimeout);
        int numEndpoints = endpointsByLocation.values().stream().mapToInt(List::size).sum();
        logger.infoV("Will fetch activity metrics from Azure Monitor for at least %d external endpoints for scope %s using connection %s", new Object[]{numEndpoints, externalEndpointsScope.name, externalEndpointsScope.connectionName});
        AzureMonitorHttpClient azureMonitoringClient = new AzureMonitorHttpClient(proxySettings, credentials, connectTimeout, socketTimeout);
        try {
            ActivityMetric.TimeAndMetricsByEndpoint timeAndMetricsByEndpoint = this.getExternalActivityMetricsFromAzureMonitor(azureMonitoringClient, endpointsByLocation, externalEndpointsScope);
            azureMonitoringClient.close();
            return timeAndMetricsByEndpoint;
        }
        catch (Throwable throwable) {
            try {
                try {
                    azureMonitoringClient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Failed to fetch activity metrics from Azure Monitor for scope %s using connection %s", new Object[]{externalEndpointsScope.name, externalEndpointsScope.connectionName});
                return new ActivityMetric.TimeAndMetricsByEndpoint.None();
            }
        }
    }

    private Map<String, List<ActivityMetricsFetchingService.DeploymentAndEndpoint<AzureMLDeploymentInfo>>> getDeploymentAndEndpointsByLocation(AuthCtx authCtx, String authConnection, List<ActivityMetricsFetchingService.DeploymentAndEndpoint<AzureMLDeploymentInfo>> deploymentAndEndpoints, AzureMLAPIDeploymentInfra infra, int connectTimeout, int socketTimeout) throws IOException, AzureMLUtils.AzureAuthenticationException, DKUSecurityException {
        Map<String, ActivityMetricsFetchingService.DeploymentAndEndpoint> deploymentAndEndpointsByAzEndpointName = deploymentAndEndpoints.stream().collect(Collectors.toMap(de -> ((AzureMLDeploymentInfo)de.deploymentInfo).azOnlineEndpointName, de -> de));
        HashMap<String, List<ActivityMetricsFetchingService.DeploymentAndEndpoint<AzureMLDeploymentInfo>>> deploymentAndEndpointsByLocation = new HashMap<String, List<ActivityMetricsFetchingService.DeploymentAndEndpoint<AzureMLDeploymentInfo>>>();
        try (AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(authCtx, authConnection, connectTimeout, socketTimeout);){
            List<AzureMLOnlineEndpoint> azEndpoints = azureMLClient.listOnlineEndpoints_NT(infra.azWorkspace, infra.azResourceGroup, infra.azSubscription);
            for (AzureMLOnlineEndpoint azEndpoint : azEndpoints) {
                ActivityMetricsFetchingService.DeploymentAndEndpoint deploymentAndEndpoint = deploymentAndEndpointsByAzEndpointName.getOrDefault(azEndpoint.name, null);
                if (deploymentAndEndpoint == null) continue;
                deploymentAndEndpointsByLocation.computeIfAbsent(azEndpoint.location, l -> new ArrayList()).add(deploymentAndEndpoint);
            }
        }
        return deploymentAndEndpointsByLocation;
    }

    private Map<String, List<String>> getAzEndpointNamesByLocation(AuthCtx authCtx, UnifiedMonitoringExternalEndpointsScope.AzureML externalEndpointsScope, int connectTimeout, int socketTimeout) throws IOException, AzureMLUtils.AzureAuthenticationException, DKUSecurityException {
        String subscription = externalEndpointsScope.azSubscription;
        String resourceGroup = externalEndpointsScope.azResourceGroup;
        String workspace = externalEndpointsScope.azWorkspace;
        HashMap<String, List<String>> endpointsByLocation = new HashMap<String, List<String>>();
        try (AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(authCtx, externalEndpointsScope.connectionName, connectTimeout, socketTimeout);){
            List<AzureMLOnlineEndpoint> azEndpoints = azureMLClient.listOnlineEndpoints_NT(workspace, resourceGroup, subscription);
            for (AzureMLOnlineEndpoint azEndpoint : azEndpoints) {
                endpointsByLocation.computeIfAbsent(azEndpoint.location, l -> new ArrayList()).add(azEndpoint.name);
            }
        }
        return endpointsByLocation;
    }

    private ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getDssActivityMetricsFromAzureMonitor(AzureMonitorHttpClient azureClient, Map<String, List<ActivityMetricsFetchingService.DeploymentAndEndpoint<AzureMLDeploymentInfo>>> deploymentAndEndpointsByLocation, AzureMLAPIDeploymentInfra infra) throws IOException, URISyntaxException {
        ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint timeAndMetricsByDeploymentAndEndpoint = new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint();
        Pair<Instant, Instant> queryRange = this.getMetricsRequestRange(3);
        for (Map.Entry<String, List<ActivityMetricsFetchingService.DeploymentAndEndpoint<AzureMLDeploymentInfo>>> entry : deploymentAndEndpointsByLocation.entrySet()) {
            List<ActivityMetricsFetchingService.DeploymentAndEndpoint<AzureMLDeploymentInfo>> deploymentAndEndpoints = entry.getValue();
            String location = entry.getKey();
            List<String> endpointResourceIds = deploymentAndEndpoints.stream().map(de -> String.format("/subscriptions/%s/resourceGroups/%s/providers/Microsoft.MachineLearningServices/workspaces/%s/onlineEndpoints/%s", infra.azSubscription, infra.azResourceGroup, infra.azWorkspace, ((AzureMLDeploymentInfo)de.deploymentInfo).azOnlineEndpointName)).collect(Collectors.toList());
            Map<String, AzureMonitor.Metric> requests = AzureMLActivityMetricsFetchingService.getRequests(azureClient, location, infra.azSubscription, endpointResourceIds, queryRange);
            AzureMLActivityMetricsFetchingService.fillTimeAndMetricsByDeploymentAndEndpoints(timeAndMetricsByDeploymentAndEndpoint, requests, deploymentAndEndpoints);
            Map<String, AzureMonitor.Metric> avgLatencies = AzureMLActivityMetricsFetchingService.getLatencies(azureClient, location, infra.azSubscription, endpointResourceIds, AVG_LATENCY_METRIC_NAME, queryRange);
            AzureMLActivityMetricsFetchingService.fillTimeAndMetricsByDeploymentAndEndpoints(timeAndMetricsByDeploymentAndEndpoint, avgLatencies, deploymentAndEndpoints);
            Map<String, AzureMonitor.Metric> p95Latencies = AzureMLActivityMetricsFetchingService.getLatencies(azureClient, location, infra.azSubscription, endpointResourceIds, P95_LATENCY_METRIC_NAME, queryRange);
            AzureMLActivityMetricsFetchingService.fillTimeAndMetricsByDeploymentAndEndpoints(timeAndMetricsByDeploymentAndEndpoint, p95Latencies, deploymentAndEndpoints);
        }
        Pair<Long, Long> metricsDateRange = this.getMetricsRangeAlignedToQueryInterval((Instant)queryRange.first, (Instant)queryRange.second);
        List deploymentAndEndpoints = deploymentAndEndpointsByLocation.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        AzureMLActivityMetricsFetchingService.fillSparseActivityMetrics(timeAndMetricsByDeploymentAndEndpoint, deploymentAndEndpoints, (long)((Long)metricsDateRange.first), (long)((Long)metricsDateRange.second));
        ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint withTotalMetrics = ApiEndpointActivityMonitoringService.mapAverageToTotal(timeAndMetricsByDeploymentAndEndpoint);
        return withTotalMetrics;
    }

    private ActivityMetric.TimeAndMetricsByEndpoint getExternalActivityMetricsFromAzureMonitor(AzureMonitorHttpClient azureClient, Map<String, List<String>> endpointsByLocation, UnifiedMonitoringExternalEndpointsScope.AzureML externalEndpointsScope) throws IOException, URISyntaxException {
        ActivityMetric.TimeAndMetricsByEndpoint timeAndMetricsByEndpoint = new ActivityMetric.TimeAndMetricsByEndpoint();
        Pair<Instant, Instant> queryRange = this.getMetricsRequestRange(3);
        for (Map.Entry<String, List<String>> entry : endpointsByLocation.entrySet()) {
            List<String> endpoints = entry.getValue();
            String location = entry.getKey();
            List<String> endpointResourceIds = endpoints.stream().map(e -> String.format("/subscriptions/%s/resourceGroups/%s/providers/Microsoft.MachineLearningServices/workspaces/%s/onlineEndpoints/%s", externalEndpointsScope.azSubscription, externalEndpointsScope.azResourceGroup, externalEndpointsScope.azWorkspace, e)).collect(Collectors.toList());
            Map<String, AzureMonitor.Metric> requests = AzureMLActivityMetricsFetchingService.getRequests(azureClient, location, externalEndpointsScope.azSubscription, endpointResourceIds, queryRange);
            AzureMLActivityMetricsFetchingService.fillTimeAndMetricsByEndpoint(timeAndMetricsByEndpoint, requests);
            Map<String, AzureMonitor.Metric> avgLatencies = AzureMLActivityMetricsFetchingService.getLatencies(azureClient, location, externalEndpointsScope.azSubscription, endpointResourceIds, AVG_LATENCY_METRIC_NAME, queryRange);
            AzureMLActivityMetricsFetchingService.fillTimeAndMetricsByEndpoint(timeAndMetricsByEndpoint, avgLatencies);
            Map<String, AzureMonitor.Metric> p95Latencies = AzureMLActivityMetricsFetchingService.getLatencies(azureClient, location, externalEndpointsScope.azSubscription, endpointResourceIds, P95_LATENCY_METRIC_NAME, queryRange);
            AzureMLActivityMetricsFetchingService.fillTimeAndMetricsByEndpoint(timeAndMetricsByEndpoint, p95Latencies);
        }
        Pair<Long, Long> metricsDateRange = this.getMetricsRangeAlignedToQueryInterval((Instant)queryRange.first, (Instant)queryRange.second);
        List<String> endpointNames = endpointsByLocation.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        AzureMLActivityMetricsFetchingService.fillSparseActivityMetrics(timeAndMetricsByEndpoint, endpointNames, (long)((Long)metricsDateRange.first), (long)((Long)metricsDateRange.second));
        ActivityMetric.TimeAndMetricsByEndpoint withTotalMetrics = ApiEndpointActivityMonitoringService.mapAverageToTotal(timeAndMetricsByEndpoint);
        return withTotalMetrics;
    }

    private static Map<String, AzureMonitor.Metric> getRequests(AzureMonitorHttpClient azureClient, String location, String subscription, List<String> endpointResourceIds, Pair<Instant, Instant> queryRange) throws IOException, URISyntaxException {
        String filter = "statusCodeClass eq '*'";
        logger.info((Object)"Querying Azure Monitor for requests activity metrics");
        return azureClient.getEndpointMetrics_NT(location, subscription, endpointResourceIds, (Instant)queryRange.first, (Instant)queryRange.second, QUERY_INTERVAL, REQUESTS_METRIC_NAME, "average", filter);
    }

    private static Map<String, AzureMonitor.Metric> getLatencies(AzureMonitorHttpClient azureClient, String location, String subscription, List<String> endpointResourceIds, String metricName, Pair<Instant, Instant> queryRange) throws IOException, URISyntaxException {
        logger.infoV("Querying Azure Monitor for %s activity metrics.", new Object[]{metricName});
        return azureClient.getEndpointMetrics_NT(location, subscription, endpointResourceIds, (Instant)queryRange.first, (Instant)queryRange.second, QUERY_INTERVAL, metricName, "average", "");
    }

    private static void fillTimeAndMetricsByDeploymentAndEndpoints(ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint timeAndMetricsByDeploymentAndEndpoint, Map<String, AzureMonitor.Metric> metricByEndpoint, List<ActivityMetricsFetchingService.DeploymentAndEndpoint<AzureMLDeploymentInfo>> deploymentAndEndpoints) throws IOException {
        int countDssEndpoints = 0;
        for (Map.Entry<String, AzureMonitor.Metric> entry : metricByEndpoint.entrySet()) {
            String endpointName = entry.getKey();
            AzureMonitor.Metric metric = entry.getValue();
            ActivityMetricsFetchingService.DeploymentAndEndpoint deploymentAndEndpoint = deploymentAndEndpoints.stream().filter(de -> ((AzureMLDeploymentInfo)de.deploymentInfo).azOnlineEndpointName.equals(endpointName)).findFirst().orElse(null);
            if (deploymentAndEndpoint == null) continue;
            ++countDssEndpoints;
            ActivityMetric.TimeAndMetricsForDeployment timeAndMetricsForDeployment = timeAndMetricsByDeploymentAndEndpoint.computeIfAbsent(deploymentAndEndpoint.deploymentId, ActivityMetric.TimeAndMetricsForDeployment::new);
            ActivityMetric.TimeAndMetricsForEndpoint timeAndMetricsForEndpoint = timeAndMetricsForDeployment.timeAndMetricsForEndpoint.computeIfAbsent(deploymentAndEndpoint.endpointId, ActivityMetric.TimeAndMetricsForEndpoint::new);
            ActivityMetric.TimeAndMetricsByTime timeAndMetricsOrderedByTime = timeAndMetricsForEndpoint.timeAndMetricsOrderedByTime;
            AzureMLActivityMetricsFetchingService.fillTimeAndMetrics(timeAndMetricsOrderedByTime, metric);
            logger.debugV("Pulled activity metric '%s' from Azure Monitor for endpoint %s on deployment %s", new Object[]{metric.name.value, deploymentAndEndpoint.endpointId, deploymentAndEndpoint.deploymentId});
        }
        logger.infoV("Pulled activity metric from Azure Monitor for %d dss endpoints", new Object[]{countDssEndpoints});
    }

    private static void fillTimeAndMetricsByEndpoint(ActivityMetric.TimeAndMetricsByEndpoint timeAndMetricsByEndpoint, Map<String, AzureMonitor.Metric> metricByEndpoint) throws IOException {
        int countExternalEndpoints = 0;
        for (Map.Entry<String, AzureMonitor.Metric> entry : metricByEndpoint.entrySet()) {
            String endpointName = entry.getKey();
            AzureMonitor.Metric metric = entry.getValue();
            ++countExternalEndpoints;
            ActivityMetric.TimeAndMetricsForEndpoint timeAndMetricsForEndpoint = timeAndMetricsByEndpoint.computeIfAbsent(endpointName, ActivityMetric.TimeAndMetricsForEndpoint::new);
            ActivityMetric.TimeAndMetricsByTime timeAndMetricsOrderedByTime = timeAndMetricsForEndpoint.timeAndMetricsOrderedByTime;
            AzureMLActivityMetricsFetchingService.fillTimeAndMetrics(timeAndMetricsOrderedByTime, metric);
            logger.debugV("Pulled activity metric '%s' from Azure Monitor for endpoint %s", new Object[]{metric.name.value, endpointName});
        }
        logger.infoV("Pulled activity metric from Azure Monitor for %s external endpoints", new Object[]{countExternalEndpoints});
    }

    private static void fillTimeAndMetrics(Map<Long, ActivityMetric.TimeAndMetrics> timeAndMetricsOrderedByTime, AzureMonitor.Metric metric) throws IllegalArgumentException, IOException {
        for (AzureMonitor.TimeSeriesElement timeSerie : metric.timeseries) {
            List<ActivityMetric.Type> metricTypesToAddTo = switch (metric.name.value) {
                case REQUESTS_METRIC_NAME -> {
                    String statusCodeClass = timeSerie.metadatavalues.stream().filter((Predicate<AzureMonitor.MetadataValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fillTimeAndMetrics$7(com.dataiku.dip.externalinfras.azureml.datamodel.AzureMonitor$MetadataValue ), (Lcom/dataiku/dip/externalinfras/azureml/datamodel/AzureMonitor$MetadataValue;)Z)()).findFirst().orElseThrow((Supplier<IOException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$fillTimeAndMetrics$8(), ()Ljava/io/IOException;)()).value;
                    yield statusCodeClass.equals("2xx") ? Collections.singletonList(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S) : Arrays.asList(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S, ActivityMetric.Type.ERROR_REQUESTS_IN_COUNT_PER_S);
                }
                case P95_LATENCY_METRIC_NAME -> Collections.singletonList(ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST);
                case AVG_LATENCY_METRIC_NAME -> Collections.singletonList(ActivityMetric.Type.AVG_PROCESSING_TIME_IN_MS_PER_REQUEST);
                default -> throw new IllegalArgumentException(String.format("Unknown metric name: %s", metric.name.value));
            };
            for (AzureMonitor.MetricValue data : timeSerie.data) {
                long timestampSeconds = Instant.parse(data.timeStamp).getEpochSecond();
                double value = data.average;
                ActivityMetric.TimeAndMetrics metrics = timeAndMetricsOrderedByTime.computeIfAbsent(timestampSeconds, ActivityMetric.TimeAndMetrics::new);
                for (ActivityMetric.Type metricType : metricTypesToAddTo) {
                    if (metricType == ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S || metricType == ActivityMetric.Type.ERROR_REQUESTS_IN_COUNT_PER_S) {
                        value /= 60.0;
                    }
                    if (value == 0.0 && ImmutableList.of((Object)ActivityMetric.Type.AVG_PROCESSING_TIME_IN_MS_PER_REQUEST, (Object)ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST).contains((Object)metricType)) continue;
                    ActivityMetric activityMetric = metrics.activityMetricsByType.computeIfAbsent(metricType, t -> new ActivityMetric((ActivityMetric.Type)t, 0.0));
                    activityMetric.setValue(activityMetric.getValue() + value);
                }
            }
        }
    }

    protected Pair<Long, Long> getMetricsRangeAlignedToQueryInterval(Instant start, Instant end) {
        long queryInterval = Duration.parse(QUERY_INTERVAL).getSeconds();
        long firstDataTimestampSeconds = start.getEpochSecond() - start.getEpochSecond() % queryInterval;
        long lastDataTimestampSeconds = end.getEpochSecond() - end.getEpochSecond() % queryInterval - queryInterval;
        return new Pair((Object)firstDataTimestampSeconds, (Object)lastDataTimestampSeconds);
    }

    private static /* synthetic */ IOException lambda$fillTimeAndMetrics$8() {
        return new IOException("Error while querying Azure Monitor, no 2xx metric found");
    }

    private static /* synthetic */ boolean lambda$fillTimeAndMetrics$7(AzureMonitor.MetadataValue m) {
        return "statuscodeclass".equals(m.name.value);
    }
}

