/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.geoip.fastgeo.FastGeoIP2;
import com.dataiku.geoip.fastgeo.builder.FastGeoIP2Builder;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class GeoLite2CityUpdateCommand
extends CLICommand {
    public static final String commandName = "geoip-update";

    @Override
    public String usageString() {
        return "geoip-update MMDB_FILE";
    }

    @Override
    public String description() {
        return "Update the DSS GeoIP database from a \"MaxMind GeoLite2-city\" database file. (http://dev.maxmind.com/geoip/geoip2/geolite2/)";
    }

    @Override
    public Options opts() {
        return new Options();
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, commandName, true);
        if (System.getenv("DKUINSTALLDIR") != null) {
            if (cmdLine.getArgs().length != 2) {
                System.err.println("Missing MMDB_FILE argument");
                return 1;
            }
            String mmdbInputFilename = cmdLine.getArgs()[1];
            String fgdbOutputFilename = System.getenv("DKUINSTALLDIR") + "/resources/GeoLite2City.fgdb.gz";
            File inputMMDB = new File(mmdbInputFilename);
            File outputFGDB = new File(fgdbOutputFilename);
            if (!inputMMDB.isFile()) {
                System.err.println("File doesn't exist: " + inputMMDB.getAbsolutePath());
                return 1;
            }
            System.err.println("Convert GeoLite2 MMDB -> FastGeoIP2 FGDB...");
            System.err.println("MaxMind GeoLite database : " + inputMMDB.getAbsolutePath());
            System.err.println("Output FastGeoIP database : " + outputFGDB.getAbsolutePath());
            FastGeoIP2Builder dbBuilder = new FastGeoIP2Builder(inputMMDB);
            FastGeoIP2 inMemoryDB = dbBuilder.build(new FastGeoIP2Builder.Listener(){

                @Override
                public void progress(int processed) {
                    if (processed % 300000 == 0) {
                        System.err.println("Building FastGeoIP2... " + processed + " IP ranges processed");
                    }
                }
            });
            if (outputFGDB.isFile()) {
                int tentative = 0;
                File backup = null;
                while (backup == null || backup.exists()) {
                    backup = new File(fgdbOutputFilename + ".bak" + ++tentative);
                }
                System.out.println("Backup previous FGDB database to " + backup.getAbsolutePath());
                FileUtils.copyFile((File)outputFGDB, (File)backup);
            }
            DKUFileUtils.forceDelete((File)outputFGDB);
            inMemoryDB.saveToFile(outputFGDB);
            System.err.println("FastGeoIP2 database built successfully !");
            System.err.println("Database size (on disk) : " + outputFGDB.length() / 1024L + "KB");
            return 0;
        }
        System.err.println("DKUINSTALLDIR is not defined");
        return 1;
    }
}

