/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPackageSystems;
import com.dataiku.dip.code.CodeEnvUtilsBase;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PythonCodeEnvUtils
extends CodeEnvUtilsBase {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.code.envs");

    private PythonCodeEnvUtils() {
    }

    public static CodeEnvModel.PythonEnvActualData computePyEnvActualData(AuthCtx authCtx, File envRootFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        CodeEnvModel.PythonEnvActualData ret = new CodeEnvModel.PythonEnvActualData();
        if (new File(envRootFolder, "conda-meta").isDirectory()) {
            ret.conda = true;
            ret.condaEnvSpec = CodeEnvPackageSystems.CONDA_PYTHON.getPackageList(authCtx, envRootFolder, logTailBuilder, log);
        }
        ret.nocondaEnvSpec = CodeEnvPackageSystems.PIP.getPackageList(authCtx, envRootFolder, logTailBuilder, log);
        return ret;
    }

    public static void createEmptyPyEnv(AuthCtx authCtx, CodeEnvModel.PythonEnvDesc envDesc, File targetEnvDir, DKUtils.SmartLogTailBuilder logTailBuilder, File log, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings) throws IOException, InterruptedException {
        if (envDesc.conda) {
            CodeEnvPackageSystems.CONDA_PYTHON.createEmpty(authCtx, envDesc, targetEnvDir, logTailBuilder, log, envSettings);
        } else {
            CodeEnvPackageSystems.PIP.createEmpty(authCtx, envDesc, targetEnvDir, logTailBuilder, log, envSettings);
        }
    }

    public static void createEmptyPyEnvFromDescDir(AuthCtx authCtx, File descDir, File targetEnvDir, DKUtils.SmartLogTailBuilder logTailBuilder, File log, @Nullable GeneralSettingsDAO.AbstractCodeEnvExtraSettings overrideDescDirSettings) throws Exception {
        CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
        GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings = CodeEnvPackageSystems.getCodeEnvSettings(desc);
        if (overrideDescDirSettings != null) {
            envSettings = overrideDescDirSettings;
        }
        PythonCodeEnvUtils.createEmptyPyEnv(authCtx, desc, targetEnvDir, logTailBuilder, log, envSettings);
    }

    public static CodeEnvModel.PythonEnvDesc installPyEnvPackagesFromDescDir(AuthCtx authCtx, File descDir, File targetEnvDir, DKUtils.SmartLogTailBuilder logTailBuilder, File log, @Nullable GeneralSettingsDAO.AbstractCodeEnvExtraSettings overrideDescDirSettings) throws Exception {
        CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
        GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings = CodeEnvPackageSystems.getCodeEnvSettings(desc);
        if (overrideDescDirSettings != null) {
            envSettings = overrideDescDirSettings;
        }
        if (desc.conda) {
            File specFile = new File(descDir, "spec/environment.spec");
            String specData = "";
            if (specFile.exists()) {
                specData = FileUtils.readFileToString((File)specFile, (Charset)StandardCharsets.UTF_8);
            } else {
                logger.info((Object)"conda spec file does not exist");
            }
            CodeEnvPackageSystems.CONDA_PYTHON.install(authCtx, targetEnvDir, desc, true, specData, true, desc.conda, logTailBuilder, log, envSettings);
        }
        File reqFile = new File(descDir, "spec/requirements.txt");
        String requirements = "";
        if (reqFile.exists()) {
            requirements = FileUtils.readFileToString((File)reqFile, (Charset)StandardCharsets.UTF_8);
        } else {
            logger.info((Object)"requirements.txt file does not exist");
        }
        CodeEnvPackageSystems.PIP.install(authCtx, targetEnvDir, desc, true, requirements, true, desc.conda, logTailBuilder, log, envSettings);
        return desc;
    }

    private static void executeResourcesInitScriptCommand(AuthCtx authCtx, String scriptPath, String envName, File descFolder, File envFolder, File resourcesFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        if (!resourcesFolder.exists()) {
            logger.info((Object)("Creating code environment resources directory: " + resourcesFolder.getAbsolutePath()));
            DKUFileUtils.mkdirs((File)resourcesFolder);
        }
        String resourcesEnvVariablesPath = DKUFileUtils.getWithin((File)descFolder, (String[])new String[]{"actual", "resources_env.json"}).getAbsolutePath();
        String resourcesModelsMetaPath = DKUFileUtils.getWithin((File)descFolder, (String[])new String[]{"actual", "models_meta.json"}).getAbsolutePath();
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put("DKU_CODE_ENV_RESOURCES_PATH", resourcesFolder.getAbsolutePath());
        environmentVariables.put("DKU_CODE_ENV_RESOURCES_ENV_VARS_PATH", resourcesEnvVariablesPath);
        environmentVariables.put("DKU_CODE_ENV_RESOURCES_MODELS_META_PATH", resourcesModelsMetaPath);
        ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
        if ((nodeType == ApplicationConfigurator.DSSNodeType.DESIGN || nodeType == ApplicationConfigurator.DSSNodeType.AUTOMATION) && ((IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class)).isEnabled()) {
            environmentVariables.put("DKU_IMPERSONATION_ENABLED", "1");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(DKUFileUtils.getWithin((File)envFolder, (String[])new String[]{CodeEnvPackageSystems.pythonBinary}).getAbsolutePath());
        cmd.add(scriptPath);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(resourcesFolder);
        builder.environment().putAll(environmentVariables);
        builder.command(cmd);
        CodeEnvUtilsBase.addLogHeader(authCtx, log, "execute script in code environment " + envName + " : " + scriptPath, StringUtils.join(builder.command(), (String)" "));
        DKUtils.execAndLogThrowsMirror((ProcessBuilder)builder, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log);
    }

    public static boolean isAllowedToRunResourcesInitScript() throws IOException {
        boolean runGloballyAllowed = !DKUApp.getParams().getBoolParam("dku.codeEnvs.disableCodeEnvResourcesInitScript", false);
        ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
        if (nodeType == ApplicationConfigurator.DSSNodeType.DESIGN || nodeType == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            runGloballyAllowed = runGloballyAllowed && ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafeAutoTXN().security.enableCodeEnvResources;
        }
        return runGloballyAllowed;
    }

    public static boolean maybeRunResourcesInitScript(AuthCtx authCtx, String script, String envName, File descFolder, File envFolder, File resourcesFolder, DKUtils.SmartLogTailBuilder tailBuilder, File log, @Nullable InfoMessage.InfoMessages messages) throws IOException, InterruptedException {
        if (!PythonCodeEnvUtils.isAllowedToRunResourcesInitScript()) {
            if (!script.isEmpty()) {
                logger.warn((Object)"Resources initialization script exists, but running it has been forbidden by your administrator.");
                if (null != messages) {
                    messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_RESOURCES_INIT_SCRIPT_FORBIDDEN, "Running the code environment resources initialization script has been forbidden by your administrator.");
                }
            } else {
                logger.debug((Object)"Running the code environment resources initialization script has been forbidden by your administrator.");
            }
            return false;
        }
        if (!script.isEmpty()) {
            try (AutoDelete tmpScriptFile = new AutoDelete(DSSTempUtils.getTempFileNoCreate((String)"code-env-resources", (String)(envName + "-resources_init"), (String)"py"));){
                DKUFileUtils.writeFileUTF8((File)tmpScriptFile, (String)script);
                PythonCodeEnvUtils.executeResourcesInitScriptCommand(authCtx, tmpScriptFile.getAbsolutePath(), envName, descFolder, envFolder, resourcesFolder, tailBuilder, log);
            }
            return true;
        }
        logger.info((Object)"Resources initialization script is empty.");
        return false;
    }

    public static boolean maybeRunResourcesInitScript(AuthCtx authCtx, String envName, File descFolder, File envFolder, File resourcesFolder, DKUtils.SmartLogTailBuilder tailBuilder, File log, @Nullable InfoMessage.InfoMessages messages) throws IOException, InterruptedException {
        boolean scriptIsNotEmpty;
        File scriptFile = DKUFileUtils.getWithin((File)descFolder, (String[])new String[]{"spec", "resources_init.py"});
        boolean bl = scriptIsNotEmpty = scriptFile.isFile() && scriptFile.canRead() && scriptFile.length() > 0L;
        if (!PythonCodeEnvUtils.isAllowedToRunResourcesInitScript()) {
            if (scriptIsNotEmpty) {
                logger.warn((Object)"Resources initialization script exists, but running it has been forbidden by your administrator.");
                if (null != messages) {
                    messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_RESOURCES_INIT_SCRIPT_FORBIDDEN, "Running the code environment resources initialization script has been forbidden by your administrator.");
                }
            } else {
                logger.debug((Object)"Running the code environment resources initialization script has been forbidden by your administrator.");
            }
            return false;
        }
        if (scriptIsNotEmpty) {
            PythonCodeEnvUtils.executeResourcesInitScriptCommand(authCtx, scriptFile.getAbsolutePath(), envName, descFolder, envFolder, resourcesFolder, tailBuilder, log);
            return true;
        }
        logger.info((Object)("Code env resources initialization script does not exist: " + scriptFile.getAbsolutePath()));
        return false;
    }

    public static AddResourcesZipResult addResourcesZip(File resourcesFolder, String relativePath, InputStream resourcesInputStream, String resourcesFileName, boolean overwrite) throws IOException {
        if (!"zip".equals(FilenameUtils.getExtension((String)resourcesFileName))) {
            throw new IOException("File " + resourcesFileName + " is not a zip archive.");
        }
        String resourcesFilenameWithoutExt = FilenameUtils.removeExtension((String)resourcesFileName);
        File targetDirectory = DKUFileUtils.getWithinOrSame((File)resourcesFolder, (String[])new String[]{relativePath, resourcesFilenameWithoutExt});
        String targetDirectoryPath = targetDirectory.getCanonicalPath();
        if (!targetDirectory.exists()) {
            DKUFileUtils.mkdirs((File)targetDirectory);
        } else if (overwrite) {
            DKUFileUtils.forceDelete((File)targetDirectory);
            DKUFileUtils.mkdirs((File)targetDirectory);
        } else {
            throw new IOException("'" + targetDirectoryPath + "' already exists, and would be overwritten.");
        }
        logger.info((Object)("Start unzipping '" + resourcesFileName + "' contents to '" + targetDirectoryPath + "'."));
        DKUFileUtils.unzipInputStream((File)targetDirectory, (InputStream)resourcesInputStream);
        logger.info((Object)("Done unzipping '" + resourcesFileName + "' contents to '" + targetDirectoryPath + "'."));
        AddResourcesZipResult result = new AddResourcesZipResult();
        result.success = true;
        result.resourcePath = targetDirectoryPath;
        return result;
    }

    public static class AddResourcesZipResult {
        public boolean success;
        public String resourcePath;
    }
}

