/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.helpers;

import com.dataiku.dip.connections.helpers.RetryPolicyExecutor;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.base.Predicate;

public abstract class AbstractRetryPolicyExecutor
implements RetryPolicyExecutor {
    protected Predicate retryPredicate;
    protected int maxRetries = 100;
    protected int currentRetry = 0;
    protected int delayMs = 0;
    protected Double retryDelayMultiplier;
    protected static final int DEFAULT_MAX_RETRIES = 100;

    @Override
    public <E> AbstractRetryPolicyExecutor retryOn(Predicate<E> retryPredicate) {
        this.retryPredicate = retryPredicate;
        return this;
    }

    @Override
    public AbstractRetryPolicyExecutor withMaxRetries(int maxRetries) {
        Preconditions.checkArgument((maxRetries > 0 ? 1 : 0) != 0, (Object)"maxRetries must be greater than zero");
        this.maxRetries = maxRetries;
        return this;
    }

    @Override
    public AbstractRetryPolicyExecutor withDelay(int delayMs) {
        Preconditions.checkArgument((delayMs > 0 ? 1 : 0) != 0, (Object)"delay must be greater than zero");
        this.delayMs = delayMs;
        return this;
    }

    public AbstractRetryPolicyExecutor withDelayMultiplier(double multiplier) {
        Preconditions.checkArgument((multiplier > 1.0 ? 1 : 0) != 0, (Object)"retry multiplier must be greater than one");
        this.retryDelayMultiplier = multiplier;
        return this;
    }

    protected void throttle() throws InterruptedException {
        if (this.delayMs > 0) {
            Thread.sleep(this.delayMs);
            if (this.retryDelayMultiplier != null) {
                this.delayMs = (int)((double)this.delayMs * this.retryDelayMultiplier);
            }
        }
    }
}

