/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datadirectories;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.datadirectories.DataDirectoriesBucketer;
import com.dataiku.dip.datadirectories.DataDirectoriesFootprintHierarchy;
import com.dataiku.dip.datadirectories.DataDirectoriesFootprintModel;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Stopwatch;
import com.google.gson.reflect.TypeToken;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataDirectoriesFootprintService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.directories-footprint");
    @Autowired
    private FutureService futureService;

    public FutureResponse<DataDirectoriesFootprintModel.ProjectFootprint> getProjectFootprint(DSSAuthCtx ctx, String projectKey) throws Exception {
        return this.futureService.runFuture(new ProjectDataDirectoriesFutureThread(ctx, projectKey), 2000L, new TypeToken<FutureResponse<DataDirectoriesFootprintModel.ProjectFootprint>>(){});
    }

    public FutureResponse<DataDirectoriesFootprintModel.DatadirFootprint> getAllProjectsFootprint(DSSAuthCtx ctx, List<String> projects, boolean summaryOnly) throws Exception {
        return this.futureService.runFuture(new AllProjectsDataDirectoriesFutureThread(ctx, projects, summaryOnly), 2000L, new TypeToken<FutureResponse<DataDirectoriesFootprintModel.DatadirFootprint>>(){});
    }

    public FutureResponse<DataDirectoriesFootprintModel.DatadirFootprint> getOrphanProjectsFootprint(DSSAuthCtx ctx, List<String> projects, boolean summaryOnly) throws Exception {
        return this.futureService.runFuture(new OrphanProjectsDataDirectoriesFutureThread(ctx, projects, summaryOnly), 2000L, new TypeToken<FutureResponse<DataDirectoriesFootprintModel.DatadirFootprint>>(){});
    }

    public FutureResponse<DataDirectoriesFootprintModel.DatadirFootprint> getUnknownFootprint(DSSAuthCtx ctx, boolean summaryOnly) throws Exception {
        return this.futureService.runFuture(new UnknownDataDirectoriesFutureThread(ctx, summaryOnly), 2000L, new TypeToken<FutureResponse<DataDirectoriesFootprintModel.DatadirFootprint>>(){});
    }

    public FutureResponse<DataDirectoriesFootprintModel.DatadirFootprint> getAllDSSFootprint(DSSAuthCtx ctx, List<String> projectKeys) throws Exception {
        return this.futureService.runFuture(new AllDSSDirectoriesFutureThread(ctx, projectKeys), 2000L, new TypeToken<FutureResponse<DataDirectoriesFootprintModel.DatadirFootprint>>(){});
    }

    public FutureResponse<DataDirectoriesFootprintModel.DatadirFootprint> getGlobalFootprint(DSSAuthCtx ctx) throws Exception {
        return this.futureService.runFuture(new GlobalDataDirectoriesFutureThread(ctx), 2000L, new TypeToken<FutureResponse<DataDirectoriesFootprintModel.DatadirFootprint>>(){});
    }

    private static class ProjectDataDirectoriesFutureThread
    extends AbstractDataDirectoriesFutureThread<DataDirectoriesFootprintModel.ProjectFootprint> {
        public ProjectDataDirectoriesFutureThread(DSSAuthCtx owner, String projectKey) {
            super(owner, false);
            ((DataDirectoriesFootprintModel.ProjectFootprint)this.computed).projectKey = projectKey;
        }

        @Override
        DataDirectoriesFootprintModel.ProjectFootprint makeComputed() {
            return new DataDirectoriesFootprintModel.ProjectFootprint();
        }

        @Override
        String getFootprintTypeDesc() {
            return "single_project_data";
        }

        @Override
        String makeFootprintDesc() {
            return "project " + ((DataDirectoriesFootprintModel.ProjectFootprint)this.computed).projectKey + " data";
        }

        @Override
        DataDirectoriesBucketer.Bucket makeHierarchy() {
            return DataDirectoriesFootprintHierarchy.buildSingleProjectDatadirHierarchy((DataDirectoriesFootprintModel.ProjectFootprint)this.computed);
        }

        @Override
        void trimToSummary() {
        }
    }

    private static class AllProjectsDataDirectoriesFutureThread
    extends AbstractDataDirectoriesFutureThread<DataDirectoriesFootprintModel.DatadirFootprint> {
        private final List<String> projectKeys;

        public AllProjectsDataDirectoriesFutureThread(DSSAuthCtx owner, List<String> projectKeys, boolean summaryOnly) {
            super(owner, summaryOnly);
            this.projectKeys = projectKeys;
        }

        @Override
        DataDirectoriesFootprintModel.DatadirFootprint makeComputed() {
            DataDirectoriesFootprintModel.DatadirFootprint footprint = new DataDirectoriesFootprintModel.DatadirFootprint();
            footprint.projects = new DataDirectoriesFootprintModel.Sizes();
            return footprint;
        }

        @Override
        String getFootprintTypeDesc() {
            return "all_projects_data";
        }

        @Override
        String makeFootprintDesc() {
            return "all projects' DSS data directories";
        }

        @Override
        DataDirectoriesBucketer.Bucket makeHierarchy() {
            return DataDirectoriesFootprintHierarchy.buildAllProjectsDatadirHierarchy(((DataDirectoriesFootprintModel.DatadirFootprint)this.computed).projects.items, this.projectKeys);
        }

        @Override
        void trimToSummary() {
            DataDirectoriesFootprintModel.trimToSummary(((DataDirectoriesFootprintModel.DatadirFootprint)this.computed).projects);
        }
    }

    private static class OrphanProjectsDataDirectoriesFutureThread
    extends AbstractDataDirectoriesFutureThread<DataDirectoriesFootprintModel.DatadirFootprint> {
        private final List<String> projectKeys;

        public OrphanProjectsDataDirectoriesFutureThread(DSSAuthCtx owner, List<String> projectKeys, boolean summaryOnly) {
            super(owner, summaryOnly);
            this.projectKeys = projectKeys;
        }

        @Override
        DataDirectoriesFootprintModel.DatadirFootprint makeComputed() {
            DataDirectoriesFootprintModel.DatadirFootprint footprint = new DataDirectoriesFootprintModel.DatadirFootprint();
            footprint.orphanProjects = new DataDirectoriesFootprintModel.Sizes();
            return footprint;
        }

        @Override
        String getFootprintTypeDesc() {
            return "orphan_projects_data";
        }

        @Override
        String makeFootprintDesc() {
            return "orphaned projects";
        }

        @Override
        DataDirectoriesBucketer.Bucket makeHierarchy() {
            return DataDirectoriesFootprintHierarchy.buildOrphanProjectsDatadirHierarchy(((DataDirectoriesFootprintModel.DatadirFootprint)this.computed).orphanProjects.items, this.projectKeys);
        }

        @Override
        void trimToSummary() {
            DataDirectoriesFootprintModel.trimToSummary(((DataDirectoriesFootprintModel.DatadirFootprint)this.computed).orphanProjects);
        }
    }

    private static class UnknownDataDirectoriesFutureThread
    extends AbstractDataDirectoriesFutureThread<DataDirectoriesFootprintModel.DatadirFootprint> {
        public UnknownDataDirectoriesFutureThread(DSSAuthCtx owner, boolean summaryOnly) {
            super(owner, summaryOnly);
        }

        @Override
        DataDirectoriesFootprintModel.DatadirFootprint makeComputed() {
            DataDirectoriesFootprintModel.DatadirFootprint footprint = new DataDirectoriesFootprintModel.DatadirFootprint();
            footprint.unknown = new DataDirectoriesFootprintModel.Sizes();
            return footprint;
        }

        @Override
        String getFootprintTypeDesc() {
            return "unknown_data";
        }

        @Override
        String makeFootprintDesc() {
            return "unknown data directories";
        }

        @Override
        DataDirectoriesBucketer.Bucket makeHierarchy() {
            return DataDirectoriesFootprintHierarchy.buildUnknownDatadirHierarchy(((DataDirectoriesFootprintModel.DatadirFootprint)this.computed).unknown.items);
        }

        @Override
        void trimToSummary() {
            DataDirectoriesFootprintModel.trimToSummary(((DataDirectoriesFootprintModel.DatadirFootprint)this.computed).unknown);
        }
    }

    private static class AllDSSDirectoriesFutureThread
    extends AbstractDataDirectoriesFutureThread<DataDirectoriesFootprintModel.DatadirFootprint> {
        private final List<String> projectKeys;

        public AllDSSDirectoriesFutureThread(DSSAuthCtx owner, List<String> projectKeys) {
            super(owner, false);
            this.projectKeys = projectKeys;
        }

        @Override
        DataDirectoriesFootprintModel.DatadirFootprint makeComputed() {
            return new DataDirectoriesFootprintModel.DatadirFootprint();
        }

        @Override
        String getFootprintTypeDesc() {
            return "all_data";
        }

        @Override
        String makeFootprintDesc() {
            return "all data";
        }

        @Override
        DataDirectoriesBucketer.Bucket makeHierarchy() {
            return DataDirectoriesFootprintHierarchy.buildAllDSSDatadirHierarchy((DataDirectoriesFootprintModel.DatadirFootprint)this.computed, this.projectKeys);
        }

        @Override
        void trimToSummary() {
        }
    }

    private static class GlobalDataDirectoriesFutureThread
    extends AbstractDataDirectoriesFutureThread<DataDirectoriesFootprintModel.DatadirFootprint> {
        public GlobalDataDirectoriesFutureThread(DSSAuthCtx owner) {
            super(owner, false);
        }

        @Override
        DataDirectoriesFootprintModel.DatadirFootprint makeComputed() {
            return new DataDirectoriesFootprintModel.DatadirFootprint();
        }

        @Override
        String getFootprintTypeDesc() {
            return "global_data";
        }

        @Override
        String makeFootprintDesc() {
            return "global DSS data directories";
        }

        @Override
        DataDirectoriesBucketer.Bucket makeHierarchy() {
            return DataDirectoriesFootprintHierarchy.buildGlobalDatadirHierarchy((DataDirectoriesFootprintModel.DatadirFootprint)this.computed);
        }

        @Override
        void trimToSummary() {
        }
    }

    static abstract class AbstractDataDirectoriesFutureThread<F extends DataDirectoriesFootprintModel.Size>
    extends FutureThread<F> {
        protected final F computed;
        protected final FuturePayload futurePayload;
        protected final boolean summaryOnly;

        public AbstractDataDirectoriesFutureThread(DSSAuthCtx owner, boolean summaryOnly) {
            super(owner);
            this.summaryOnly = summaryOnly;
            this.computed = this.makeComputed();
            this.futurePayload = FuturePayload.newSimple((String)this.getFootprintTypeDesc(), (String)("Computing the footprint of " + this.makeFootprintDesc()));
        }

        abstract F makeComputed();

        abstract String getFootprintTypeDesc();

        abstract String makeFootprintDesc();

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public F getResult() {
            return this.computed;
        }

        abstract DataDirectoriesBucketer.Bucket makeHierarchy();

        abstract void trimToSummary();

        public void execute() throws Exception {
            logger.infoV("Computing directories footprint of %s", new Object[]{this.makeFootprintDesc()});
            DataDirectoriesBucketer.Bucket hierarchy = this.makeHierarchy();
            Stopwatch watch = Stopwatch.createStarted();
            Path datadirRootPath = DKUApp.getBaseFolderF().toPath();
            FileVisitor<Path> visitor = DataDirectoriesFootprintHierarchy.buildVisitor(datadirRootPath, hierarchy);
            DataDirectoriesFootprintHierarchy.defaultWalker.walk(datadirRootPath, visitor);
            long duration = watch.elapsed(TimeUnit.SECONDS);
            logger.infoV("Footprint computed in %s seconds", new Object[]{duration});
            DataDirectoriesFootprintModel.computeTotals(this.computed);
            if (this.summaryOnly) {
                this.trimToSummary();
            }
        }
    }
}

