/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.CandidateSelectorPipeline;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.Node;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.selectionexecutors.CandidateSelectionAlgorithm;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.selectionexecutors.SelectionExecutor;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.selectionexecutors.SelectionExecutorFactory;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

class Stage
implements Comparable<Stage> {
    private final CandidateSelectorPipeline pipeline;
    private final List<Integer> indexesJoinValues;
    private final List<FuzzyJoinRecipePayloadParams.FuzzyMatchDesc> matchDescs;
    private final CandidateSelectionAlgorithm candidateSelectionAlgorithm;
    protected List<String> joinValues;
    protected Queue<Node> inputQueue;
    protected final Queue<Node> outputQueue;
    protected final List<SelectionExecutor> selectionExecutors;
    public boolean waiting = true;
    public Stage nextStage;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipe.fuzzyjoin.builtin.selector");

    public Stage(CandidateSelectorPipeline pipeline, CandidateSelectionAlgorithm candidateSelectionAlgorithm, List<Integer> indexesJoinValues, List<FuzzyJoinRecipePayloadParams.FuzzyMatchDesc> matchDescs) {
        this.pipeline = pipeline;
        this.candidateSelectionAlgorithm = candidateSelectionAlgorithm;
        this.indexesJoinValues = indexesJoinValues;
        this.matchDescs = matchDescs;
        this.inputQueue = new LinkedList<Node>();
        this.outputQueue = new LinkedList<Node>();
        this.selectionExecutors = new ArrayList<SelectionExecutor>();
        this.makeNewSelectionExecutor();
    }

    @Override
    public int compareTo(Stage otherStage) {
        return this.candidateSelectionAlgorithm.compareTo(otherStage.candidateSelectionAlgorithm);
    }

    public void processInputs() {
        while (!this.inputQueue.isEmpty()) {
            Node inputNode = this.inputQueue.poll();
            if (inputNode == null) continue;
            if (inputNode.isStartSignal()) {
                this.initializeJoinValues();
                this.write(inputNode);
                continue;
            }
            if (inputNode.isStopSignal()) {
                this.write(inputNode);
                continue;
            }
            if (this.pipeline.isBuilding) {
                this.build(inputNode);
                continue;
            }
            this.search(inputNode);
        }
    }

    private void write(Node node) {
        this.outputQueue.add(node);
    }

    private void initializeJoinValues() {
        this.joinValues = new ArrayList<String>();
        for (int idxJoinValue : this.indexesJoinValues) {
            this.joinValues.add(this.pipeline.target.getJoinValue(idxJoinValue));
        }
    }

    private int makeNewSelectionExecutor() {
        this.selectionExecutors.add(SelectionExecutorFactory.getSelectionExecutor(this.candidateSelectionAlgorithm, this.matchDescs));
        return this.selectionExecutors.size() - 1;
    }

    private void build(Node inputNode) {
        if (!inputNode.isChained()) {
            inputNode.nextAccessPoint = this.makeNewSelectionExecutor();
        }
        SelectionExecutor selectionExecutor = this.selectionExecutors.get(inputNode.nextAccessPoint);
        for (Node outputNode : selectionExecutor.addJoinValues(this.joinValues)) {
            this.write(outputNode);
        }
    }

    private void search(Node inputNode) {
        this.outputQueue.addAll(this.getValidNodes(inputNode.nextAccessPoint));
    }

    private List<Node> getValidNodes(int accessPoint) {
        return this.selectionExecutors.get(accessPoint).searchValidNodes(this.joinValues);
    }

    public String toString() {
        return "Stage{candidateSelectionAlgorithm=" + String.valueOf((Object)this.candidateSelectionAlgorithm) + ", indexesJoinValues=" + String.valueOf(this.indexesJoinValues) + "}";
    }
}

