/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.pivot.AbstractPivotRecipeSQLlikeExecutor;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.sql.NonLoopingSQLEngineVisualRecipeRunner;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class PivotRecipeSQLExecutor
extends AbstractPivotRecipeSQLlikeExecutor {
    private static Logger logger = Logger.getLogger((String)"dip.recipe.pivot.sql.executor");

    public PivotRecipeSQLExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, JobActivity activity, PivotRecipePayloadParams params) {
        super(engine, activity, params);
    }

    @Override
    protected SQLUtils.SQLTable getSQLTable() throws IOException, SQLException, DKUSecurityException {
        return DatasetUtils.getResolvedTableWithSparkSQLFallback(this.inputDS, this.getInputDialect(), this.params.engineParams);
    }

    @Override
    protected void execute(final List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities) throws Exception {
        final NonLoopingSQLEngineVisualRecipeRunner sqlRunner = new NonLoopingSQLEngineVisualRecipeRunner(this.activity){

            @Override
            protected QueryBunch getQueryBunch(AbstractSQLConnection conn) throws IOException, SQLException, DKUSecurityException {
                return new QueryBunch(PivotRecipeSQLExecutor.this.generateSQL(pivotElementsModalities, conn.getDialect()));
            }
        };
        try (AutoCloseable hook = this.startAbortableTask(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Aborting pivoting query");
                sqlRunner.notifyBeforeAborting();
            }
        });){
            sqlRunner.init();
            sqlRunner.run();
        }
    }

    @Override
    protected SQLDialect getInputDialect() throws IOException, SQLException, DKUSecurityException {
        return this.getInputSQLConnection().getDialect();
    }

    @Override
    protected SQLDialect getOutputDialect() throws IOException, SQLException, DKUSecurityException {
        SQLDialect dialect = DatasetInspector.isSQLOrHive(this.outputDS) ? SQLConnectionProvider.getConnectionDialect(this.authCtxService.getAuthCtx(), this.outputDS.serialize()) : null;
        return dialect;
    }

    @Override
    protected AbstractSQLConnection getInputSQLConnection() throws IOException, SQLException, DKUSecurityException {
        String inputDSConnection = DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(this.authCtxService.getAuthCtx(), this.inputDS);
        return SQLConnectionProvider.getDSSConnection(this.authCtxService.getAuthCtx(), inputDSConnection);
    }
}

