/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sampling;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.FSSubgraphHelper;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.PeriodicObserver;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeExecutor;
import com.dataiku.dip.dataflow.exec.stream.ParallelStreamControlRunnable;
import com.dataiku.dip.dataflow.exec.stream.ParallelStreamSlaveRunnable;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datalayer.utils.FilterProcessorOutput;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.stream.ParallelStreamer;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.utils.NotImplementedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FSToAnySamplingExecutor
extends SISORecipeExecutor
implements SamplingRecipeExecutor,
PeriodicObserver {
    private List<FlowRunnable> runnables = new ArrayList<FlowRunnable>();
    private ParallelStreamControlRunnable control;
    private SerializedJobActivityStatus.SerializedSourceDS sourceStatus;
    private SerializedJobActivityStatus.SerializedTargetDS targetStatus;
    private List<InputSplitProgressListener> streamListeners = new ArrayList<InputSplitProgressListener>();
    private List<ToDatasetStreamer> writers = new ArrayList<ToDatasetStreamer>();
    private FilePartitioner.ResolvedFilesFilterResult filterResult;
    private ParallelStreamer ps;
    private FilterDesc filterDesc;
    private DatasetSelection selection;
    private int maxThreads;
    private DatasetHandler datasetHandler;
    static Logger logger = Logger.getLogger((String)"dku.flow.fstoany");

    public FSToAnySamplingExecutor(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @Override
    public void setFilter(FilterDesc filterDesc) {
        this.filterDesc = filterDesc;
    }

    @Override
    public void setSelection(StreamableDatasetSelection selection) {
        this.selection = selection;
    }

    @Override
    public void init(JobActivity activity, Output.WriteMode writeMode) throws Exception {
        super.init(activity, writeMode);
        if (this.filterDesc != null) {
            this.filterDesc = this.expandFilter(this.filterDesc);
        }
        this.datasetHandler = DatasetHandlerFactory.build(this.authCtx, this.inputDS);
        AbstractFSDatasetHandler fsdh = (AbstractFSDatasetHandler)this.datasetHandler;
        this.filterResult = FSSubgraphHelper.getInputFiles(this.authCtx, this.inputPartitions, this.inputDS);
        this.sourceStatus = activity.getSourceStatus(this.inputDS.getFullName());
        this.sourceStatus.statsType = SerializedJobActivityStatus.SourceStatsType.FILES_WITH_GLOBAL_PROGRESS;
        this.targetStatus = activity.getTargetStatus(this.outputDS.getFullName());
        if (this.filterResult.getAllPaths().size() == 0) {
            logger.warn((Object)"No file to process, bailing out");
            try (DatasetHandler outputHandler = DatasetHandlerFactory.build(this.authCtx, this.outputDS);){
                DatasetUtils.performWriteOfZeroRows(outputHandler, this.outputPartition, activity.warnContext, this.writeMode);
            }
            return;
        }
        int threads = this.filterResult.getAllPaths().size();
        logger.info((Object)("Potential threadability " + threads));
        if (this.maxThreads > 0 && this.maxThreads < threads) {
            threads = this.maxThreads;
        }
        logger.info((Object)("Actual threadability " + threads));
        StreamColumnFactory scf = new StreamColumnFactory();
        this.ps = new ParallelStreamer(fsdh, this.filterResult.matchingFilePartitions, threads);
        this.control = new ParallelStreamControlRunnable(this.ps);
        for (int i = 0; i < threads; ++i) {
            StreamRowFactory srf = new StreamRowFactory();
            ParallelStreamSlaveRunnable from = new ParallelStreamSlaveRunnable(this.authCtx, this.inputDS, this.ps.getRunner(i), this.warnContext);
            this.streamListeners.add(from.listener);
            ToDatasetStreamer to = ToDatasetStreamer.newToSpecificSplit(this.authCtx, this.outputDS, this.outputPartition, i, (ColumnFactory)scf, this.warnContext, this.writeMode);
            this.writers.add(to);
            Object out = to.getAsOutput();
            if (this.selection != null && this.selection.samplingMethod != SamplingParam.SamplingMethod.FULL) {
                throw new NotImplementedException("Multithreaded FS to any executor does not support sampling");
            }
            if (this.filterDesc != null && this.filterDesc.enabled && StringUtils.isNotBlank((String)FilterDescUtils.getGrelExpression(this.filterDesc))) {
                out = new FilterProcessorOutput((ProcessorOutput)out, (ColumnFactory)scf, this.filterDesc, this.inputDS.getSchema());
            }
            from.setOutput("main", (ProcessorOutput)out);
            from.setFactories((ColumnFactory)scf, (RowFactory)srf);
            this.runnables.add(from);
        }
    }

    @Override
    public void run() throws Exception {
        if (this.control != null) {
            this.control.run();
        }
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return this.runnables;
    }

    @Override
    public synchronized void onInterval() throws IOException {
        this.sourceStatus.totalReadBytes = 0L;
        this.sourceStatus.totalReadRecords = 0L;
        for (InputSplitProgressListener listener : this.streamListeners) {
            this.sourceStatus.totalReadBytes += listener.getCompressedBytes();
            this.sourceStatus.totalReadRecords += listener.getReadRecords();
        }
        this.targetStatus.partition.writtenBytes = 0L;
        this.targetStatus.partition.writtenRecords = 0L;
        for (ToDatasetStreamer writer : this.writers) {
            this.targetStatus.partition.writtenBytes += writer.getWrittenBytes();
            this.targetStatus.partition.writtenRecords += writer.writtenRows;
        }
    }

    @Override
    public void onEnd(boolean isSuccess) throws IOException {
        this.onInterval();
        if (this.datasetHandler != null) {
            try {
                this.datasetHandler.close();
            }
            finally {
                this.datasetHandler = null;
            }
        }
    }
}

