/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sort;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.AbstractStagedThreadedBuiltinRunner;
import com.dataiku.dip.dataflow.exec.ComputedColumnUtils;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.sort.SortRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.topn.TopNer;
import com.dataiku.dip.shaker.processors.transform.ColumnRenamer;
import com.dataiku.dip.shaker.processors.transform.FindReplace;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SortRecipeBuiltinRunner
extends AbstractStagedThreadedBuiltinRunner {
    private SortRecipePayloadParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sort");

    public SortRecipeBuiltinRunner(JobActivity activity, SortRecipePayloadParams params) {
        super(activity);
        this.params = params;
    }

    @Override
    public List<AbstractInitializedRunner.Output> prepareStages(File tempDirectory) throws Exception {
        assert (this.inputs.containsKey("main"));
        assert (!((List)this.inputs.get("main")).isEmpty());
        assert (this.outputs.containsKey("main"));
        assert (!((List)this.outputs.get("main")).isEmpty());
        AbstractInitializedRunner.Input input = (AbstractInitializedRunner.Input)((List)this.inputs.get("main")).get(0);
        AbstractInitializedRunner.Output output = (AbstractInitializedRunner.Output)((List)this.outputs.get("main")).get(0);
        if (this.params.preFilter != null && this.params.preFilter.distinct) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.KeepDistinctRowsThread(input.schema, new File(tempDirectory, "prefilter")));
        }
        if (FilterDescUtils.willFilter(this.params.preFilter)) {
            GrelExpression preFilterExpression = FilterDescUtils.getGrelFilterExpression(this.params.preFilter);
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.FilteringThread(preFilterExpression));
        }
        Schema schemaAfterComputedCols = new Schema(input.schema);
        if (this.params.computedColumns != null && !this.params.computedColumns.isEmpty()) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.ComputedColumnsThread(this.params.computedColumns));
            for (ComputedColumn computedColumn : this.params.computedColumns) {
                ComputedColumnUtils.addToSchema(schemaAfterComputedCols, computedColumn);
            }
        }
        TopNRecipePayloadParams topnerParams = new TopNRecipePayloadParams();
        topnerParams.engineParams = this.params.engineParams;
        topnerParams.enginesPreferences = this.params.enginesPreferences;
        topnerParams.engineType = this.params.engineType;
        topnerParams.preFilter = this.params.preFilter;
        topnerParams.orders = Lists.newArrayList();
        for (SortRecipePayloadParams.Order order : this.params.orders) {
            TopNRecipePayloadParams.Order topnerOrder = new TopNRecipePayloadParams.Order();
            topnerOrder.column = order.column;
            topnerOrder.desc = order.desc;
            topnerParams.orders.add(topnerOrder);
        }
        topnerParams.duplicateCount = false;
        topnerParams.rowNumber = this.params.rowNumber;
        topnerParams.rank = this.params.rank;
        topnerParams.denseRank = this.params.denseRank;
        topnerParams.outputColumnNameOverrides = this.params.outputColumnNameOverrides;
        TopNer topNer = new TopNer(topnerParams, new File(tempDirectory, "sorter"), this.mergeSortParams, true);
        TopNerThread topnerStage = new TopNerThread(topNer, schemaAfterComputedCols);
        this.stages.add(topnerStage);
        if (this.params.outputColumnNameOverrides != null && !this.params.outputColumnNameOverrides.isEmpty()) {
            ColumnRenamer.Parameter rp = new ColumnRenamer.Parameter();
            for (String from : this.params.outputColumnNameOverrides.keySet()) {
                String to = this.params.outputColumnNameOverrides.get(from);
                if (!StringUtils.isNotBlank((String)from) || !StringUtils.isNotBlank((String)to)) continue;
                rp.renamings.add(new FindReplace.Substitution(from, to));
            }
            ColumnRenamer columnRenamer = new ColumnRenamer(rp);
            columnRenamer.setColumnFactory((ColumnFactory)output.cf);
            columnRenamer.init();
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.RenamingThread(columnRenamer, schemaAfterComputedCols));
        }
        return Lists.newArrayList((Object[])new AbstractInitializedRunner.Output[]{output});
    }

    private class TopNerThread
    extends AbstractStagedThreadedBuiltinRunner.ComputationStage {
        private final TopNer topner;
        private final Schema inputSchema;
        private ColumnFactory inputCf;
        private RowInputStream input;
        private ColumnFactory outputCf;
        private RowFactory outputRf;
        private ProcessorOutput output;
        private Throwable exception;

        TopNerThread(TopNer sortRanker, Schema inputSchema) {
            this.topner = sortRanker;
            this.inputSchema = inputSchema;
        }

        @Override
        public void setInputFactories(ColumnFactory cf, RowFactory rf, RowInputStream input) {
            this.inputCf = cf;
            this.input = input;
        }

        @Override
        public void setOutputFactories(ColumnFactory cf, RowFactory rf, ProcessorOutput output) {
            this.outputCf = cf;
            this.outputRf = rf;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                this.topner.compute(this.input, this.inputCf, this.inputSchema, this.output, this.outputCf, this.outputRf, null);
                this.output.lastRowEmitted();
            }
            catch (InterruptedException e) {
                logger.info((Object)"Interrupted sort stage");
                try {
                    this.topner.cancel();
                }
                catch (Exception e1) {
                    this.exception = e1;
                }
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error((Object)"Sort stage failed", (Throwable)e);
                SortRecipeBuiltinRunner.this.interruptStages();
                try {
                    this.output.cancel();
                }
                catch (Exception e1) {
                    logger.error((Object)"Failed to cleanup resources", (Throwable)e1);
                }
                this.exception = e;
            }
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }
    }
}

