/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeExecutor;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.utils.CountingProcessorOutput;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.server.SpringUtils;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSplitRecipeExecutor
implements SplitRecipeExecutor {
    @Autowired
    protected JobAuthCtxService authCtxService;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    protected JobActivity activity;
    protected FlowRecipe recipe;
    protected SplitRecipePayloadParams params;
    protected boolean lowerCaseColumns;
    protected Dataset inputDS;
    protected List<Partition> sourcePartitions;
    protected static Logger logger = Logger.getLogger((String)"dku.recipe.split");

    public AbstractSplitRecipeExecutor(JobActivity activity, SplitRecipePayloadParams params, boolean lowerCaseColumns) {
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.activity.initStatus();
        this.params = params;
        this.lowerCaseColumns = lowerCaseColumns;
    }

    @Override
    public void init() throws Exception {
        FlowDataset inputFD = this.activity.getSubgraph().getSingleSourceDataset();
        this.inputDS = inputFD.getMandatory(this.datasetsDAO);
        this.sourcePartitions = this.activity.getSubgraph().getSourcePartitions(inputFD);
    }

    @Override
    public abstract void run() throws Exception;

    public long getTotalRecordsWithFilters() throws Exception {
        try (DatasetHandler dh = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), this.inputDS);){
            long total = 0L;
            if (!(this.params.preFilter != null && FilterDescUtils.willFilter(this.params.preFilter) || this.sourcePartitions != null)) {
                logger.info((Object)"Counting records...");
                total = dh.getRecords();
            } else if (this.params.preFilter == null || !FilterDescUtils.willFilter(this.params.preFilter)) {
                logger.info((Object)"Counting records...");
                try (FutureProgress.AutocloseableFutureProgressState computing = FutureProgress.pushAutoCloseableState((String)"Counting records");){
                    for (Partition p : this.sourcePartitions) {
                        total += dh.getPartitionRecords(p);
                    }
                }
            } else {
                assert (FilterDescUtils.willFilter(this.params.preFilter));
                StreamableDatasetSelection newSel = StreamableDatasetSelection.full();
                newSel.filter = this.params.preFilter;
                if (this.sourcePartitions != null) {
                    newSel.withSelectedPartitions(this.sourcePartitions);
                }
                logger.info((Object)"Counting records using full-push-with-filter...");
                StreamColumnFactory scf = new StreamColumnFactory();
                StreamRowFactory srf = new StreamRowFactory();
                CountingProcessorOutput counting = new CountingProcessorOutput();
                UniversalSingleThreadPusher.push(this.authCtxService.getAuthCtx(), this.inputDS, newSel, (ProcessorOutput)counting, (ColumnFactory)scf, (RowFactory)srf);
                total = counting.getCount();
            }
            logger.info((Object)("...Finished counting records. Number of rows found: " + total));
            long l = total;
            return l;
        }
    }

    @Override
    public void notifyBeforeAborting() {
    }
}

