/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToCloud;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PathUtils;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class SnowflakeToS3
extends SnowflakeToCloud<S3DatasetHandler> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.snowflaketos3");

    public static void setCompatible(Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) {
        status.isSelectable = true;
        try {
            SnowflakeToS3.checkCompatible(inputDS, outputDS, "S3");
        }
        catch (SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    protected String getTemporaryTablePrefix() {
        return "synctos3";
    }

    @Override
    protected String generateCopyStatementToCloud(String inputTableFullName, String outputFSPath, CloudToSnowflake.CopyMode mode, S3DatasetHandler blobDSHandler, StringBuilder displayableSql) throws IOException, DKUSecurityException {
        String displayCreds;
        String creds;
        EC2Connection outputConnection = blobDSHandler.getConnection();
        EC2Connection.S3FastPathCredentials s3Credentials = outputConnection.getS3CredentialsForFastPath(this.authCtx);
        if (outputFSPath.startsWith("@")) {
            creds = "";
            displayCreds = "";
        } else if (StringUtils.isNotBlank((String)outputConnection.params.snowflakeStorageIntegration)) {
            SnowflakeSQLDialect dialect = new SnowflakeSQLDialect();
            displayCreds = creds = String.format("   STORAGE_INTEGRATION=%s", dialect.quoteIdentifier(outputConnection.params.snowflakeStorageIntegration));
        } else {
            logger.info((Object)("Using access key: " + s3Credentials.getAccessKey()));
            creds = String.format("   CREDENTIALS=(%s)", s3Credentials.getCredentialStringForSnowflake());
            displayCreds = "   CREDENTIALS=(****)";
        }
        String copyQueryPattern = "COPY INTO '%s' FROM %s %s   %s   FILE_FORMAT = (%s)   OVERWRITE = TRUE %s";
        displayableSql.append(String.format(copyQueryPattern, outputFSPath, inputTableFullName, mode.generateFromSnowflakeCommonOptions(), displayCreds, mode.generateFormatOptions(), this.getEncryption(s3Credentials)));
        return String.format(copyQueryPattern, outputFSPath, inputTableFullName, mode.generateFromSnowflakeCommonOptions(), creds, mode.generateFormatOptions(), this.getEncryption(s3Credentials));
    }

    private String getEncryption(EC2Connection.S3FastPathCredentials s3Credentials) {
        EC2Connection.Params params = s3Credentials.getEC2Params();
        if (params == null || S3DatasetHandler.EncryptionMode.NONE.equals((Object)params.encryptionMode)) {
            return "";
        }
        if (S3DatasetHandler.EncryptionMode.SSE_S3.equals((Object)params.encryptionMode)) {
            return " ENCRYPTION = (TYPE = 'AWS_SSE_S3')";
        }
        if (S3DatasetHandler.EncryptionMode.SSE_KMS.equals((Object)params.encryptionMode)) {
            if (StringUtils.isBlank((String)params.encryptionKeyId)) {
                return " ENCRYPTION = (TYPE = 'AWS_SSE_KMS')";
            }
            return " ENCRYPTION = (TYPE = 'AWS_SSE_KMS' KMS_KEY_ID = '" + params.encryptionKeyId + "')";
        }
        throw new UnsupportedOperationException("Encryption method not supported");
    }

    @Override
    protected String createDestinationRootUri(S3DatasetHandler s3dh) throws IOException, DKUSecurityException, CodedException {
        return PathUtils.slashes((String)s3dh.getRootPathForSnowflakeFastPath(), null, (Boolean)true, (boolean)false, null);
    }
}

