/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.window;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.recipes.WindowRecipeService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class WindowRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private WindowRecipeService service;
    @Autowired
    private VisualSQLRecipesBaseService visualRecipesService;
    @Autowired
    private TransactionService transactionService;
    private WindowRecipePayloadParams params;
    private static Logger logger = Logger.getLogger((String)"dip.window");

    public WindowRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.params = this.service.loadParams(payload, this.recipe);
    }

    public void setParams(WindowRecipePayloadParams params) {
        this.params = params;
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getSchema()});
            return arrayList;
        }
    }

    private Schema getSchema() throws Exception {
        AnyLoc inputLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.projectKey);
        Dataset inputDataset = this.datasetAccessService.getMandatory(inputLoc);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = this.visualRecipesService.getEngine(this.authCtx, this.activity, this.params, this.params.engineType);
        boolean lowerCase = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
        SQLDialect dialect = this.visualRecipesService.getDialect(this.authCtx, this.activity, selectedEngine);
        return this.service.getOutputSchemaAfterOverride(inputDataset, this.params, lowerCase, dialect);
    }

    @Override
    public boolean canUpdateRecipe() {
        return true;
    }

    @Override
    public RecipeSchemaService.RecipeSchemaAutoupdateResult updateRecipe_NT(JsonObject optionsObj) throws Exception {
        Schema inputSchema;
        logger.info((Object)("update recipe options=" + JSON.json((Object)optionsObj)));
        WindowRecipeUpdateOptions options = optionsObj == null ? new WindowRecipeUpdateOptions() : (WindowRecipeUpdateOptions)JSON.parse((JsonElement)optionsObj, WindowRecipeUpdateOptions.class);
        RecipeSchemaService.RecipeSchemaAutoupdateResult ret = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        try (Transaction t = this.transactionService.beginRead();){
            Iterator<ComputedColumn> inputLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.projectKey);
            Dataset dataset = this.datasetAccessService.getMandatory((AnyLoc)((Object)inputLoc));
            inputSchema = dataset.getSchema();
        }
        HashMap columns = Maps.newHashMap();
        for (SchemaColumn schemaColumn : inputSchema.columns) {
            columns.put(schemaColumn.getName(), schemaColumn);
        }
        for (ComputedColumn computedColumn : this.params.computedColumns) {
            columns.put(computedColumn.name, new SchemaColumn(computedColumn.name, Type.forName((String)computedColumn.type)));
        }
        if (options.removeMissingInWindow) {
            int windowNo = 0;
            for (WindowRecipePayloadParams.WindowDesc window : this.params.windows) {
                ArrayList keysToRemove;
                if (window.enablePartitioning) {
                    keysToRemove = Lists.newArrayList();
                    for (String column : window.partitioningColumns) {
                        if (columns.containsKey(column)) continue;
                        keysToRemove.add(column);
                    }
                    logger.info((Object)("found " + keysToRemove.size() + " partitioning keys to remove in window " + windowNo));
                    if (!keysToRemove.isEmpty()) {
                        window.partitioningColumns.removeAll(keysToRemove);
                        ret.recipeChanges.add(String.format("Removed %s from partitioning keys", JSON.json((Object)keysToRemove)));
                    }
                }
                if (window.enableOrdering) {
                    keysToRemove = Lists.newArrayList();
                    for (WindowRecipePayloadParams.Order order : window.orders) {
                        if (columns.containsKey(order.column)) continue;
                        keysToRemove.add(order);
                    }
                    logger.info((Object)("found " + keysToRemove.size() + " ordering keys to remove in window " + windowNo));
                    if (!keysToRemove.isEmpty()) {
                        window.orders.removeAll(keysToRemove);
                        ArrayList keyColumnsToRemove = Lists.newArrayList();
                        for (WindowRecipePayloadParams.Order o : keysToRemove) {
                            keyColumnsToRemove.add(o.column);
                        }
                        ret.recipeChanges.add(String.format("Removed %s from ordering keys", JSON.json((Object)keyColumnsToRemove)));
                    }
                }
                ++windowNo;
            }
        }
        if (options.removeMissingAggregates) {
            ArrayList valuesToRemove = Lists.newArrayList();
            for (WindowRecipePayloadParams.WindowValue val : this.params.values) {
                if (val.column == null || columns.containsKey(val.column)) continue;
                valuesToRemove.add(val);
            }
            logger.info((Object)("found " + valuesToRemove.size() + " values to remove"));
            this.params.values.removeAll(valuesToRemove);
            for (WindowRecipePayloadParams.WindowValue val : valuesToRemove) {
                ret.recipeChanges.add(String.format("Removed %d aggregates on %s", val.aggrCount(), val.column));
            }
        }
        if (!options.newAggregates.isEmpty()) {
            HashSet aggregated = Sets.newHashSet();
            for (WindowRecipePayloadParams.WindowValue value : this.params.values) {
                if (value.column == null) continue;
                aggregated.add(value.column);
            }
            ArrayList arrayList = Lists.newArrayList();
            for (SchemaColumn column : inputSchema.getColumns()) {
                if (aggregated.contains(column.getName())) continue;
                arrayList.add(column);
            }
            block15: for (SchemaColumn column : arrayList) {
                if (!options.newAggregates.containsKey(column.getType())) continue;
                List<WindowRecipePayloadParams.WindowValue> templates = options.newAggregates.get(column.getType());
                for (WindowRecipePayloadParams.WindowValue template : templates) {
                    if (!Pattern.matches(template.column, column.getName())) continue;
                    WindowRecipePayloadParams.WindowValue val = (WindowRecipePayloadParams.WindowValue)JSON.deepCopy((Object)template);
                    val.column = column.getName();
                    this.params.values.add(val);
                    ret.recipeChanges.add(String.format("Added %d aggregates on %s", val.aggrCount(), val.column));
                    continue block15;
                }
            }
        }
        if (!ret.recipeChanges.isEmpty()) {
            ret.updatedRecipe = this.recipe;
            ret.updatedPayload = JSON.pretty((Object)this.params);
        }
        return ret;
    }

    public static class WindowRecipeUpdateOptions {
        boolean removeMissingAggregates = true;
        boolean removeMissingInWindow = true;
        public Map<Type, List<WindowRecipePayloadParams.WindowValue>> newAggregates = Maps.newHashMap();
    }
}

