/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PartitioningView
extends AbstractFlowTool.FlowView {
    private PartitioningViewState state;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.partitioning");

    public PartitioningView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized PartitioningViewState computeState() throws Exception {
        this.state = new PartitioningViewState();
        try (Transaction tr = this.transactionService.beginRead();){
            String nodeId;
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forDataset(sd.projectKey, sd.name);
                this.add(nodeId, sd);
            }
            for (ManagedFolder f : this.managedFolderDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forManagedFolder(f.projectKey, f.id);
                this.add(nodeId, f);
            }
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private void add(String nodeId, SerializedDataset sd) {
        try {
            if (sd.isPartitioned()) {
                this.add(nodeId, sd.partitioning);
            } else {
                this.add(nodeId, new PartitioningScheme());
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to get dataset settings", (Throwable)e);
        }
    }

    private void add(String nodeId, ManagedFolder f) {
        try {
            if (f.isPartitioned()) {
                this.add(nodeId, f.partitioning);
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to get dataset settings", (Throwable)e);
        }
    }

    private void add(String nodeId, PartitioningScheme partitioning) {
        this.state.valueByNode.put(nodeId, partitioning);
    }

    public class PartitioningViewState
    implements AbstractFlowTool.FlowState {
        Map<String, PartitioningScheme> valueByNode = new HashMap<String, PartitioningScheme>();
        public Collection<String> focused = new HashSet<String>();
    }
}

