/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TagsView
extends AbstractFlowTool.FlowView {
    private TagsViewState state;
    static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.tags");

    public TagsView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized TagsViewState computeState() throws Exception {
        this.state = new TagsViewState();
        try (Transaction t = this.transactionService.beginRead();){
            FutureProgressState.checkInterrupt();
            this.state.valueByNode = this.taggingService.getTagNodeMap(this.projectKey);
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    public Collection<String> getCurrentFocus() {
        return this.state.focused;
    }

    public class TagsViewState
    implements AbstractFlowTool.FlowState {
        Map<String, List<String>> valueByNode = new HashMap<String, List<String>>();
        public Collection<String> focused = new HashSet<String>();
    }
}

