/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.sort;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.RowAndFileMark;
import com.dataiku.dip.datalayer.sort.RowAndSortMark;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datalayer.sort.SortingChunk;
import com.dataiku.dip.datalayer.sort.SpilledRowsIterator;
import com.dataiku.dip.datalayer.sort.SpilledRowsStorage;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class SortedRowsIterator
implements Iterator<RowAndSortMark> {
    private final List<SpilledRowsIterator> chunks = Lists.newArrayList();
    private final PriorityQueue<RowAndChunk> queue;
    private final RowsComparator comparator;
    private final Comparator<NumberedRow> rankComparator;
    public long rowIndex = 0L;
    public long rowRank = 0L;
    public long rowPositionInRank = 0L;
    public NumberedRow lastRow = null;
    public long resetCount = 0L;
    public long resetToNextCount = 0L;
    public long populateCount = 0L;
    public long nextCount = 0L;
    private final List<SpilledRowsIterator.Mark> marks = Lists.newArrayList();

    public SortedRowsIterator(List<SortingChunk> chunks, SpilledRowsStorage storage, RowFactory rf, ColumnFactory cf, RowsComparator comparator) throws IOException {
        this(chunks, storage, rf, cf, comparator, null);
    }

    public SortedRowsIterator(List<SortingChunk> chunks, SpilledRowsStorage storage, RowFactory rf, ColumnFactory cf, RowsComparator comparator, Comparator<NumberedRow> rankComparator) throws IOException {
        this.rankComparator = rankComparator;
        for (SortingChunk chunk : chunks) {
            this.chunks.add(new SpilledRowsIterator(storage.newReader(rf, cf), chunk.getSpilledRows()));
        }
        this.comparator = comparator;
        this.queue = new PriorityQueue<RowAndChunk>(Math.max(chunks.size(), 1), new RowAndChunkComparator(comparator));
        this.populateQueue();
    }

    private void populateQueue() throws IOException {
        ++this.populateCount;
        this.queue.clear();
        this.marks.clear();
        for (int chunkIndex = 0; chunkIndex < this.chunks.size(); ++chunkIndex) {
            SpilledRowsIterator chunk = this.chunks.get(chunkIndex);
            this.marks.add(chunk.mark());
            if (!chunk.hasNext()) continue;
            this.queue.offer(new RowAndChunk(chunk.next(), chunkIndex));
        }
    }

    private Mark mark() {
        return new Mark(Lists.newArrayList(this.marks), this.rowIndex);
    }

    public void reset(RowAndSortMark rowAndSortMark) throws IOException {
        ++this.resetCount;
        if (this.rowIndex == rowAndSortMark.mark.index) {
            return;
        }
        this.rowIndex = rowAndSortMark.mark.index;
        this.rowRank = rowAndSortMark.mark.rank;
        this.rowPositionInRank = rowAndSortMark.mark.positionInRank;
        this.lastRow = rowAndSortMark.row;
        for (int i = 0; i < this.chunks.size(); ++i) {
            this.chunks.get(i).reset(rowAndSortMark.mark.marks.get(i));
        }
        this.populateQueue();
    }

    public void resetToNext(RowAndSortMark rowAndSortMark) throws IOException {
        ++this.resetToNextCount;
        if (this.rowIndex == rowAndSortMark.mark.index + 1L) {
            return;
        }
        this.reset(rowAndSortMark);
        this.next();
    }

    @Override
    public boolean hasNext() {
        return this.queue.size() > 0;
    }

    @Override
    public RowAndSortMark next() {
        if (!this.hasNext()) {
            return null;
        }
        try {
            ++this.nextCount;
            Mark mark = this.mark();
            RowAndChunk rowAndChunk = this.queue.poll();
            ++this.rowIndex;
            ++this.rowPositionInRank;
            if (this.rankComparator != null) {
                if (this.lastRow == null) {
                    ++this.rowRank;
                    this.rowPositionInRank = 0L;
                } else if (this.rankComparator.compare(this.lastRow, rowAndChunk.rowAndMark.row) != 0) {
                    ++this.rowRank;
                    this.rowPositionInRank = 0L;
                }
            }
            mark.rank = this.rowRank;
            mark.positionInRank = this.rowPositionInRank;
            SpilledRowsIterator chunk = this.chunks.get(rowAndChunk.chunkIndex);
            this.marks.set(rowAndChunk.chunkIndex, chunk.mark());
            if (chunk.hasNext()) {
                this.queue.offer(new RowAndChunk(chunk.next(), rowAndChunk.chunkIndex));
            }
            this.lastRow = rowAndChunk.rowAndMark.row;
            return new RowAndSortMark(rowAndChunk.rowAndMark.row, mark);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not iterate sorted rows", e);
        }
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }

    public String stats() {
        long positionCount = 0L;
        long repositionCount = 0L;
        long fillCount = 0L;
        for (SpilledRowsIterator chunk : this.chunks) {
            positionCount += chunk.fileReader.positionCount;
            repositionCount += chunk.fileReader.repositionCount;
            fillCount += chunk.fileReader.fillCount;
        }
        return "nextCount=" + this.nextCount + " resetCount=" + this.resetCount + ", resetToNextCount=" + this.resetToNextCount + ", populateCount=" + this.populateCount + ", positionCount=" + positionCount + ", repositionCount=" + repositionCount + ", fillCount=" + fillCount + ", comparisons=" + this.comparator.count + ", cache hit=" + this.comparator.cacheHit + ", cache miss=" + this.comparator.cacheMiss;
    }

    private class RowAndChunkComparator
    implements Comparator<RowAndChunk> {
        private final Comparator<NumberedRow> rowComparator;

        RowAndChunkComparator(Comparator<NumberedRow> rowComparator) {
            this.rowComparator = rowComparator;
        }

        @Override
        public int compare(RowAndChunk a, RowAndChunk b) {
            return this.rowComparator.compare(a.rowAndMark.row, b.rowAndMark.row);
        }
    }

    private class RowAndChunk {
        private final RowAndFileMark rowAndMark;
        private final int chunkIndex;

        RowAndChunk(RowAndFileMark rowAndMark, int chunkIndex) {
            this.rowAndMark = rowAndMark;
            this.chunkIndex = chunkIndex;
        }
    }

    public static class Mark {
        final List<SpilledRowsIterator.Mark> marks;
        public final long index;
        public long rank;
        public long positionInRank;

        Mark(List<SpilledRowsIterator.Mark> marks, long index) {
            this.marks = marks;
            this.index = index;
        }
    }
}

