/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.cassandra;

import com.dataiku.dip.connections.CassandraUtil;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.cassandra.AbstractCassandraDatasetHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowSequenceInputSplit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.CassandraV1Query;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PartitionedCassandraDatasetHandler
extends AbstractCassandraDatasetHandler {
    protected List<Partition> explicitPartitionsList;

    public PartitionedCassandraDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
        if (!StringUtils.isBlank((String)this.config.explicitPartitionsList)) {
            this.explicitPartitionsList = PartitionFactory.fromPartitionSpec(dataset.getPartitioningSchema(), this.config.explicitPartitionsList);
        }
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException {
        super.checkConfiguration();
        assert (this.dataset.getPartitioningSchema().isPartitioned());
        assert (this.dataset.getPartitioningSchema().getSingleDimension().getName().equals(this.config.partitioningColumn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Partition> listPartitions() throws Exception {
        if (this.explicitPartitionsList != null) {
            return this.explicitPartitionsList;
        }
        Dimension dimension = this.dataset.getPartitioningSchema().getSingleDimension();
        logger.info((Object)("Connecting to cluster, connection=" + this.config.connection));
        CassandraUtil.ClusterConnection dbConn = CassandraUtil.acquireConnection(this.authCtx, this.config.connection);
        try {
            if (dbConn.getProtocolVersion() == ProtocolVersion.V1) {
                throw ErrorContext.iae((String)"cannot list partitions for Cassandra v1 tables - partition list must be explicitly configured");
            }
            logger.info((Object)("Listing partitions for table: " + this.config.table + " with partitioning config.partitioningColumn " + this.config.partitioningColumn));
            String cql = "SELECT DISTINCT " + CassandraUtil.quote(this.config.partitioningColumn) + (String)(this.config.partitionSpread > 0 ? ", " + CassandraUtil.quote("_dssSpread") : "") + " FROM " + CassandraUtil.quote(this.config.table);
            logger.debug((Object)("sending cql: " + cql));
            ResultSet res = dbConn.getSession().execute(new SimpleStatement(cql).setFetchSize(this.config.fetchSize));
            HashSet<String> values = new HashSet<String>();
            for (com.datastax.driver.core.Row dbRow : res) {
                values.add(CassandraUtil.getCassandraValue(dbRow, 0));
            }
            ArrayList<Partition> result = new ArrayList<Partition>();
            for (String val : values) {
                Partition part = new Partition(this.dataset.getPartitioningSchema());
                part.setDimensionValue(this.config.partitioningColumn, dimension.getValueFromId(val));
                result.add(part);
            }
            ArrayList<Partition> arrayList = result;
            return arrayList;
        }
        finally {
            CassandraUtil.releaseConnection(dbConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Partition getSamplePartition() throws Exception {
        if (this.explicitPartitionsList != null) {
            return this.explicitPartitionsList.size() == 0 ? null : this.explicitPartitionsList.get(0);
        }
        if (StringUtils.isBlank((String)this.config.partitioningColumn)) {
            throw new IllegalArgumentException("Partitionning column undefined in cassandra partitioned dataset.");
        }
        Dimension dimension = this.dataset.getPartitioningSchema().getSingleDimension();
        logger.info((Object)("Connecting to cluster, config.connection=" + this.config.connection));
        CassandraUtil.ClusterConnection dbConn = CassandraUtil.acquireConnection(this.authCtx, this.config.connection);
        try {
            logger.info((Object)("Looking up sample partition value for table: " + this.config.table + " with partitioning partitioningColumn " + this.config.partitioningColumn));
            String cql = "SELECT " + CassandraUtil.quote(this.config.partitioningColumn) + " FROM " + CassandraUtil.quote(this.config.table) + " LIMIT 1";
            logger.debug((Object)("sending cql: " + cql));
            ResultSet res = dbConn.getSession().execute(cql);
            com.datastax.driver.core.Row dbRow = res.one();
            if (dbRow == null) {
                Partition partition = null;
                return partition;
            }
            String val = CassandraUtil.getCassandraValue(dbRow, 0);
            if (val == null) {
                Partition partition = null;
                return partition;
            }
            Partition part = new Partition(this.dataset.getPartitioningSchema());
            DimensionValue value = dimension.getValueFromId(val);
            part.setDimensionValue(this.config.partitioningColumn, value);
            Partition partition = part;
            return partition;
        }
        finally {
            CassandraUtil.releaseConnection(dbConn);
        }
    }

    @Override
    public RowsInputSplit getPartitionSplit(Partition partition) throws Exception {
        return new PartitionSplit(partition);
    }

    protected long pushV1(CassandraUtil.ClusterConnection dbConn, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, String filterValue) throws Exception {
        assert (filterValue != null);
        long maxRecords = limit != null && limit.maxRecords > 0L ? limit.maxRecords : 0L;
        logger.info((Object)("Enumerating Cassandra v1 config.table: " + this.config.table + (String)(maxRecords > 0L ? " with limit " + maxRecords : "")));
        HashSet<String> fields = null;
        if (this.dataset.getSchema() != null && this.dataset.getSchema().getColumns().size() > 0) {
            fields = new HashSet<String>();
            for (SchemaColumn sc : this.dataset.getSchema().getColumns()) {
                fields.add(sc.getName());
            }
        }
        long rowsPushed = 0L;
        if (!this.dataset.isManaged()) {
            CassandraV1Query query = new CassandraV1Query(dbConn, this.config.table, this.config.fetchSize, fields, this.config.partitioningColumn, filterValue, -1, maxRecords);
            while (query.hasNext()) {
                com.datastax.driver.core.Row dbRow = query.next();
                ColumnDefinitions dbCols = dbRow.getColumnDefinitions();
                Row r = rf.row();
                for (int i = 0; i < dbCols.size(); ++i) {
                    String val;
                    if (dbRow.isNull(i) || dbCols.getName(i).startsWith("_dss") || (val = CassandraUtil.getCassandraValue(dbRow, i)) == null) continue;
                    r.put(cf.column(dbCols.getName(i)), val);
                }
                out.emitRow(r);
                if (++rowsPushed % 100000L != 0L) continue;
                logger.debug((Object)("Got " + rowsPushed + " rows"));
            }
        } else {
            for (int spreadValue = 0; spreadValue < this.config.partitionSpread; ++spreadValue) {
                logger.info((Object)("Pushing partition records for spreadValue=" + spreadValue));
                assert (maxRecords == 0L || rowsPushed < maxRecords);
                CassandraV1Query query = new CassandraV1Query(dbConn, this.config.table, this.config.fetchSize, fields, this.config.partitioningColumn, filterValue, spreadValue, maxRecords == 0L ? 0L : maxRecords - rowsPushed);
                while (query.hasNext()) {
                    com.datastax.driver.core.Row dbRow = query.next();
                    ColumnDefinitions dbCols = dbRow.getColumnDefinitions();
                    Row r = rf.row();
                    for (int i = 0; i < dbCols.size(); ++i) {
                        String val;
                        if (dbRow.isNull(i) || dbCols.getName(i).startsWith("_dss") || (val = CassandraUtil.getCassandraValue(dbRow, i)) == null) continue;
                        r.put(cf.column(dbCols.getName(i)), val);
                    }
                    out.emitRow(r);
                    if (++rowsPushed % 100000L != 0L) continue;
                    logger.debug((Object)("Got " + rowsPushed + " rows"));
                }
                if (maxRecords <= 0L || rowsPushed < maxRecords) {
                    continue;
                }
                break;
            }
        }
        logger.debug((Object)("Done pushing, got " + rowsPushed + " rows"));
        return rowsPushed;
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        ArrayList<RowsInputSplit> splits = new ArrayList<RowsInputSplit>();
        for (Partition part : this.listPartitions()) {
            RowsInputSplit split = this.getPartitionSplit(part);
            splits.add(split);
        }
        return new RowSequenceInputSplit(splits);
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        assert (filter != null);
        FilterResultWithSplits result = new FilterResultWithSplits();
        if (!filter.hasPartitionsFiltering()) {
            for (Partition partition : this.listPartitions()) {
                result.withMatchingPartition(partition).withSplit((InputSplit)this.getPartitionSplit(partition));
            }
        } else {
            for (Partition partition : filter.getPartitionsClause()) {
                result.withMatchingPartition(partition).withSplit((InputSplit)this.getPartitionSplit(partition));
            }
        }
        return result;
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        Partition part = this.getSamplePartition();
        return part == null ? null : this.getPartitionSplit(part);
    }

    @Override
    public long getPartitionRecords(Partition partition) throws Exception {
        return this.countRecords(CassandraUtil.partitionFilterTerm(this.config.partitioningColumn, this.config.partitionSpread), ((DimensionValue)partition.getDimensionValues().get(this.config.partitioningColumn)).id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        logger.info((Object)("Connecting to cluster, config.connection=" + this.config.connection));
        CassandraUtil.ClusterConnection dbConn = CassandraUtil.acquireConnection(this.authCtx, this.config.connection);
        try {
            logger.info((Object)("Deleting partitions for config.table " + this.config.table));
            String cql = "DELETE FROM " + CassandraUtil.quote(this.config.table) + " WHERE " + CassandraUtil.partitionFilterTerm(this.config.partitioningColumn, this.config.partitionSpread);
            logger.debug((Object)("Preparing cql: " + cql));
            PreparedStatement ps2 = dbConn.prepare(cql);
            for (Partition p : partitions) {
                logger.info((Object)("Deleting partition " + p.id()));
                BoundStatement st2 = ps2.bind();
                CassandraUtil.setCassandraValue(st2, 0, p.id());
                dbConn.getSession().execute((Statement)st2);
            }
        }
        finally {
            CassandraUtil.releaseConnection(dbConn);
        }
    }

    @Override
    public long getRecords() throws Exception {
        return this.countRecords(null, null);
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        for (Partition _p : this.listPartitions()) {
            if (!_p.id().equals(p.id())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean outputHandlesClear() {
        return true;
    }

    class PartitionSplit
    extends RowsInputSplit {
        Partition partition;

        PartitionSplit(Partition partition) {
            this.partition = partition;
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            return PartitionedCassandraDatasetHandler.this.executePush(out, cf, rf, limit, listener, warningsContext, CassandraUtil.partitionFilterTerm(PartitionedCassandraDatasetHandler.this.config.partitioningColumn, PartitionedCassandraDatasetHandler.this.config.partitionSpread), ((DimensionValue)this.partition.getDimensionValues().get(PartitionedCassandraDatasetHandler.this.config.partitioningColumn)).id());
        }

        public String getDesc() {
            return "Cassandra partition " + this.partition.id();
        }
    }
}

