/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.custompython;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.custompython.CustomDatasetDesc;
import com.dataiku.dip.datasets.custompython.CustomDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomDatasetTestHandler
implements DatasetTestHandler {
    @Autowired
    private LogsService logsService;
    @Autowired
    private IPluginsRegistryService pluginsService;
    private final AuthCtx authCtx;
    private final Dataset dataset;
    private CustomDatasetHandler<?> handler;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.customjava");

    public CustomDatasetTestHandler(AuthCtx authCtx, Dataset dataset, CustomDatasetHandler<?> handler) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.handler = handler;
    }

    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            finally {
                this.handler = null;
            }
        }
    }

    public CPDTestResult test(boolean showPreview) {
        logger.info((Object)("Testing CustomJava dataset: " + this.dataset.getType()));
        CPDTestResult result = new CPDTestResult();
        try (CustomDatasetHandler dh = (CustomDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.dataset);){
            try {
                logger.info((Object)"Fetching schema and partitioning");
                result.schema = dh.getSchema();
                result.suggestedName = dh.suggestName();
                result.codeDefinedPartitioning = dh.getCodeDefinedPartitioning();
                logger.info((Object)"Fetching first rows");
                dh.setUseReadInfoSchemaRatherThanDatasetSchema();
                if (dh.getDesc().partitioningMode == CustomDatasetDesc.PartitioningMode.CODE_DEFINED_LISTABLE || dh.getDesc().partitioningMode == CustomDatasetDesc.PartitioningMode.CODE_DEFINED_UNLISTABLE) {
                    if (result.codeDefinedPartitioning != null) {
                        logger.info((Object)("Forcing partitioning to " + JSON.json((Object)result.codeDefinedPartitioning)));
                        dh.setForcedPartitioningScheme(result.codeDefinedPartitioning);
                    } else {
                        logger.info((Object)"Code-defined connector has null partitioning, forcing unpartitioned");
                        dh.setForcedPartitioningScheme(new PartitioningScheme());
                    }
                }
                if (result.codeDefinedPartitioning == null || result.codeDefinedPartitioning.getDimensionNames() == null || result.codeDefinedPartitioning.getDimensionNames().size() > 0) {
                    // empty if block
                }
                if (showPreview) {
                    RowsInputSplit split = dh.getSampleSplit();
                    MemTable mt = new MemTable();
                    split.push((ProcessorOutput)new MemTableAppendingOutput(mt), mt, mt, new ExtractionLimit(100L), null, null);
                    new TypeInferrer2().processFullAuto(null, mt);
                    if (result.schema == null) {
                        logger.info((Object)"Infering schema from preview");
                        result.schema = new Schema();
                        for (MemColumn mc : mt.columnsList) {
                            result.schema.getColumns().add(new SchemaColumn(mc.getName(), Type.STRING));
                        }
                    } else {
                        logger.info((Object)"The schema is fixed and defined by the connector.");
                    }
                    result.preview = new SerializedMemTableSimple();
                    result.preview.fromMemTable(mt, 0, 10);
                }
            }
            catch (SocketBlockLinkKernelException e) {
                logger.warn((Object)"Test failed", (Throwable)e);
                result.error = new SerializedError((Throwable)e, true);
                result.kernelLog = e.getLogTailWithStackTrace();
            }
            catch (Exception e) {
                logger.warn((Object)"Test failed", (Throwable)e);
                result.error = new SerializedError((Throwable)e, true);
            }
            if (this.pluginsService.isPluginInstalledAsDev(dh.getLoaded().ownerPluginId)) {
                try {
                    result.backendLog = this.logsService.getLogContent("backend.log");
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to get backend log tail", (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to close custom dataset handler", (Throwable)e);
        }
        return result;
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        return new InfoMessage.InfoMessages();
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        CPDTestResult result = this.test(true);
        DatasetTestHandler.SchemaConsistencyResult scr = new DatasetTestHandler.SchemaConsistencyResult();
        scr.empty = result.error != null;
        scr.result = SchemaDetection.handleDetectionResult(SchemaDetection.SchemaHandlingType.FIXED_TYPE_AND_SCHEMA, this.dataset.getSchema(), this.dataset.getSchema().userModified ? SchemaDetection.Mode.DETECTION_PREFER_USER_AND_WARN : SchemaDetection.Mode.DETECTION_PREFER_DATA, result.schema);
        return scr;
    }

    public static class CPDTestResult {
        public SerializedError error;
        public Schema schema;
        public PartitioningScheme codeDefinedPartitioning;
        public SerializedMemTableSimple preview;
        public String suggestedName;
        public SmartLogTail kernelLog;
        public LogsService.LogDesc backendLog;
    }
}

