/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.elasticsearch;

import com.dataiku.dip.datasets.elasticsearch.ElasticSearchUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.Header;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntityEnclosingRequest;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.entity.StringEntity;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ElasticSearchHttpClient
implements AutoCloseable {
    private final DefaultHttpClient client;
    private final List<Header> originalHeaders;
    private Header[] headers;
    private final CredentialsRefresher refresher;
    private final RequestSigner signer;
    private static final Logger logger = Logger.getLogger((String)"dku.elasticsearch");

    public ElasticSearchHttpClient(DefaultHttpClient client, List<Header> headers, CredentialsRefresher refresher, RequestSigner signer) {
        this.client = client;
        this.originalHeaders = headers;
        this.refresher = refresher;
        this.signer = signer;
        this.regenerateHeaders();
    }

    private void regenerateHeaders() {
        if (this.refresher == null) {
            this.headers = this.originalHeaders.toArray(new Header[0]);
            return;
        }
        ArrayList<Header> headerCopy = new ArrayList<Header>(this.originalHeaders);
        headerCopy.add(this.refresher.refresh());
        this.headers = headerCopy.toArray(new Header[0]);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public HttpResponse execute(HttpUriRequest req) throws IOException {
        req.setHeaders(this.headers);
        if (this.signer != null) {
            this.signer.sign(req);
        }
        return this.client.execute(req);
    }

    public HttpResponse execute(HttpUriRequest req, boolean consume, String errorPrefix, int ... okStatusCodes) throws IOException {
        return this.execute(req, consume, errorPrefix, this.refresher, okStatusCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse execute(HttpUriRequest req, boolean consume, String errorPrefix, CredentialsRefresher refresher, int ... okStatusCodes) throws IOException {
        HttpResponse resp;
        int statusCode;
        if (logger.isDebugEnabled()) {
            HttpEntity entity;
            StringBuilder sb = new StringBuilder(req.getMethod() + " " + String.valueOf(req.getURI()));
            if (req instanceof HttpEntityEnclosingRequest && !req.getURI().getPath().endsWith("_bulk") && (entity = ((HttpEntityEnclosingRequest)req).getEntity()) instanceof StringEntity) {
                sb.append(" < ").append(IOUtils.toString((InputStream)entity.getContent()));
            }
            logger.debug((Object)sb.toString());
        }
        boolean ok = (statusCode = (resp = this.execute(req)).getStatusLine().getStatusCode()) == 200;
        try {
            if (statusCode == 401 && refresher != null) {
                logger.info((Object)"Received a 401 once. Refreshing credentials and retry the request one more time");
                this.regenerateHeaders();
                EntityUtils.consumeQuietly((HttpEntity)resp.getEntity());
                HttpResponse httpResponse = this.execute(req, consume, errorPrefix, null, okStatusCodes);
                return httpResponse;
            }
            if (!ok) {
                for (int sc : okStatusCodes) {
                    if (sc != statusCode) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    throw new IOException(errorPrefix + " (HTTP code " + statusCode + ")\n" + ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
                }
            }
            HttpResponse httpResponse = resp;
            return httpResponse;
        }
        finally {
            if (consume || !ok) {
                EntityUtils.consume((HttpEntity)resp.getEntity());
            }
        }
    }

    public static interface CredentialsRefresher {
        public Header refresh();
    }

    public static interface RequestSigner {
        public void sign(HttpUriRequest var1) throws IOException;
    }
}

