/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.AzureBlobModel;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobStorageException;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AzureBlobStorageFSTestProvider
implements FSTestProvider {
    private final AzureConnection connection;
    private final BuiltinFSDatasets.AzureBlobDatasetConfig config;
    private final AuthCtx authCtx;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fstestproviders.azure");

    public AzureBlobStorageFSTestProvider(AuthCtx authCtx, DSSConnection connection, AbstractFSDatasetHandler.AbstractFSConfig config) {
        this.authCtx = authCtx;
        this.config = (BuiltinFSDatasets.AzureBlobDatasetConfig)config;
        this.connection = (AzureConnection)connection;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Map<String, String> test(boolean listBuckets) throws DKUSecurityException, IOException {
        HashMap connectionMetadata = Maps.newHashMap();
        ProxySettings proxySettings = ApplicationConfigurator.getProxySettings();
        AzureBlobModel.BlobServiceAccountHolder client = this.connection.getAzureBlobClient(this.authCtx, proxySettings);
        if (StringUtils.isBlank((String)this.connection.params.chcontainer) && listBuckets) {
            try {
                PagedIterable<BlobContainerItem> containerList = client.listContainers();
                ArrayList containerNames = Lists.newArrayList();
                for (BlobContainerItem container : containerList) {
                    containerNames.add(container.getName());
                    if (container.getName().equals(this.connection.params.getDefaultManagedContainer())) {
                        connectionMetadata.put("defaultBucket", this.connection.params.getDefaultManagedContainer());
                    }
                    logger.debug((Object)("found container " + container.getName()));
                }
                String containers = Joiner.on((String)",").join((Iterable)containerNames);
                logger.debug((Object)("Container list : " + containers));
                connectionMetadata.put("buckets", containers);
                if (!containers.isEmpty()) {
                    connectionMetadata.put("couldListBuckets", "true");
                }
            }
            catch (BlobStorageException e) {
                connectionMetadata.put("couldListBuckets", "false");
                connectionMetadata.put("bucketsListError", "Could not list containers : " + String.valueOf(e.getErrorCode()));
                logger.error((Object)"couldn't list container", (Throwable)e);
            }
            catch (Exception e) {
                connectionMetadata.put("couldListBuckets", "false");
                connectionMetadata.put("bucketsListError", e.getMessage());
                logger.error((Object)"couldn't list container", (Throwable)e);
            }
        }
        connectionMetadata.put("constrainedBucket", this.connection.params.chcontainer);
        try {
            String container;
            String chcontainer = this.connection.params.chcontainer;
            String string = container = StringUtils.isNotBlank((String)chcontainer) ? chcontainer : this.config.container;
            if (StringUtils.isNotBlank((String)container)) {
                connectionMetadata.put("bucketExists", String.valueOf(client.getContainerReference(container).exists()));
                connectionMetadata.put("connectionValid", "true");
            }
        }
        catch (Exception e) {
            connectionMetadata.put("bucketExists", "false");
            connectionMetadata.put("connectionValid", "false");
            logger.info((Object)"Could not find container", (Throwable)e);
        }
        return connectionMetadata;
    }
}

