/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamDatasetUtils;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.datasets.fs.FilesystemDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FilesystemDatasetTestHandler
extends FSLikeDatasetTestHandler {
    private static Logger logger = Logger.getLogger((String)"dku.input.fs");

    public FilesystemDatasetTestHandler(AuthCtx authCtx, FilesystemDatasetHandler handlerForData, DatasetHandler handlerForName, Dataset dataset) {
        super(authCtx, handlerForData, handlerForName, dataset);
    }

    public StreamsInputSplit getMultiFileSampleSplit() throws Exception {
        return this.handlerForData.getGlobalSplit();
    }

    private void basicConfigCheck(FilesystemDatasetConfig config) throws CodedException, IOException, DKUSecurityException {
        if (StringUtils.isBlank((String)config.path)) {
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Missing 'path' parameter");
        }
        File f = ((FilesystemDatasetHandler)this.handlerForData).getRoot();
        if (f.equals(new File("/"))) {
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "The root directory ('/') is not a valid location for a dataset");
        }
    }

    @Override
    public InputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult ret) throws Exception {
        FilesystemDatasetConfig config = this.dataset.getParamsAs(FilesystemDatasetConfig.class);
        try {
            this.basicConfigCheck(config);
        }
        catch (Exception e) {
            logger.warn((Object)"FS dataset test failed", (Throwable)e);
            ret.connectionError = new SerializedError((Throwable)e, false);
            return null;
        }
        File f = ((FilesystemDatasetHandler)this.handlerForData).getRoot();
        if (this.dataset.isManaged() && !f.isDirectory()) {
            ret.connectionOK = true;
            ret.empty = true;
            return null;
        }
        try {
            InputSplit sampleSplit = this.handlerForData.getSampleSplit();
            if (sampleSplit instanceof StreamsInputSplit) {
                ret.empty = StreamDatasetUtils.isStreamEmpty((StreamsInputSplit)sampleSplit);
            }
            ret.connectionOK = true;
            return sampleSplit;
        }
        catch (Exception e) {
            logger.info((Object)"FS dataset test failed", (Throwable)e);
            ret.connectionError = new SerializedError((Throwable)e, false);
            return null;
        }
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        return FSDatasetUtils.checkDatasetName(newDatasetName);
    }
}

