/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamDatasetUtils;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.datasets.fs.GCSDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class GCSDatasetTestHandler
extends FSLikeDatasetTestHandler {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.input.gcs");

    public GCSDatasetTestHandler(AuthCtx authCtx, AbstractFSDatasetHandler handlerForData, DatasetHandler handlerForName, Dataset dataset) {
        super(authCtx, handlerForData, handlerForName, dataset);
    }

    @Override
    public InputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult ret) throws CodedException, DKUSecurityException {
        GCSConnection connection;
        BuiltinFSDatasets.GCSDatasetConfig config = this.dataset.getParamsAs(BuiltinFSDatasets.GCSDatasetConfig.class);
        try {
            connection = ConnectionsDAO.get().getMandatoryConnectionAs(this.handlerForData.authCtx, config.connection, GCSConnection.class);
            try (FSTestProvider testProvider = FSProviderFactory.getTestProvider(this.handlerForData.authCtx, "GCS", config, connection);){
                ret.connectionMetadata.putAll(testProvider.test(false));
            }
        }
        catch (IOException e1) {
            ret.connectionError = new SerializedError((Throwable)e1, false);
            logger.warn((Object)"Failed initial test of GCS dataset", (Throwable)e1);
            return null;
        }
        if (StringUtils.isBlank((String)connection.params.chbucket) && StringUtils.isBlank((String)config.bucket)) {
            logger.info((Object)"No bucket specified yet, only checking connection");
            ret.connectionError = new SerializedError((Throwable)new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "GCS bucket not specified"), false);
            return null;
        }
        try {
            InputSplit sampleSplit = this.handlerForData.getSampleSplit();
            if (sampleSplit instanceof StreamsInputSplit) {
                ret.empty = StreamDatasetUtils.isStreamEmpty((StreamsInputSplit)sampleSplit);
            }
            ret.connectionOK = true;
            return sampleSplit;
        }
        catch (Exception e) {
            logger.info((Object)"Test GCS connection failed ", (Throwable)e);
            ret.connectionError = new SerializedError((Throwable)e, false);
            return null;
        }
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) throws Exception {
        GCSDatasetHandler handler = (GCSDatasetHandler)this.handlerForData;
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try {
            if (handler.getProvider().stat(newDatasetName) != null) {
                ret.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_MANAGED_UNSAFE_NAME, "Objects already already exists under key '%s', they may get overwritten", new Object[]{newDatasetName});
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to check if the new dataset name is safe", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_GENERIC_ERROR, "Failed to check if the new dataset name is safe, there could be a problem with the database: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }
}

