/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.SSHFSProvider;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.PathToURIConverter;
import com.dataiku.dip.input.remote.SSHRemote;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class SCPFSProvider
extends SSHFSProvider
implements PathToURIConverter {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;

    public SCPFSProvider(AuthCtx authCtx, DSSConnection connection, String root, int timeout) {
        super(authCtx, connection, root, timeout);
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, DKUSecurityException {
        HashMap ret = Maps.newHashMap();
        ret.put("root", this.root);
        ret.put("host", this.connection.params.host);
        ret.put("port", Integer.toString(this.connection.params.port));
        if (withSensitiveInfo && this.connection.detailsReadableBy(this.authCtx)) {
            SSHConnection.SerializableSSHCredentials creds = this.connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), SSHConnection.SerializableSSHCredentials.class);
            ret.put("user", creds.user);
            ret.put("password", creds.password);
            ret.put("passphrase", creds.passphrase);
            ret.put("usePublicKey", Boolean.toString(creds.usePublicKey));
        }
        return ret;
    }

    @Override
    protected SSHRemote createRemote() throws IOException, DKUSecurityException {
        SSHConnection.SerializableSSHCredentials creds = this.connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), SSHConnection.SerializableSSHCredentials.class);
        try {
            return new SSHRemote(this.connection.params.host, creds.user, creds.usePublicKey, creds.passphrase, creds.password, this.connection.params.port, this.timeout);
        }
        catch (IOException e) {
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_SSH_CONNECTION_FAILED, "Could not connect", (Throwable)e);
        }
    }

    public String convertPathToURI(String prefix) {
        return "file:" + this.getPathInsideRoot(prefix);
    }
}

