/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sample;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.datasets.sample.LoadedSampleDataset;
import com.dataiku.dip.datasets.sample.SampleDatasetDesc;
import com.dataiku.dip.datasets.sample.SampleDatasetDescValidator;
import com.dataiku.dip.datasets.sample.SampleDatasetMeta;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.plugins.exceptions.DuplicateComponentException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.utils.DKUFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SampleDatasetsService
extends AbstractElementService<SampleDatasetDesc, LoadedSampleDataset> {
    @Autowired
    private TransactionService transactionService;

    @Override
    public String getFolderName() {
        return "sample-datasets";
    }

    @Override
    public String getPrefix() {
        return "dataset";
    }

    @Override
    protected String getCodeExtension(LoadedSampleDataset desc) {
        return null;
    }

    @Override
    protected void removeElement(LoadedSampleDataset desc) {
        DatasetHandlerFactory.deregisterDatasetType(desc.getType());
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "Sample_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedSampleDataset load(String elementType, String pluginId, String elementId, File file) throws IOException, DuplicateComponentException {
        LoadedSampleDataset loaded = new LoadedSampleDataset(elementId, pluginId, elementType, SampleDatasetDesc.build(file, this.pluginsService.getPluginResourceFolder(pluginId), pluginId));
        SampleDatasetDesc.AvailableDataset dataset = new SampleDatasetDesc.AvailableDataset();
        dataset.label = loaded.desc.meta.label;
        dataset.path = this.getSamplePath(file.getParent(), elementId);
        dataset.description = loaded.desc.meta.description;
        dataset.columns = loaded.desc.columns;
        loaded.desc.dataset = dataset;
        SampleDatasetMeta meta = new SampleDatasetMeta(loaded);
        DatasetHandlerFactory.checkDuplicateDatasetMeta(pluginId, elementId, elementType, SampleDatasetMeta.class);
        DatasetHandlerFactory.registerDatasetType(meta);
        return loaded;
    }

    private String getDataPath(String elementId) {
        return Paths.get(this.getFolderName(), elementId, "data").toString();
    }

    private String getSamplePath(String pluginComponentDirectory, String elementId) throws FileNotFoundException {
        List<String> sampleValidExtensions = List.of(".csv", ".csv.gz");
        String path = DKUFileUtils.getWithin((File)new File(pluginComponentDirectory), (String[])new String[]{"data"}).getPath();
        File dataFolder = new File(path);
        if (!dataFolder.exists() || !dataFolder.isDirectory()) {
            throw new FileNotFoundException(String.format("The data folder does not exist or is not a directory: %s", this.getDataPath(elementId)));
        }
        File[] files = dataFolder.listFiles();
        if (files == null || files.length == 0) {
            throw new FileNotFoundException(String.format("The data folder is empty: %s", this.getDataPath(elementId)));
        }
        List<String> invalidFiles = Arrays.stream(files).map(File::getName).map(name -> name.toLowerCase(Locale.ROOT)).filter(name -> sampleValidExtensions.stream().noneMatch(name::endsWith)).toList();
        if (!invalidFiles.isEmpty()) {
            throw new FileNotFoundException(String.format("Only the following extensions are allowed: %s. The data folder (%s) contains files with invalid extensions: %s.", sampleValidExtensions, this.getDataPath(elementId), invalidFiles));
        }
        return path;
    }

    @Override
    public Class<SampleDatasetDesc> getDescClass() {
        return SampleDatasetDesc.class;
    }

    @Override
    public Class<LoadedSampleDataset> getLoadedDescClass() {
        return LoadedSampleDataset.class;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, SampleDatasetDesc desc) {
        SampleDatasetDescValidator validator = new SampleDatasetDescValidator(componentId, desc, new File(this.getResourceFolder(this.makeType(pluginId, componentId))), this.transactionService);
        return validator.validate();
    }
}

