/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction.common.chunks;

import com.dataiku.dip.docextraction.StructuredContent;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.utils.PathUtils;
import java.util.List;

public class StructuredExtractionChunk {
    public String fullContent;
    public List<String> outline;
    public StructuredContent parentStructure;
    public StructuredContent.PageRange pageRange;
    public String caption;
    public InputRefs.SingleImageRef imageRef;

    public static StructuredExtractionChunk build(String fullContent, List<String> outline, StructuredContent parentStructure, StructuredContent.PageRange pageRange) {
        StructuredExtractionChunk textChunk = new StructuredExtractionChunk();
        textChunk.fullContent = fullContent;
        textChunk.outline = outline;
        textChunk.parentStructure = parentStructure;
        textChunk.pageRange = pageRange;
        return textChunk;
    }

    public static StructuredExtractionChunk buildForImage(String fullContent, List<String> outline, StructuredContent parentStructure, StructuredContent.PageRange pageRange, String caption, InputRefs.SingleImageRef imageRef) {
        StructuredExtractionChunk textChunk = StructuredExtractionChunk.build(fullContent, outline, parentStructure, pageRange);
        textChunk.caption = caption;
        textChunk.imageRef = imageRef;
        return textChunk;
    }

    public String getImagesCommonPrefixPath() {
        if (this.imageRef != null) {
            return StructuredExtractionChunk.getImagesPrefixPathFromImageRef(this.imageRef);
        }
        return StructuredExtractionChunk.getImagesPrefixPathFromStructuredContent(this.parentStructure);
    }

    public static String getImagesPrefixPathFromStructuredContent(StructuredContent structuredContent) {
        if (structuredContent == null || structuredContent.content == null) {
            return null;
        }
        for (StructuredContent child : structuredContent.content) {
            StructuredContent.Section section;
            String path;
            if (child instanceof StructuredContent.Image) {
                StructuredContent.Image img = (StructuredContent.Image)child;
                if (img.imageRef != null && (path = StructuredExtractionChunk.getImagesPrefixPathFromImageRef(img.imageRef)) != null) {
                    return path;
                }
            }
            if (!(child instanceof StructuredContent.Section) || (path = StructuredExtractionChunk.getImagesPrefixPathFromStructuredContent(section = (StructuredContent.Section)child)) == null) continue;
            return path;
        }
        return null;
    }

    public static String getImagesPrefixPathFromImageRef(InputRefs.SingleImageRef imageRef) {
        if (imageRef instanceof InputRefs.SingleManagedFolderImageRef) {
            InputRefs.SingleManagedFolderImageRef storedImg = (InputRefs.SingleManagedFolderImageRef)imageRef;
            return PathUtils.getParent((String)storedImg.path);
        }
        return null;
    }
}

