/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeMeta;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class PivotRecipePlaceholder
implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
    @Override
    public Class<SerializedRecipe> getInputType() {
        return SerializedRecipe.class;
    }

    private static PivotRecipePayloadParams getPayload(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
        return context.getCachedPayloadAs(recipe, PivotRecipePayloadParams.class, PivotRecipeMeta.META);
    }

    private static PivotElement getPivot(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
        List<PivotElement> pivots = PivotRecipePlaceholder.getPayload((FlowDocumentContext)context, (SerializedRecipe)recipe).pivots;
        if (pivots.size() != 1) {
            throw new PlaceholderExpectedException("Pivot recipe doesn't contain one pivot.");
        }
        return pivots.get(0);
    }

    public static class Populate
    extends PivotRecipePlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            PivotElement pivot = PivotRecipePlaceholder.getPivot(context, recipe);
            return new PlaceholderOutput.Text(Stream.concat(pivot.globalCount ? Stream.of("Count of records") : Stream.empty(), pivot.valueColumns.stream().map(x -> x.column)).collect(Collectors.joining(", ")));
        }
    }

    public static class Pivots
    extends PivotRecipePlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text(String.join((CharSequence)", ", PivotRecipePlaceholder.getPivot((FlowDocumentContext)context, (SerializedRecipe)recipe).keyColumns));
        }
    }

    public static class RowIdentifiers
    extends PivotRecipePlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            PivotRecipePayloadParams params = PivotRecipePlaceholder.getPayload(context, recipe);
            if (params.identifierColumnsSelection == PivotRecipePayloadParams.IdentifierColumnsSelection.EXPLICIT) {
                return new PlaceholderOutput.Text(String.join((CharSequence)", ", params.explicitIdentifiers));
            }
            return new PlaceholderOutput.Text("All other columns");
        }
    }
}

