/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.computations.common;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.FailedResult;
import com.dataiku.dip.eda.compute.computations.NotComputedResult;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class MultiComputation
extends Computation
implements Iterable<Computation> {
    public static final String TYPE = "multi";
    public List<Computation> computations;

    public MultiComputation(Computation ... computations) {
        this.computations = Lists.newArrayList((Object[])computations);
    }

    public int size() {
        return this.computations.size();
    }

    public Computation get(int index) {
        return this.computations.get(index);
    }

    public MultiComputation(List<Computation> computations) {
        this.computations = computations;
    }

    private MultiComputation() {
    }

    @Override
    public Iterator<Computation> iterator() {
        return this.computations.iterator();
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    public static class MultiComputationResult
    extends AvailableResult
    implements Iterable<ComputationResult> {
        private List<ComputationResult> results;

        public MultiComputationResult(ComputationResult ... results) {
            this.results = Lists.newArrayList((Object[])results);
        }

        public MultiComputationResult(List<ComputationResult> results) {
            this.results = results;
        }

        private MultiComputationResult() {
        }

        @Override
        public List<String> collectWarnings() {
            ArrayList<String> output = new ArrayList<String>();
            for (ComputationResult result : this.results) {
                output.addAll(result.collectWarnings());
            }
            if (this.warnings != null) {
                output.addAll(this.warnings);
            }
            return output;
        }

        @Override
        public Collection<String> collectErrors() {
            return this.results.stream().map(ComputationResult::collectErrors).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        @Override
        public NotComputedResult getFirstNotComputedResult() {
            for (ComputationResult result : this) {
                NotComputedResult r = result.getFirstNotComputedResult();
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public FailedResult getFirstFailedResult() {
            for (ComputationResult result : this.results) {
                FailedResult r = result.getFirstFailedResult();
                if (r == null) continue;
                return r;
            }
            return null;
        }

        public MultiComputationResult subList(int fromIndex, int toIndex) {
            return new MultiComputationResult(this.results.subList(fromIndex, toIndex));
        }

        public int size() {
            return this.results.size();
        }

        public ComputationResult get(int index) {
            return this.results.get(index);
        }

        @Override
        public Iterator<ComputationResult> iterator() {
            return this.results.iterator();
        }

        @Override
        public ComputationResult.ComputationCounts getComputationCountsImpl() {
            ComputationResult.ComputationCounts ret = new ComputationResult.ComputationCounts(0, 0, 0);
            for (ComputationResult cur : this) {
                ComputationResult.ComputationCounts curCount = cur.getComputationCounts();
                ret = ret.add(curCount);
            }
            return ret;
        }

        @Override
        public int getEstimatedMemoryUsageBytes() {
            int ret = 0;
            for (ComputationResult cur : this.results) {
                ret += cur.getEstimatedMemoryUsageBytes();
            }
            return ret;
        }

        @Override
        public List<ComputationResultDataStreamer.DataStreamId> getDataStreamIds() {
            ArrayList<ComputationResultDataStreamer.DataStreamId> streamIds = new ArrayList<ComputationResultDataStreamer.DataStreamId>();
            for (ComputationResult result : this.results) {
                streamIds.addAll(result.getDataStreamIds());
            }
            return streamIds;
        }
    }
}

