/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.engine.python;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.eda.EdaErrorCodes;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.engine.python.EDAKernelComputationResultSession;
import com.dataiku.dip.eda.compute.sampling.Sample;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.StreamOutputWriter;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NullChecker;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;

public class EDAKernelProtocol
implements ComputationRunner {
    public static final String PYTHON_MODULE = "dataiku.eda.server";
    private final SimplePythonKernel simplePythonKernel;
    static final int BUFFER_SIZE = 10240;
    static final int CHUNK_SIZE = 10;
    Lock lock = new ReentrantLock();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.eda.compute.python");

    public EDAKernelProtocol(SimplePythonKernel simplePythonKernel) {
        this.simplePythonKernel = simplePythonKernel;
    }

    public void loadSample(Sample sample) throws IOException, InterruptedException, CodedException {
        this.lock.lockInterruptibly();
        try {
            this.loadSampleUnguarded(sample);
        }
        catch (Exception e) {
            this.simplePythonKernel.close();
            throw new CodedException((InfoMessage.MessageCode)EdaErrorCodes.ERR_EDA_COMPUTE_KERNEL_FAILURE, "Could not stream sample to EDA Python kernel", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public SimplePythonKernel getKernel() {
        return this.simplePythonKernel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSampleUnguarded(Sample sample) throws IOException, InterruptedException, ExecutionException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info((Object)"Started streaming sample to Python engine...");
        this.simplePythonKernel.getLink().sendRequest((Object)new LoadDatasetCommand(sample.schema));
        this.simplePythonKernel.getLink().receiveJsonResponse(WaitingForDataResponse.class);
        ExecutorService executor = Executors.newCachedThreadPool();
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(executor);
        try (FileInputStream fis = new FileInputStream(sample.getDataFile());
             final GZIPInputStream gis = new GZIPInputStream((InputStream)fis, 10240);
             final PipedOutputStream pos = new PipedOutputStream();
             final PipedInputStream pis = new PipedInputStream(pos, 10240);
             final FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Reading records", (double)-1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE);){
            completionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int bytes;
                    byte[] buffer = new byte[10240];
                    long total = 0L;
                    while ((bytes = gis.read(buffer)) != -1) {
                        pos.write(buffer, 0, bytes);
                        fp.set((double)(total += (long)bytes));
                    }
                    pos.close();
                    return null;
                }
            });
            completionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    EDAKernelProtocol.this.simplePythonKernel.getLink().sendStream((InputStream)pis, 100000);
                    return null;
                }
            });
            completionService.take().get();
            completionService.take().get();
            this.simplePythonKernel.getLink().receiveJsonResponse(DatasetReceivedResponse.class);
            logger.info((Object)("Streaming completed in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        }
        finally {
            executor.shutdownNow();
        }
    }

    public void loadDataset(Dataset dataset, StreamableDatasetSelection selection) throws IOException, InterruptedException, CodedException {
        this.lock.lockInterruptibly();
        try {
            this.loadDatasetUnguarded(dataset, selection);
        }
        catch (Exception e) {
            this.simplePythonKernel.close();
            throw new CodedException((InfoMessage.MessageCode)EdaErrorCodes.ERR_EDA_COMPUTE_KERNEL_FAILURE, "Could not stream dataset to EDA Python kernel", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDatasetUnguarded(final Dataset dataset, final StreamableDatasetSelection selection) throws IOException, InterruptedException, ExecutionException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info((Object)("Started streaming dataset " + dataset.getFullName() + " to Python engine..."));
        this.simplePythonKernel.getLink().sendRequest((Object)new LoadDatasetCommand(dataset.getSchema()));
        this.simplePythonKernel.getLink().receiveJsonResponse(WaitingForDataResponse.class);
        ExecutorService executor = Executors.newCachedThreadPool();
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(executor);
        try (final PipedOutputStream pos = new PipedOutputStream();
             final PipedInputStream pis = new PipedInputStream(pos, 10240);){
            completionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    StreamColumnFactory cf = new StreamColumnFactory();
                    StreamRowFactory rf = new StreamRowFactory();
                    CSVFormatConfig csvf = CSVFormatConfig.getStandardTabExcelFormat();
                    csvf.parseHeaderRow = false;
                    CSVOutputFormatter formatter = new CSVOutputFormatter(csvf);
                    formatter.setOutputSchema(dataset.getSchema());
                    StreamOutputWriter out = new StreamOutputWriter((OutputStream)pos, (OutputFormatter)formatter);
                    out.init((ColumnFactory)cf);
                    UniversalSingleThreadPusher.push(EDAKernelProtocol.this.simplePythonKernel.getAuthCtx(), dataset, selection, (ProcessorOutput)out, (ColumnFactory)cf, (RowFactory)rf);
                    out.lastRowEmitted();
                    return null;
                }
            });
            completionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    EDAKernelProtocol.this.simplePythonKernel.getLink().sendStream((InputStream)pis, 100000);
                    return null;
                }
            });
            completionService.take().get();
            completionService.take().get();
            this.simplePythonKernel.getLink().receiveJsonResponse(DatasetReceivedResponse.class);
            logger.info((Object)("Streaming completed in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Override
    public ComputationResultSession computeAndOpenSession(Computation computation) throws CodedException, IOException, InterruptedException {
        this.lock.lockInterruptibly();
        try {
            ComputationResult computationResult = this.computeUnguarded(computation);
            EDAKernelComputationResultSession eDAKernelComputationResultSession = new EDAKernelComputationResultSession(this.simplePythonKernel, this.lock, computationResult);
            return eDAKernelComputationResultSession;
        }
        catch (Exception e) {
            logger.error((Object)("Error occurred while executing running computation: \n" + JSON.pretty((Object)((Object)computation))), (Throwable)e);
            this.simplePythonKernel.close();
            throw new CodedException((InfoMessage.MessageCode)EdaErrorCodes.ERR_EDA_COMPUTE_KERNEL_FAILURE, "Could not run computation in EDA Python kernel", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isAlive() {
        return this.simplePythonKernel.isAlive();
    }

    private ComputationResult computeUnguarded(Computation computation) throws IOException, InterruptedException {
        ComputationResult result;
        logger.info((Object)"Started computing computation");
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Computation: " + JSON.pretty((Object)((Object)computation))));
        }
        NullChecker.checkObject((Object)((Object)computation));
        TransactionContext.assertNoAttachedTransaction();
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (computation.isMulti()) {
            result = this.doChunkedMultiComputation(computation.asMulti());
        } else {
            result = this.doChunkedMultiComputation(new MultiComputation(computation));
            if (result.isAvailable()) {
                result = result.asMulti().get(0);
            }
        }
        logger.info((Object)("Computed computation in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        return result;
    }

    private ComputationResult doChunkedMultiComputation(MultiComputation computation) throws InterruptedException, IOException {
        logger.debug((Object)"Started chunked multi-computation...");
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList<ComputationResult> results = new ArrayList<ComputationResult>(computation.computations.size());
        int computationsCount = computation.computations.size();
        int currentComputation = 0;
        try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Performing computations", (double)computationsCount, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            for (List chunk : Lists.partition(computation.computations, (int)10)) {
                FutureProgress.updateState((double)currentComputation);
                this.simplePythonKernel.getLink().sendRequest((Object)new ComputeCommand(new MultiComputation(chunk)));
                ComputationResult fragmentResult = ((ResultResponse)this.simplePythonKernel.getLink().receiveJsonResponse(ResultResponse.class)).result;
                if (fragmentResult.isAvailable()) {
                    Iterables.addAll(results, (Iterable)fragmentResult.asMulti());
                } else {
                    results.addAll(Collections.nCopies(chunk.size(), fragmentResult));
                }
                currentComputation += 10;
            }
        }
        MultiComputation.MultiComputationResult mcr = new MultiComputation.MultiComputationResult(results);
        NullChecker.checkObject((Object)mcr);
        logger.info((Object)("Computed results in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        return mcr;
    }

    private void stopKernelServer() throws InterruptedException, CodedException {
        this.lock.lockInterruptibly();
        try {
            this.stopKernelServerUnguarded();
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)EdaErrorCodes.ERR_EDA_COMPUTE_KERNEL_FAILURE, "Could not stop server on EDA Python kernel", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void stopKernelServerUnguarded() throws IOException {
        logger.info((Object)"Requesting to stop server on Python engine...");
        this.simplePythonKernel.getLink().sendRequest((Object)new StopKernelServerCommand());
        this.simplePythonKernel.getLink().receiveJsonResponse(KernelServerStoppedResponse.class);
        logger.info((Object)"Successfully stopped server on Python engine");
    }

    @Override
    public void close() throws IOException, InterruptedException, CodedException {
        try {
            if (this.simplePythonKernel.isAlive()) {
                this.stopKernelServer();
            }
        }
        finally {
            this.simplePythonKernel.close();
        }
    }

    static class LoadDatasetCommand
    extends Command {
        public Schema schema;

        LoadDatasetCommand(Schema schema) {
            this.schema = schema;
        }

        private LoadDatasetCommand() {
        }
    }

    static class WaitingForDataResponse
    extends Response {
        WaitingForDataResponse() {
        }
    }

    static class DatasetReceivedResponse
    extends Response {
        DatasetReceivedResponse() {
        }
    }

    static class ComputeCommand
    extends Command {
        Computation computation;

        ComputeCommand(Computation computation) {
            this.computation = computation;
        }

        private ComputeCommand() {
        }
    }

    static class ResultResponse
    extends Response {
        ComputationResult result;

        ResultResponse() {
        }
    }

    static class StopKernelServerCommand
    extends Command {
        StopKernelServerCommand() {
        }
    }

    static class KernelServerStoppedResponse
    extends Response {
        KernelServerStoppedResponse() {
        }
    }

    static class DataStreamClearedResponse
    extends Response {
        DataStreamClearedResponse() {
        }
    }

    static class DataStreamEndedResponse
    extends Response {
        @Nullable
        String error;

        DataStreamEndedResponse() {
        }
    }

    @PolyJSON(value={@Mapping(value=DatasetReceivedResponse.class, type="DatasetReceived"), @Mapping(value=WaitingForDataResponse.class, type="WaitingForData"), @Mapping(value=ResultResponse.class, type="ComputationResult"), @Mapping(value=DataStreamEndedResponse.class, type="DataStreamEnded"), @Mapping(value=DataStreamClearedResponse.class, type="DataStreamCleared"), @Mapping(value=KernelServerStoppedResponse.class, type="KernelServerStopped")})
    static abstract class Response {
        Response() {
        }
    }

    static class ClearDataStreamCommand
    extends Command {
        List<ComputationResultDataStreamer.DataStreamId> dataStreamIds;

        public ClearDataStreamCommand(List<ComputationResultDataStreamer.DataStreamId> dataStreamIds) {
            this.dataStreamIds = dataStreamIds;
        }

        private ClearDataStreamCommand() {
        }
    }

    static class FetchDataStreamCommand
    extends Command {
        ComputationResultDataStreamer.DataStreamId dataStreamId;

        public FetchDataStreamCommand(ComputationResultDataStreamer.DataStreamId dataStreamId) {
            this.dataStreamId = dataStreamId;
        }

        private FetchDataStreamCommand() {
        }
    }

    @PolyJSON(value={@Mapping(value=LoadDatasetCommand.class, type="LoadDataset"), @Mapping(value=ComputeCommand.class, type="Compute"), @Mapping(value=FetchDataStreamCommand.class, type="FetchDataStream"), @Mapping(value=ClearDataStreamCommand.class, type="ClearDataStream"), @Mapping(value=StopKernelServerCommand.class, type="StopKernelServer")})
    static abstract class Command {
        Command() {
        }
    }
}

