/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eventserver;

import com.codahale.metrics.json.MetricsModule;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.eventserver.ProcessingQueue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class StatsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ProcessingQueue processingQueue;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.eventserver.api");

    public StatsServlet() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.processingQueue.getSettings().checkStatsCallAuth(req);
        }
        catch (DKUSecurityException e) {
            logger.error((Object)"Authentication failed", (Throwable)e);
            resp.setStatus(401);
            return;
        }
        logger.info((Object)"HTTP: requesting metrics dump");
        ObjectMapper om = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
        resp.setContentType("application/json");
        om.writerWithDefaultPrettyPrinter().writeValue((OutputStream)resp.getOutputStream(), (Object)DSSMetrics.registry());
    }
}

