/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.export.CustomExporterDesc;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.LoadedExporter;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.security.AuthCtx;
import java.io.IOException;
import java.io.OutputStream;

public abstract class CustomLoadedExporter<LoadedDesc extends LoadedExporter<? extends CustomExporterDesc>> {
    protected LoadedDesc loaded;

    public CustomLoadedExporter(LoadedDesc loaded) {
        this.loaded = loaded;
    }

    public String getType() {
        return ((LoadedExporter)this.loaded).exporterType;
    }

    public CustomExporterDesc.ExportBehavior getBehavior() {
        return ((CustomExporterDesc)((LoadedExporter)this.loaded).desc).exportBehavior;
    }

    public MimeTypeUtils.MimeType getMimeType(ExportParams params) {
        if (((CustomExporterDesc)((LoadedExporter)this.loaded).desc).exportBehavior == CustomExporterDesc.ExportBehavior.OUTPUT_TO_FILE) {
            if (((CustomExporterDesc)((LoadedExporter)this.loaded).desc).compression == CustomExporterDesc.ExportCompression.FILE_OR_STREAM_TO_GZIP) {
                return new MimeTypeUtils.MimeType("application/x-gzip", ".gz");
            }
            if (((CustomExporterDesc)((LoadedExporter)this.loaded).desc).compression == CustomExporterDesc.ExportCompression.DIR_TO_ZIP) {
                return new MimeTypeUtils.MimeType("application/x-zip", ".zip");
            }
            return ((CustomExporterDesc)((LoadedExporter)this.loaded).desc).mime;
        }
        throw new IllegalArgumentException("Managed output exporters don't provide an extension");
    }

    public abstract ExportOutput create(AuthCtx var1, ExportStatus var2, ExportParams var3, OutputStream var4) throws IOException;

    public IPluginifiedMeta getPluginifiedMeta() {
        return new IPluginifiedMeta(){

            @Override
            public IElementLoadedDesc getLoadedDesc() {
                return CustomLoadedExporter.this.loaded;
            }
        };
    }
}

