/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;

public abstract class FutureThread<T>
extends FutureThreadBase<T> {
    protected final DSSAuthCtx owner;
    private ScenarioRun scenarioRun;
    private StepRun stepRun;
    private ScenarioRunContext scenarioRunContext;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.futures");

    public FutureThread(DSSAuthCtx owner) {
        this(owner, null);
    }

    public FutureThread(DSSAuthCtx owner, String jobIdPrefix) {
        super(null, jobIdPrefix);
        this.owner = owner;
    }

    public DSSAuthCtx getOwner() {
        return this.owner;
    }

    public String getOwnerIdentifier() {
        return this.owner.getIdentifier();
    }

    public Integer getUsedFekPort() {
        if (RemoteRunNetworkingUtils.getServerKind() == MainLoggingConfigurator.ProcessType.FEK) {
            return RemoteRunNetworkingUtils.getServerPort();
        }
        return null;
    }

    public void setScenarioRun(ScenarioRun scenarioRun, StepRun stepRun, ScenarioRunContext scenarioRunContext) {
        this.scenarioRun = scenarioRun;
        this.stepRun = stepRun;
        this.scenarioRunContext = scenarioRunContext;
    }

    public void clearScenarioRunContext() {
        if (this.scenarioRunContext != null) {
            this.scenarioRunContext.clearScenarioRun();
            this.scenarioRunContext.clearStepRun();
        }
    }

    public void preExecute() {
        if (this.scenarioRunContext != null) {
            this.scenarioRunContext.setScenarioRun(this.scenarioRun);
            this.scenarioRunContext.setStepRun(this.stepRun);
        }
    }
}

