/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.i18n;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Charsets;
import com.dataiku.dss.shadelib.com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class BackendTranslationService
implements TranslationService {
    public static final String DEFAULT_LANGUAGE = "en";
    private final Map<String, LanguageData> languages = new HashMap<String, LanguageData>();
    private volatile boolean editionEnabled = false;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.services.i18n");

    public BackendTranslationService() {
        this.init();
    }

    @PostConstruct
    public void init() {
        try {
            File[] files;
            this.editionEnabled = ApplicationConfigurator.getParams().getBoolParam("dku.translations.edition", false);
            logger.info((Object)"Loading translations");
            File resourceFolder = DKUApp.getResourceFile((String[])new String[]{"i18n", "backend"});
            if (resourceFolder.isDirectory() && (files = resourceFolder.listFiles()) != null) {
                for (File f : files) {
                    logger.info((Object)("Loading translations from " + String.valueOf(f)));
                    if (!f.getName().endsWith(".json")) continue;
                    String languageCode = f.getName().replace(".json", "");
                    LanguageData ld = (LanguageData)JSON.parseFile((File)f, LanguageData.class);
                    if (this.editionEnabled) {
                        ld.file = f;
                        ld.lastModified = f.lastModified();
                    }
                    this.languages.put(languageCode, ld);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load translations", e);
        }
    }

    @Override
    public String translate(String id, String defaultValue, Object ... args) {
        LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
        Locale locale = localeContext != null ? localeContext.getLocale() : null;
        return this.translateNoContext(locale != null ? locale.getLanguage() : null, id, defaultValue, args);
    }

    @Override
    public String translateNoContext(String lang, String id, String defaultValue, Object ... args) {
        if (args == null || args.length == 0) {
            return this.translateNoContext(lang, id, defaultValue, null);
        }
        Map<String, Object> mapArgs = BackendTranslationService.toMap(args);
        return this.translateNoContext(lang, id, defaultValue, mapArgs);
    }

    @Override
    public String translateNoContext(String lang, String id, String defaultValue, Map<String, Object> args) {
        if (lang == null) {
            return defaultValue;
        }
        LanguageData languageData = this.getLanguageData(lang);
        if (languageData == null) {
            logger.debug((Object)("Unable to load language data for translation " + id));
            return defaultValue;
        }
        String translatedFormat = languageData.translations.get(id);
        if (translatedFormat == null) {
            logger.debug((Object)("Unable to load translation for " + id));
            return defaultValue;
        }
        try {
            String prefix = "{{";
            String suffix = "}}";
            StringSubstitutor substitutor = new StringSubstitutor(args, prefix, suffix);
            substitutor.setEnableUndefinedVariableException(false);
            substitutor.setEscapeChar('\\');
            substitutor.setVariableResolver(key -> {
                if (args == null) {
                    return "";
                }
                Object value = args.get(key);
                if (value == null) {
                    return "";
                }
                return String.valueOf(value);
            });
            return substitutor.replace(translatedFormat);
        }
        catch (Exception e) {
            logger.debug((Object)("Unable to format translation " + id + ": /" + translatedFormat + "/ for lang " + lang), (Throwable)e);
            return defaultValue;
        }
    }

    public static Map<String, Object> toMap(Object ... args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < args.length - 1; i += 2) {
            if (args[i] == null || args[i + 1] == null) continue;
            String key = args[i].toString();
            Object value = args[i + 1];
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Map<String, String> getTranslations(String location, String language) {
        try {
            File translationsFile = this.getTranslationsFile(location, language);
            if (!translationsFile.exists()) {
                return null;
            }
            LanguageData ld = (LanguageData)JSON.parseFile((File)translationsFile, LanguageData.class);
            return ld.translations;
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to load translation file: " + location + "/" + language), (Throwable)e);
            return null;
        }
    }

    @Override
    public File getTranslationsFile(String location, String language) {
        if (!"frontend".equals(location) && !"backend".equals(location)) {
            throw new IllegalArgumentException("Invalid location:" + location);
        }
        if ("backend".equals(location) && !this.editionEnabled) {
            throw new IllegalStateException("Backend translation files cannot be loaded");
        }
        String actualLanguage = StringUtils.isBlank((CharSequence)language) ? DEFAULT_LANGUAGE : language;
        File f = DKUApp.getResourceFile((String[])new String[]{"i18n", location, actualLanguage + ".json"});
        if (f.exists() && f.isFile()) {
            return f;
        }
        return null;
    }

    @Override
    public void saveTranslationsFile(String location, String language, String translations) throws IOException {
        if (!this.editionEnabled) {
            throw new IllegalStateException("Translation files cannot be saved. Enable the translation edition mode first.");
        }
        if (translations.startsWith("data:application/json;base64,")) {
            translations = new String(BaseEncoding.base64().decode((CharSequence)translations.substring(29)), Charsets.UTF_8);
        }
        LanguageData languageData = (LanguageData)JSON.parse((String)translations, LanguageData.class);
        String formatted = JSON.createGsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((Object)languageData);
        File f = this.getTranslationsFile(location, language);
        DKUFileUtils.writeFileUTF8((File)f, (String)formatted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LanguageData getLanguageData(String lang) {
        if (this.editionEnabled) {
            BackendTranslationService backendTranslationService = this;
            synchronized (backendTranslationService) {
                LanguageData languageData = this.languages.get(lang);
                if (languageData == null) {
                    return null;
                }
                if (languageData.file.lastModified() != languageData.lastModified) {
                    try {
                        File file = languageData.file;
                        LanguageData updatedLanguageData = (LanguageData)JSON.parseFile((File)file, LanguageData.class);
                        updatedLanguageData.file = file;
                        updatedLanguageData.lastModified = file.lastModified();
                        this.languages.put(lang, updatedLanguageData);
                        return updatedLanguageData;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to load translations", e);
                    }
                }
                return languageData;
            }
        }
        return this.languages.get(lang);
    }

    public static class LanguageData
    implements TranslationService.LanguageData {
        public Map<String, String> translations = new HashMap<String, String>();
        @JSON.FileTransient
        File file;
        @JSON.FileTransient
        long lastModified;
    }
}

