/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.rcfile;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.hive.HiveFormatExtractor;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatConfig;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.RecordReader;

public class RCFileFormatExtractor
extends HiveFormatExtractor<RCFileFormatConfig> {
    public RCFileFormatExtractor(RCFileFormatConfig config) {
        super(config);
    }

    @Override
    public InputFormat<Writable, Writable> createInputFormat() {
        return new RCFileInputFormat();
    }

    @Override
    public Writable getKey(Object serde, RecordReader<Writable, Writable> recordReader) {
        return new LongWritable();
    }

    @Override
    public Writable getValue(Object serde, RecordReader<Writable, Writable> recordReader) {
        try {
            return this.serdeAccessUtils.getSerializedClass(serde).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instanciate value class", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Schema inferSchema(FileSystem fs, Path hdfsPath) throws IOException {
        Schema schema = new Schema();
        Configuration configuration = new Configuration();
        try (RCFile.Reader reader = new RCFile.Reader(fs, hdfsPath, configuration);){
            SequenceFile.Metadata metadata = reader.getMetadata();
            int nbCols = Integer.parseInt(metadata.get(new Text("hive.io.rcfile.column.number")).toString());
            for (int i = 0; i < nbCols; ++i) {
                schema.addColumn("col_" + (i + 1), Type.STRING);
            }
        }
        return schema;
    }
}

