/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.sequencefile;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.hive.HiveFileFormatConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class LazySimpleSerDeSchemaInferrer {
    private final String fieldSeparator;

    public LazySimpleSerDeSchemaInferrer(HiveFileFormatConfig config) {
        this.fieldSeparator = (String)config.getSerdeProperties().get("field.delim");
    }

    public Schema detect(List<Writable> rows) {
        Object str;
        Histogram histogram = new Histogram();
        for (Writable row : rows) {
            str = ((Text)row).toString();
            histogram.increment(StringUtils.countMatches((String)str, (String)this.fieldSeparator) + 1);
        }
        int mostLikely = 0;
        int confidence = 0;
        str = histogram.bins().iterator();
        while (str.hasNext()) {
            int bin = (Integer)str.next();
            if (histogram.read(bin) < confidence) continue;
            mostLikely = bin;
            confidence = histogram.read(bin);
        }
        Schema magicSchema = new Schema();
        for (int i = 0; i < mostLikely; ++i) {
            magicSchema.addColumn("col_" + i, Type.STRING);
        }
        return magicSchema;
    }

    private static class Histogram {
        private final HashMap<Integer, MutableInt> map = new HashMap();

        private Histogram() {
        }

        public void increment(int bin) {
            MutableInt mi = this.map.get(bin);
            if (mi == null) {
                mi = new MutableInt();
                this.map.put(bin, mi);
            }
            mi.increment();
        }

        public int read(int bin) {
            MutableInt mi = this.map.get(bin);
            if (mi == null) {
                return 0;
            }
            return mi.intValue();
        }

        public List<Integer> bins() {
            return new ArrayList<Integer>(this.map.keySet());
        }
    }
}

