/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.input.formats.parquet.ConverterFactory;
import com.dataiku.dip.input.formats.parquet.ParentValueContainer;
import org.apache.log4j.Logger;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;
import org.json.JSONArray;

class HiveArrayConverter
extends GroupConverter {
    private static Logger logger = Logger.getLogger(HiveArrayConverter.class);
    private final ParentValueContainer parent;
    private final Type parquetType;
    private final GroupConverter arrayConverter;
    private final Converter elementConverter;
    private Object currentValue;
    private JSONArray jsonArray;

    public HiveArrayConverter(ConverterFactory cf, Type parquetType, SchemaColumn sc, ParentValueContainer parent) {
        this.parent = parent;
        this.parquetType = parquetType;
        GroupType bagType = parquetType.asGroupType().getType(0).asGroupType();
        this.elementConverter = cf.createConverter(bagType.getType(0), sc, new ParentValueContainer(){

            @Override
            void add(Object value) {
                HiveArrayConverter.this.currentValue = value;
            }
        });
        this.arrayConverter = new GroupConverter(){

            public Converter getConverter(int i) {
                return HiveArrayConverter.this.elementConverter;
            }

            public void start() {
                HiveArrayConverter.this.currentValue = null;
            }

            public void end() {
                HiveArrayConverter.this.jsonArray.put(HiveArrayConverter.this.currentValue);
            }
        };
    }

    public Converter getConverter(int i) {
        return this.arrayConverter;
    }

    public void start() {
        this.jsonArray = new JSONArray();
    }

    public void end() {
        if (this.jsonArray != null) {
            this.parent.add(this.jsonArray);
        }
        this.jsonArray = null;
    }
}

