/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.remote;

import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FTPConnection;
import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.utils.FlowVariables;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.Globbing;
import com.dataiku.dip.input.remote.FTPRemote;
import com.dataiku.dip.input.remote.SFTPRemote;
import com.dataiku.dip.input.remote.SSHRemote;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteFileUtils {
    @Autowired
    ICredentialsService connectionCredentialsService;
    @Autowired
    PasswordEncryptionService symetricCryptoService;
    private static Logger logger = Logger.getLogger((String)"dku.remotefiles");

    public RemoteFileUtils() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public static String substituteVariables(String url, Dataset dataset, String outputPartition) throws IOException, CodedException, DKUSecurityException {
        if (dataset.getPartitioningSchema().isPartitioned()) {
            HashMap<String, String> map = new HashMap<String, String>();
            FlowVariables.addVariablesForDstDataset(DSSAuthCtx.newNone(), map, dataset, PartitionFactory.fromIdentifier(dataset.getPartitioningSchema(), outputPartition), "DKU_DST_");
            return FlowVariables.substitute(map, url);
        }
        return url;
    }

    public static String targetPathInDataset(Dataset dataset, String outputPartition) {
        Object pathInDataset = "/";
        PartitioningScheme scheme = dataset.getPartitioningSchema();
        if (scheme.isPartitioned()) {
            pathInDataset = (String)pathInDataset + FilePartitioner.computePartitionRelPathAsFolder(PartitionFactory.fromIdentifier(scheme, outputPartition), scheme);
        } else assert (outputPartition.equals("NP"));
        return pathInDataset;
    }

    static String localName(String glob, String remoteName) {
        int i;
        String[] globSegments = glob.split("/", -1);
        String[] remoteSegments = remoteName.split("/", -1);
        assert (remoteSegments.length >= globSegments.length);
        for (i = 0; i < globSegments.length - 1 && !Globbing.hasGlobbing((String)globSegments[i]); ++i) {
        }
        int j = remoteSegments.length - globSegments.length + i;
        Object result = remoteSegments[j];
        ++j;
        while (j < remoteSegments.length) {
            result = (String)result + "_" + remoteSegments[j];
            ++j;
        }
        return result;
    }

    public TestResult testSource(AuthCtx authCtx, DSSConnection conn, String protocol, String path) throws DKUSecurityException {
        TestResult result = new TestResult();
        result.ok = true;
        int errNum = 0;
        int maxErr = 10;
        if (StringUtils.isBlank((String)path)) {
            path = "*";
        }
        if (conn instanceof SSHConnection) {
            try (SSHRemote ssh = this.getSSHRemote(authCtx, (SSHConnection)conn, protocol);){
                ArrayList<RemoteFile> dirs = new ArrayList<RemoteFile>();
                EnumerationResult r = ssh.resolveGlob(path);
                if (r.error) {
                    result.ok = false;
                    for (String m : r.msg) {
                        if (errNum >= maxErr) break;
                        result.errorMessage = result.errorMessage + m + "\n";
                        ++errNum;
                    }
                }
                for (RemoteFile rf : r.files) {
                    if (rf.type == 'f') {
                        ++result.nbFiles;
                        result.totalSize += rf.size;
                        result.filenames.add(rf.name);
                        continue;
                    }
                    dirs.add(rf);
                }
                r = ssh.enumerate(dirs);
                if (r.error) {
                    result.ok = false;
                    for (String m : r.msg) {
                        if (errNum >= maxErr) break;
                        result.errorMessage = result.errorMessage + m + "\n";
                        ++errNum;
                    }
                }
                for (RemoteFile rf1 : r.files) {
                    if (rf1.type != 'f') continue;
                    ++result.nbFiles;
                    result.totalSize += rf1.size;
                    result.filenames.add(rf1.name);
                }
                if (result.ok && result.nbFiles == 0) {
                    result.ok = false;
                    result.errorMessage = "No matching remote file";
                }
            }
            catch (IOException e) {
                result.ok = false;
                result.errorMessage = e.getMessage();
            }
        } else if (conn instanceof FTPConnection) {
            path = RemoteFileUtils.prependRootPath((FTPConnection)conn, path);
            try (FTPRemote ftp = this.getFTPRemote(authCtx, (FTPConnection)conn);){
                for (RemoteFile rf : ftp.resolveGlob(path)) {
                    if (rf.type == 'f') {
                        ++result.nbFiles;
                        result.totalSize += rf.size;
                        result.filenames.add(rf.name);
                        continue;
                    }
                    for (RemoteFile rf1 : ftp.enumerate(rf)) {
                        if (rf1.type != 'f') continue;
                        ++result.nbFiles;
                        result.totalSize += rf1.size;
                        result.filenames.add(rf1.name);
                    }
                }
                if (result.ok && result.nbFiles == 0) {
                    result.ok = false;
                    result.errorMessage = "No matching remote file";
                }
            }
            catch (IOException e) {
                result.ok = false;
                result.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
                logger.warn((Object)"FTP source test failed", (Throwable)e);
            }
        } else {
            result.errorMessage = "Invalid connection type : " + conn.getType();
            result.ok = false;
        }
        return result;
    }

    public static FTPConnection ParseFtpConnection(String ftpUrl, boolean useGlobalProxy) throws MalformedURLException {
        URL url = new URL(ftpUrl);
        if (!url.getProtocol().equals("ftp")) {
            throw new MalformedURLException("not a FTP url : " + ftpUrl);
        }
        if (url.getHost().isEmpty()) {
            throw new MalformedURLException("no host specified : " + ftpUrl);
        }
        String user = null;
        String pwd = null;
        String userInfo = url.getUserInfo();
        if (userInfo != null) {
            int colon = userInfo.indexOf(58);
            if (colon >= 0) {
                user = userInfo.substring(0, colon);
                pwd = userInfo.substring(colon + 1);
            } else {
                user = userInfo;
            }
        }
        Object path = null;
        FTPConnection conn = new FTPConnection();
        conn.name = "xxx-ftp-connection-xxx";
        conn.allowManagedDatasets = false;
        conn.allowWrite = false;
        conn.useGlobalProxy = useGlobalProxy;
        conn.params.host = url.getHost();
        if (url.getPort() > 0) {
            conn.params.port = url.getPort();
        }
        conn.params.user = user;
        conn.params.password = pwd;
        conn.params.path = path;
        conn.params.file = url.getFile();
        conn.params.connectionLimit = 1;
        conn.params.passive = true;
        return conn;
    }

    SSHRemote getSSHRemote(AuthCtx authCtx, SSHConnection conn, String protocol) throws IOException, DKUSecurityException {
        SSHConnection.SerializableSSHCredentials creds = conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(null, protocol), SSHConnection.SerializableSSHCredentials.class);
        if ("SFTP".equals(protocol)) {
            return new SFTPRemote(conn.params.host, creds.user, creds.usePublicKey, creds.passphrase, creds.password, conn.params.port, 10000);
        }
        return new SSHRemote(conn.params.host, creds.user, creds.usePublicKey, creds.passphrase, creds.password, conn.params.port, 10000);
    }

    FTPRemote getFTPRemote(AuthCtx authCtx, FTPConnection conn) throws IOException, DKUSecurityException {
        ICredentialsService.BasicCredential credentials = conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ICredentialsService.BasicCredential.class);
        return new FTPRemote(conn.params.host, conn.params.port, credentials.user, credentials.password, conn.params.passive, conn.getProxySettings(), 30000);
    }

    static String prependRootPath(FTPConnection conn, String glob) {
        String rootPath = conn.params.path;
        if (StringUtils.isBlank((String)rootPath)) {
            return glob;
        }
        return rootPath + (glob.isEmpty() || glob.startsWith("/") || rootPath.endsWith("/") ? "" : "/") + glob;
    }

    public static class TestResult {
        public boolean ok;
        public String errorMessage = "";
        public int nbFiles;
        public long totalSize;
        public List<String> filenames = new ArrayList<String>();
    }

    public static class EnumerationResult {
        List<RemoteFile> files = new ArrayList<RemoteFile>();
        boolean error;
        List<String> msg = new ArrayList<String>();
    }

    public static class RemoteFile {
        char type;
        String name;
        long size;
        long mtime;

        RemoteFile() {
        }

        public RemoteFile(String name, long size, long mtime) {
            this.type = (char)102;
            this.name = name;
            this.size = size;
            this.mtime = mtime;
        }

        public RemoteFile(String name) {
            this.type = (char)100;
            this.name = name;
        }

        public String basename() {
            return this.name.substring(this.name.lastIndexOf("/") + 1);
        }

        String relativeName(String dirname) {
            assert (this.name.startsWith(dirname + "/"));
            return this.name.substring(dirname.length() + 1);
        }

        public boolean isDirectory() {
            return this.type == 'd';
        }

        public String path() {
            return this.name;
        }

        public long size() {
            return this.size;
        }

        public long mtime() {
            return this.mtime;
        }
    }
}

