/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai.api.responses;

import com.dataiku.dip.connections.AzureAIFoundryConnection;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.online.openai.api.ReasoningEffort;
import com.dataiku.dip.llm.online.openai.api.responses.OpenAIResponsesQuery;
import com.dataiku.dip.llm.utils.json_schema.JSONSchemaCompatibilityEnhancer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class OpenAIResponsesQueryAdapter {
    public static OpenAIResponsesQuery adaptForStreaming(LLMModelHandle.Model model, List<LLMClient.ChatMessage> messages, CoreCompletionSettings settings) {
        OpenAIResponsesQuery query = OpenAIResponsesQueryAdapter.adapt(model, messages, settings);
        query.stream = true;
        return query;
    }

    public static OpenAIResponsesQuery adapt(LLMModelHandle.Model model, List<LLMClient.ChatMessage> messages, CoreCompletionSettings settings) {
        return OpenAIResponsesQueryAdapter.adapt(model.getId(), model, messages, settings);
    }

    public static OpenAIResponsesQuery adapt(String modelId, LLMModelHandle.Model model, List<LLMClient.ChatMessage> messages, CoreCompletionSettings settings) {
        OpenAIResponsesQuery query = new OpenAIResponsesQuery();
        query.model = modelId;
        if (settings.maxTokens != null && settings.maxTokens > 0) {
            query.maxOutputTokens = settings.maxTokens;
        }
        if (settings.temperature != null) {
            query.temperature = settings.temperature;
        }
        if (settings.topP != null) {
            query.topP = settings.topP;
        }
        if (settings.toolChoice != null) {
            query.toolChoice = OpenAIResponsesQueryAdapter.adaptOpenAIToolChoice(settings.toolChoice);
        }
        if (settings.logProbs != null && settings.logProbs.booleanValue()) {
            query.include.add("message.output_text.logprobs");
        }
        if (settings.topLogProbs != null) {
            query.topLogProbs = settings.topLogProbs;
        }
        if (settings.tools != null) {
            for (LLMClient.AbstractTool abstractTool : settings.tools) {
                if (!(abstractTool instanceof LLMClient.FunctionTool)) continue;
                LLMClient.FunctionTool dssFunctionTool = (LLMClient.FunctionTool)abstractTool;
                OpenAIResponsesQuery.ToolSchema toolSchema = new OpenAIResponsesQuery.ToolSchema();
                toolSchema.type = "function";
                toolSchema.name = dssFunctionTool.function.name;
                toolSchema.description = dssFunctionTool.function.description;
                toolSchema.parameters = dssFunctionTool.function.getParameters();
                query.tools.add(toolSchema);
            }
        }
        if (settings.includeReasoning != null && settings.includeReasoning.booleanValue()) {
            query.reasoning = new OpenAIResponsesQuery.Reasoning();
            query.reasoning.summary = "auto";
        }
        if (settings.reasoningEffort != null) {
            if (query.reasoning == null) {
                query.reasoning = new OpenAIResponsesQuery.Reasoning();
            }
            if (settings.reasoningEffort == LLMClient.ReasoningEffort.OFF) {
                if (model instanceof AzureAIFoundryConnection.AzureAIFoundryModel) {
                    AzureAIFoundryConnection.AzureAIFoundryModel aiFoundryModel = (AzureAIFoundryConnection.AzureAIFoundryModel)model;
                    query.reasoning.effort = aiFoundryModel.modelHandlingMode.getLowestReasoningEffort();
                } else {
                    query.reasoning.effort = ReasoningEffort.minimal;
                }
            } else if (settings.reasoningEffort == LLMClient.ReasoningEffort.STANDARD) {
                query.reasoning.effort = ReasoningEffort.medium;
            } else if (settings.reasoningEffort == LLMClient.ReasoningEffort.CUSTOM) {
                if (StringUtils.isEmpty((String)settings.customReasoningEffort)) {
                    throw new IllegalArgumentException(String.format("Custom reasoning effort cannot be null or empty: %s ", settings.customReasoningEffort));
                }
                try {
                    query.reasoning.effort = Enum.valueOf(ReasoningEffort.class, settings.customReasoningEffort);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Invalid custom reasoning effort parameter for OpenAI: %s. Supported values are: 'minimal', 'low', 'medium', and 'high'.", settings.customReasoningEffort));
                }
            } else {
                throw new IllegalArgumentException(String.format("Unsupported Reasoning Effort for OpenAI: expected OFF, STANDARD or CUSTOM but received %s.", new Object[]{settings.reasoningEffort}));
            }
        }
        if (settings.responseFormat != null) {
            query.text = new OpenAIResponsesQuery.Text();
            if (settings.responseFormat instanceof LLMClient.ResponseFormatText) {
                query.text.responseFormat = new OpenAIResponsesQuery.OpenAIResponseFormatText();
            } else {
                LLMClient.ResponseFormat responseFormat = settings.responseFormat;
                if (responseFormat instanceof LLMClient.ResponseFormatJson) {
                    LLMClient.ResponseFormatJson responseFormatJson = (LLMClient.ResponseFormatJson)responseFormat;
                    JsonObject jsonObject = responseFormatJson.schema;
                    if (jsonObject == null) {
                        query.text.responseFormat = new OpenAIResponsesQuery.OpenAIResponseFormatJSONObject();
                    } else {
                        OpenAIResponsesQuery.OpenAIResponseFormatJSONSchema oaiResponseFormat = new OpenAIResponsesQuery.OpenAIResponseFormatJSONSchema();
                        boolean strict = responseFormatJson.strict == null || responseFormatJson.strict != false;
                        boolean compatible = responseFormatJson.compatible == null ? strict : responseFormatJson.compatible;
                        oaiResponseFormat.schema = JSONSchemaCompatibilityEnhancer.enhance(jsonObject, compatible ? JSONSchemaCompatibilityEnhancer.Provider.OPENAI : JSONSchemaCompatibilityEnhancer.Provider.PASSTHROUGH);
                        JsonElement descriptionElement = jsonObject.get("description");
                        if (descriptionElement != null && descriptionElement.isJsonPrimitive()) {
                            oaiResponseFormat.description = jsonObject.get("description").getAsString();
                        }
                        oaiResponseFormat.name = OpenAIResponsesQueryAdapter.buildSchemaTitle(jsonObject);
                        oaiResponseFormat.strict = strict;
                        query.text.responseFormat = oaiResponseFormat;
                    }
                } else {
                    throw new IllegalArgumentException(String.format("Unknown response format: %s", settings.responseFormat.getClass().getSimpleName()));
                }
            }
        }
        query.input = messages.stream().map(OpenAIResponsesQueryAdapter::adapt).flatMap(Collection::stream).toList();
        return query;
    }

    public static String buildSchemaTitle(JsonObject jsonSchema) {
        String title;
        JsonElement titleElement = jsonSchema.get("title");
        if (titleElement != null && titleElement.isJsonPrimitive() && (title = titleElement.getAsString()) != null) {
            return title.replaceAll("[^a-zA-Z0-9-]", "-");
        }
        return "JSON";
    }

    private static List<OpenAIResponsesQuery.Input> adapt(LLMClient.ChatMessage message) {
        switch (message.role) {
            case "user": {
                return List.of(OpenAIResponsesQueryAdapter.adaptUserMessage(message));
            }
            case "system": {
                return List.of(OpenAIResponsesQueryAdapter.adaptSystemMessage(message));
            }
            case "assistant": {
                return OpenAIResponsesQueryAdapter.adaptAssistantMessage(message);
            }
            case "tool": {
                return OpenAIResponsesQueryAdapter.adaptToolOutput(message);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported chat message role: %s", message.role));
    }

    private static List<OpenAIResponsesQuery.Input> adaptAssistantMessage(LLMClient.ChatMessage message) {
        if (!message.isTextOnly()) {
            throw new IllegalArgumentException(String.format("Chat message with role: %s must be text-only", message.role));
        }
        if (message.toolCalls != null) {
            return message.toolCalls.stream().map(OpenAIResponsesQueryAdapter::adapt).collect(Collectors.toList());
        }
        OpenAIResponsesQuery.AssistantMessage assistantMessage = new OpenAIResponsesQuery.AssistantMessage();
        assistantMessage.content = message.getText();
        return List.of(assistantMessage);
    }

    private static OpenAIResponsesQuery.Message adaptUserMessage(LLMClient.ChatMessage message) {
        if (message.isTextOnly()) {
            OpenAIResponsesQuery.UserMessage textMessage = new OpenAIResponsesQuery.UserMessage();
            textMessage.content = message.getText();
            return textMessage;
        }
        OpenAIResponsesQuery.CompositeUserMessage msg = new OpenAIResponsesQuery.CompositeUserMessage();
        msg.content = new ArrayList<OpenAIResponsesQuery.MessageContent>();
        block5: for (LLMClient.ChatMessagePart part : message.parts) {
            switch (part.type) {
                case IMAGE_INLINE: {
                    String url;
                    OpenAIResponsesQuery.InputImageMessage inputImageMessage = new OpenAIResponsesQuery.InputImageMessage();
                    String mime = StringUtils.isBlank((String)part.imageMimeType) ? "image/jpeg" : part.imageMimeType;
                    inputImageMessage.imageUrl = url = String.format("data:%s;base64,%s", mime, part.inlineImage);
                    msg.content.add(inputImageMessage);
                    continue block5;
                }
                case IMAGE_URI: {
                    OpenAIResponsesQuery.InputImageMessage inputImageMessage = new OpenAIResponsesQuery.InputImageMessage();
                    inputImageMessage.imageUrl = part.imageUrl;
                    msg.content.add(inputImageMessage);
                    continue block5;
                }
                case TEXT: {
                    OpenAIResponsesQuery.InputTextMessage textMessage = new OpenAIResponsesQuery.InputTextMessage();
                    textMessage.text = part.text;
                    msg.content.add(textMessage);
                    continue block5;
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported user chat message part type: %s", new Object[]{part.type}));
        }
        return msg;
    }

    private static OpenAIResponsesQuery.Message adaptSystemMessage(LLMClient.ChatMessage message) {
        if (message.isTextOnly()) {
            OpenAIResponsesQuery.SystemMessage systemMessage = new OpenAIResponsesQuery.SystemMessage();
            systemMessage.content = message.getText();
            return systemMessage;
        }
        throw new IllegalArgumentException(String.format("Message with role %s must be text-only", message.role));
    }

    private static List<OpenAIResponsesQuery.Input> adaptToolOutput(LLMClient.ChatMessage message) {
        if (!message.isTextOnly()) {
            throw new IllegalArgumentException(String.format("Chat message with role: %s must be text-only", message.role));
        }
        if (message.toolOutputs == null) {
            throw new IllegalArgumentException(String.format("Chat message with role: %s must have tool outputs", message.role));
        }
        return message.toolOutputs.stream().map(OpenAIResponsesQueryAdapter::adapt).collect(Collectors.toList());
    }

    private static OpenAIResponsesQuery.ToolCallOuput adapt(LLMClient.ToolOutput to) {
        OpenAIResponsesQuery.ToolCallOuput tm = new OpenAIResponsesQuery.ToolCallOuput();
        tm.callId = to.callId;
        tm.output = to.output;
        return tm;
    }

    private static OpenAIResponsesQuery.ToolCallMessage adapt(LLMClient.AbstractToolCall tc) {
        LLMClient.FunctionToolCall ftc = (LLMClient.FunctionToolCall)tc;
        OpenAIResponsesQuery.ToolCallMessage toolCallMessage = new OpenAIResponsesQuery.ToolCallMessage();
        toolCallMessage.callId = ftc.id;
        toolCallMessage.name = ftc.function.name;
        toolCallMessage.arguments = ftc.function.arguments;
        return toolCallMessage;
    }

    private static OpenAIResponsesQuery.ToolChoice adaptOpenAIToolChoice(LLMClient.ToolChoice choice) {
        if (choice instanceof LLMClient.NoneToolChoice) {
            return OpenAIResponsesQuery.ConstantToolChoice.none;
        }
        if (choice instanceof LLMClient.RequiredToolChoice) {
            return OpenAIResponsesQuery.ConstantToolChoice.required;
        }
        if (choice instanceof LLMClient.AutoToolChoice) {
            return OpenAIResponsesQuery.ConstantToolChoice.auto;
        }
        if (choice instanceof LLMClient.NamedToolChoice) {
            LLMClient.NamedToolChoice ntc = (LLMClient.NamedToolChoice)choice;
            OpenAIResponsesQuery.EnforcedToolChoice etc = new OpenAIResponsesQuery.EnforcedToolChoice();
            etc.functionName = ntc.name;
            return etc;
        }
        throw new IllegalArgumentException(String.format("Unknown tool choice: %s", choice.getClass().getSimpleName()));
    }
}

