/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec.drift;

import com.dataiku.dip.analysis.model.prediction.PredictionModelPerformanceMetrics;
import com.dataiku.dip.mec.drift.DriftResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ImageDriftResult {
    public Map<String, ImageDriftMetrics> columns = new HashMap<String, ImageDriftMetrics>();

    public void populateMetrics(PredictionModelPerformanceMetrics metrics) {
        if (metrics.euclidianDistancePerFeature == null) {
            metrics.euclidianDistancePerFeature = new HashMap<String, Double>();
        }
        if (metrics.cosineSimilarityPerFeature == null) {
            metrics.cosineSimilarityPerFeature = new HashMap<String, Double>();
        }
        if (metrics.classifierGiniPerFeature == null) {
            metrics.classifierGiniPerFeature = new HashMap<String, Double>();
        }
        if (metrics.meanRedPerFeature == null) {
            metrics.meanRedPerFeature = new HashMap<String, Double>();
        }
        if (metrics.meanGreenPerFeature == null) {
            metrics.meanGreenPerFeature = new HashMap<String, Double>();
        }
        if (metrics.meanBluePerFeature == null) {
            metrics.meanBluePerFeature = new HashMap<String, Double>();
        }
        if (metrics.meanSaturationPerFeature == null) {
            metrics.meanSaturationPerFeature = new HashMap<String, Double>();
        }
        if (metrics.rmsContrastPerFeature == null) {
            metrics.rmsContrastPerFeature = new HashMap<String, Double>();
        }
        if (metrics.laplacianVarPerFeature == null) {
            metrics.laplacianVarPerFeature = new HashMap<String, Double>();
        }
        if (metrics.tenengradPerFeature == null) {
            metrics.tenengradPerFeature = new HashMap<String, Double>();
        }
        if (metrics.entropyPerFeature == null) {
            metrics.entropyPerFeature = new HashMap<String, Double>();
        }
        if (metrics.edgeDensityPerFeature == null) {
            metrics.edgeDensityPerFeature = new HashMap<String, Double>();
        }
        if (metrics.areaPerFeature == null) {
            metrics.areaPerFeature = new HashMap<String, Double>();
        }
        if (metrics.aspectRatioPerFeature == null) {
            metrics.aspectRatioPerFeature = new HashMap<String, Double>();
        }
        this.columns.forEach((column, drift) -> {
            metrics.euclidianDistancePerFeature.put((String)column, drift.euclidianDistance);
            metrics.cosineSimilarityPerFeature.put((String)column, drift.cosineSimilarity);
            metrics.classifierGiniPerFeature.put((String)column, drift.classifierGini);
            metrics.meanRedPerFeature.put((String)column, drift.meanRed != null ? drift.meanRed.ksTestPvalue : null);
            metrics.meanGreenPerFeature.put((String)column, drift.meanGreen != null ? drift.meanGreen.ksTestPvalue : null);
            metrics.meanBluePerFeature.put((String)column, drift.meanBlue != null ? drift.meanBlue.ksTestPvalue : null);
            metrics.meanSaturationPerFeature.put((String)column, drift.meanSaturation != null ? drift.meanSaturation.ksTestPvalue : null);
            metrics.rmsContrastPerFeature.put((String)column, drift.rmsContrast != null ? drift.rmsContrast.ksTestPvalue : null);
            metrics.laplacianVarPerFeature.put((String)column, drift.laplacianVar != null ? drift.laplacianVar.ksTestPvalue : null);
            metrics.tenengradPerFeature.put((String)column, drift.tenengrad != null ? drift.tenengrad.ksTestPvalue : null);
            metrics.entropyPerFeature.put((String)column, drift.entropy != null ? drift.entropy.ksTestPvalue : null);
            metrics.edgeDensityPerFeature.put((String)column, drift.edgeDensity != null ? drift.edgeDensity.ksTestPvalue : null);
            metrics.areaPerFeature.put((String)column, drift.area != null ? drift.area.ksTestPvalue : null);
            metrics.aspectRatioPerFeature.put((String)column, drift.aspectRatio != null ? drift.aspectRatio.ksTestPvalue : null);
        });
    }

    public static class ImageDriftMetrics {
        @Nullable
        Double euclidianDistance;
        @Nullable
        Double cosineSimilarity;
        @Nullable
        Double classifierGini;
        @Nullable
        DriftResult.UnivariateDriftResult.NumericalColumnDrift meanRed;
        @Nullable
        DriftResult.UnivariateDriftResult.NumericalColumnDrift meanGreen;
        @Nullable
        DriftResult.UnivariateDriftResult.NumericalColumnDrift meanBlue;
        @Nullable
        DriftResult.UnivariateDriftResult.NumericalColumnDrift meanSaturation;
        @Nullable
        DriftResult.UnivariateDriftResult.NumericalColumnDrift rmsContrast;
        @Nullable
        DriftResult.UnivariateDriftResult.NumericalColumnDrift laplacianVar;
        @Nullable
        DriftResult.UnivariateDriftResult.NumericalColumnDrift tenengrad;
        @Nullable
        DriftResult.UnivariateDriftResult.NumericalColumnDrift entropy;
        @Nullable
        DriftResult.UnivariateDriftResult.NumericalColumnDrift edgeDensity;
        @Nullable
        DriftResult.UnivariateDriftResult.NumericalColumnDrift area;
        @Nullable
        DriftResult.UnivariateDriftResult.NumericalColumnDrift aspectRatio;
        @Nullable
        ProbasClassifer refPredictionInfos;
        @Nullable
        ProbasClassifer curPredictionInfos;
    }

    public static class ProbasClassifer {
        public double[] x;
        public double[] pdf;
        public List<Map<String, Object>> top5;
        @Nullable
        public String managedFolderSmartName;
    }
}

