/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.grouping.Grouper2;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SinkProcessorOutput;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.csv.CSVDeserializer;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.ColumnMetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.DSSMetricsEngine;
import com.dataiku.dip.metrics.engines.HiveColumnMetricsEngine;
import com.dataiku.dip.metrics.engines.ImpalaColumnMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.SQLColumnMetricsEngine;
import com.dataiku.dip.metrics.engines.SparkColumnMetricsEngine;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;

public class AdvancedStatsDatasetProbeType
extends ProbeType {
    public static final String TYPE = "adv_col_stats";
    public static final int NB_TOP_VALUES_MAX = 100;
    public static final int NB_TOP_VALUES_MIN = 10;
    public static final int NB_TOP_VALUES_DEFAULT = 10;
    private static final Logger logger = Logger.getLogger((String)"dku.datasets.metrics.advancedstats");

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new AdvancedStatsDSSGrouperComputer());
        computers.add(new AdvancedStatsSQLMetricsEngineComputer(new AdvancedStatsJdbcMetricsEngineComputer()));
        computers.add(new AdvancedStatsImpalaMetricsEngineComputer(new AdvancedStatsJdbcMetricsEngineComputer()));
        computers.add(new AdvancedStatsHiveMetricsEngineComputer(new AdvancedStatsJdbcMetricsEngineComputer()));
        computers.add(new AdvancedStatsSparkMetricsEngineComputer(new AdvancedStatsJdbcMetricsEngineComputer()));
        return computers;
    }

    public AdvancedStatsDatasetProbeType() {
        this.type = TYPE;
    }

    @Override
    public List<Metric> listBuildableMetrics(Object object, MetricTargetType objectType) {
        ArrayList metrics = Lists.newArrayList();
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                metrics.add(new AdvancedStatsDatasetMetric(AdvancedStatsDatasetMetrics.MODE, column.getName(), column.getType()));
                metrics.add(new AdvancedStatsDatasetMetric(AdvancedStatsDatasetMetrics.TOP10, column.getName(), column.getType()));
                metrics.add(new AdvancedStatsDatasetMetric(AdvancedStatsDatasetMetrics.TOP10_WITH_COUNTS, column.getName(), column.getType()));
            }
        }
        return metrics;
    }

    @Override
    public Object listSelectableMetrics(Probe probe, Object object, MetricTargetType objectType) {
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            AdvancedStatsDatasetProbeHint probeHint = new AdvancedStatsDatasetProbeHint();
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                AdvancedStatsDatasetProbeColumnHint columnHint = new AdvancedStatsDatasetProbeColumnHint(column.getName());
                HashSet activeMetrics = Sets.newHashSet();
                for (AdvancedStatsDatasetProbeColumnConfiguration aggregate : ((AdvancedStatsDatasetProbeConfiguration)probe.configuration).aggregates) {
                    if (!aggregate.column.equals(column.getName())) continue;
                    activeMetrics.add(aggregate.aggregated);
                }
                for (AdvancedStatsDatasetMetrics aggregated : AdvancedStatsDatasetMetrics.values()) {
                    if (!aggregated.isSelectable()) continue;
                    columnHint.metrics.add(new AdvancedStatsDatasetProbeMetricHint(aggregated.getMetadata().name, aggregated, activeMetrics.contains((Object)aggregated), false));
                }
                probeHint.columns.add(columnHint);
            }
            return probeHint;
        }
        return null;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList metrics = Lists.newArrayList();
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            AdvancedStatsDatasetProbeConfiguration configuration = (AdvancedStatsDatasetProbeConfiguration)probe.getConfiguration();
            for (AdvancedStatsDatasetProbeColumnConfiguration configured : configuration.aggregates) {
                SchemaColumn column = dataset.getSchema().getColumn(configured.column);
                if (column != null) {
                    AdvancedStatsDatasetMetric metric = new AdvancedStatsDatasetMetric(configured.aggregated, column.getName(), column.getType(), configuration.numberTopValues);
                    metrics.add(metric);
                    continue;
                }
                logger.warn((Object)("Configured a metric on '" + configured.column + "' which has disappeared since. Skipping."));
            }
        }
        return metrics;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> columns, Probe probe) {
        AdvancedStatsDatasetProbeConfiguration configuration = new AdvancedStatsDatasetProbeConfiguration();
        for (SchemaColumn column : columns) {
            for (AdvancedStatsDatasetMetrics aggregated : AdvancedStatsDatasetMetrics.values()) {
                if (aggregated == AdvancedStatsDatasetMetrics.TOPN) continue;
                AdvancedStatsDatasetProbeColumnConfiguration columnConfiguration = new AdvancedStatsDatasetProbeColumnConfiguration();
                columnConfiguration.aggregated = aggregated;
                columnConfiguration.column = column.getName();
                configuration.aggregates.add(columnConfiguration);
            }
        }
        return configuration;
    }

    @Override
    public ProbeType trimForSave() {
        return new AdvancedStatsDatasetProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return AdvancedStatsDatasetProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(3).withName("Most frequent values");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return false;
    }

    public static class AdvancedStatsDSSGrouperComputer
    extends DSSMetricsEngine.DSSMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return AdvancedStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            return new DSSMetricsEngine.DSSMetricsEngineRun().with(new MetricComputation(probe, this, metric, 10.0));
        }

        @Override
        public DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession start(DSSMetricsEngine.DSSMetricsEngineCallbacks engine, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
            AdvancedStatsDatasetMetric metric = (AdvancedStatsDatasetMetric)computations.get((int)0).metric;
            AdvancedStatsDSSGrouperComputerSession session = new AdvancedStatsDSSGrouperComputerSession();
            session.tempDirectory = DSSTempUtils.getTempFolder((String)"dss-engine-metrics", (String)"adv-stats-", (boolean)true);
            session.inputSchema = engine.getDataset().getSchema();
            GroupingRecipePayloadParams.GroupingKey key = new GroupingRecipePayloadParams.GroupingKey();
            key.column = metric.getColumn();
            key.type = engine.getColumnByName().get(metric.getColumn()).getType();
            session.grouper = new Grouper2(Lists.newArrayList((Object[])new GroupingRecipePayloadParams.GroupingKey[]{key}), new ArrayList<GroupingRecipePayloadParams.GroupingValue>(), "dku_group_count", (File)session.tempDirectory, new Sorter.MergeSortParams(), null);
            session.grouper.startAccumulating((ColumnFactory)engine.getColumnFactory(), session.inputSchema);
            session.computations = computations;
            computations.forEach(computation -> {
                computation.session = session;
            });
            return session;
        }

        @Override
        public void cleanup(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
            AdvancedStatsDSSGrouperComputerSession session = (AdvancedStatsDSSGrouperComputerSession)dssComputerSession;
            if (session.grouper != null) {
                session.grouper.close();
            }
        }

        @Override
        public boolean accumulate(Row row, DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession session) throws Exception {
            ((AdvancedStatsDSSGrouperComputerSession)session).grouper.accumulate(row);
            return true;
        }

        @Override
        public boolean canComputeWith(List<MetricComputation> handledComputations, List<MetricComputation> otherComputations) {
            String column = handledComputations.get((int)0).metric.getColumn();
            return otherComputations.stream().allMatch(computation -> computation.computer instanceof AdvancedStatsDSSGrouperComputer && computation.metric.getColumn().equals(column));
        }

        @Override
        public Map<Metric, String> getAggregates(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
            AdvancedStatsDSSGrouperComputerSession session = (AdvancedStatsDSSGrouperComputerSession)dssComputerSession;
            session.grouper.finishAccumulating();
            StreamColumnFactory outputCf = new StreamColumnFactory();
            StreamRowFactory outputRf = new StreamRowFactory();
            PriorityQueue<ValueAndCount> heap = new PriorityQueue<ValueAndCount>(100, Comparator.comparingLong(va -> va.count));
            String column = session.computations.get((int)0).metric.getColumn();
            SinkProcessorOutput out = new SinkProcessorOutput((ColumnFactory)outputCf, column, heap){
                final /* synthetic */ ColumnFactory val$outputCf;
                final /* synthetic */ String val$column;
                final /* synthetic */ PriorityQueue val$heap;
                {
                    this.val$outputCf = columnFactory;
                    this.val$column = string;
                    this.val$heap = priorityQueue;
                }

                public void emitRow(Row row) throws Exception {
                    String value = row.get(this.val$outputCf.column(this.val$column));
                    String globalCount = row.get(this.val$outputCf.column("dku_group_count"));
                    this.val$heap.add(new ValueAndCount(value, Long.parseLong(globalCount)));
                    while (this.val$heap.size() > 100) {
                        this.val$heap.remove();
                    }
                }
            };
            session.grouper.startAggregating((ColumnFactory)outputCf, session.inputSchema);
            session.grouper.aggregate((ProcessorOutput)out, (ColumnFactory)outputCf, (RowFactory)outputRf);
            session.grouper.finishAggregating();
            session.grouper.close();
            ArrayList valueAndCounts = Lists.newArrayList();
            while (!heap.isEmpty()) {
                valueAndCounts.add((ValueAndCount)heap.remove());
            }
            session.tempDirectory.close();
            session.tempDirectory = null;
            HashMap<Metric, String> aggregates = new HashMap<Metric, String>();
            session.computations.forEach(computation -> {
                if (!valueAndCounts.isEmpty()) {
                    AdvancedStatsDatasetMetrics aggregated = ((AdvancedStatsDatasetMetric)computation.metric).getMetricType();
                    aggregates.put(computation.metric, aggregated.computeAggregate((MetricComputation)computation, valueAndCounts));
                } else {
                    aggregates.put(computation.metric, null);
                }
            });
            return aggregates;
        }

        @Override
        public JsonObject writeJson(JsonSerializationContext ctx) {
            return new JsonObject();
        }

        @Override
        public void readJson(JsonObject jsonObj, JsonDeserializationContext ctx) {
        }

        public static class AdvancedStatsDSSGrouperComputerSession
        implements DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession {
            public List<MetricComputation> computations;
            private AutoDelete tempDirectory;
            private Grouper2 grouper;
            private Schema inputSchema;
        }

        private static class ValueAndCount {
            final String value;
            final long count;

            public ValueAndCount(String value, long count) {
                this.value = value;
                this.count = count;
            }
        }
    }

    public static class AdvancedStatsSQLMetricsEngineComputer
    extends MetricComputer.SQLColumnMetricsEngineComputer
    implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation {
        private final AdvancedStatsJdbcMetricsEngineComputer subComputer;

        public AdvancedStatsSQLMetricsEngineComputer(AdvancedStatsJdbcMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return AdvancedStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            AdvancedStatsDatasetMetric advancedStatsDatasetMetric = (AdvancedStatsDatasetMetric)metric;
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isSQLAble(authCtx, (Dataset)object)) {
                return new SQLColumnMetricsEngine.SQLColumnMetricsEngineRun(advancedStatsDatasetMetric.getColumn()).with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public void addAggregations(ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public boolean handleResult(List<QueryRunResult.ScriptRunResultColumn> columns, String[] row, MetricComputation computation) throws Exception {
            return this.subComputer.handleResult(columns, row, computation);
        }

        @Override
        public String getAggregate(MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(computation);
        }

        @Override
        public String getColumn(MetricComputation computation) {
            AdvancedStatsDatasetMetric advancedStatsDatasetMetric = (AdvancedStatsDatasetMetric)computation.metric;
            return advancedStatsDatasetMetric.getColumn();
        }
    }

    public static class AdvancedStatsJdbcMetricsEngineComputer {
        public void addAggregations(Dataset dataset, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder) {
            AdvancedStatsJdbcComputerSession session = new AdvancedStatsJdbcComputerSession();
            computation.session = session;
            session.dialect = dialect;
            AdvancedStatsDatasetMetric metric = (AdvancedStatsDatasetMetric)computation.metric;
            session.aggregated = metric.getMetricType();
            String columnName = metric.getColumn();
            SchemaColumn column = dataset.getSchema().getColumn(columnName);
            session.type = column.getType();
            ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
            ExpressionBuilder col = ef.col(column.getName());
            col = ExpressionUtils.getAdjustedColumn(col, column, dataset.getParams(), dataset.isManaged(), dialect);
            SelectQueryBuilder.SelectRefBuilder ref = queryBuilder.select(col, metric.getMetricType().name() + "_" + column.getName());
            session.offsets.add(ref.getIndex());
            SelectQueryBuilder.SelectRefBuilder refCount = queryBuilder.select(ef.count("*").castToBigint(), metric.getMetricType().name() + "_" + column.getName() + "_count");
            session.offsets.add(refCount.getIndex());
        }

        public boolean handleResult(List<QueryRunResult.ScriptRunResultColumn> columns, String[] row, MetricComputation computation) throws Exception {
            AdvancedStatsJdbcComputerSession session = (AdvancedStatsJdbcComputerSession)computation.session;
            int offset = session.offsets.get(0);
            int countOffset = session.offsets.get(1);
            String value = row[offset - 1];
            long count = Long.parseLong(row[countOffset - 1]);
            try {
                if (session.type == Type.DATE) {
                    value = DKUtils.isoFormatReadableByDateFormat((long)CSVDeserializer.hiveDateParser.parseDateTime(value).getMillis());
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failure while trying to harmonize hive date to ISO format");
            }
            session.results.add(value);
            session.counts.add(count);
            int limit = session.aggregated == AdvancedStatsDatasetMetrics.MODE ? 1 : computation.probe.getConfigurationAs(AdvancedStatsDatasetProbeConfiguration.class).numberTopValues;
            return session.results.size() < limit;
        }

        public String getAggregate(MetricComputation computation) {
            return ((AdvancedStatsJdbcComputerSession)computation.session).aggregated.getAggregate(computation);
        }

        public static class AdvancedStatsJdbcComputerSession {
            public AdvancedStatsDatasetMetrics aggregated;
            public Type type;
            public SQLDialect dialect;
            public List<Integer> offsets = Lists.newArrayList();
            public List<String> results = Lists.newArrayList();
            public List<Long> counts = Lists.newArrayList();
        }
    }

    public static class AdvancedStatsImpalaMetricsEngineComputer
    extends MetricComputer.ImpalaColumnMetricsEngineComputer
    implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation {
        private final AdvancedStatsJdbcMetricsEngineComputer subComputer;

        public AdvancedStatsImpalaMetricsEngineComputer(AdvancedStatsJdbcMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return AdvancedStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            AdvancedStatsDatasetMetric advancedStatsDatasetMetric = (AdvancedStatsDatasetMetric)metric;
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                SchemaColumn schemaColumn = ((Dataset)object).getSchema().getColumn(advancedStatsDatasetMetric.getColumn());
                if (!schemaColumn.getType().isPrimitive()) {
                    return null;
                }
                return new ImpalaColumnMetricsEngine.ImpalaColumnMetricsEngineRun(advancedStatsDatasetMetric.getColumn()).with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public void addAggregations(ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public boolean handleResult(List<QueryRunResult.ScriptRunResultColumn> columns, String[] row, MetricComputation computation) throws Exception {
            return this.subComputer.handleResult(columns, row, computation);
        }

        @Override
        public String getAggregate(MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(computation);
        }

        @Override
        public String getColumn(MetricComputation computation) {
            AdvancedStatsDatasetMetric advancedStatsDatasetMetric = (AdvancedStatsDatasetMetric)computation.metric;
            return advancedStatsDatasetMetric.getColumn();
        }
    }

    public static class AdvancedStatsHiveMetricsEngineComputer
    extends MetricComputer.HiveColumnMetricsEngineComputer
    implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation {
        private AdvancedStatsJdbcMetricsEngineComputer subComputer;

        public AdvancedStatsHiveMetricsEngineComputer(AdvancedStatsJdbcMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return AdvancedStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            AdvancedStatsDatasetMetric advancedStatsDatasetMetric = (AdvancedStatsDatasetMetric)metric;
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                return new HiveColumnMetricsEngine.HiveColumnMetricsEngineRun(advancedStatsDatasetMetric.getColumn()).with(new MetricComputation(probe, this, metric, 2.0));
            }
            return null;
        }

        @Override
        public void addAggregations(ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public boolean handleResult(List<QueryRunResult.ScriptRunResultColumn> columns, String[] row, MetricComputation computation) throws Exception {
            return this.subComputer.handleResult(columns, row, computation);
        }

        @Override
        public String getAggregate(MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(computation);
        }

        @Override
        public String getColumn(MetricComputation computation) {
            AdvancedStatsDatasetMetric advancedStatsDatasetMetric = (AdvancedStatsDatasetMetric)computation.metric;
            return advancedStatsDatasetMetric.getColumn();
        }
    }

    public static class AdvancedStatsSparkMetricsEngineComputer
    extends MetricComputer.SparkColumnMetricsEngineComputer
    implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation {
        private final AdvancedStatsJdbcMetricsEngineComputer subComputer;

        public AdvancedStatsSparkMetricsEngineComputer(AdvancedStatsJdbcMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return AdvancedStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            AdvancedStatsDatasetMetric advancedStatsDatasetMetric = (AdvancedStatsDatasetMetric)metric;
            if (objectType == MetricTargetType.DATASET) {
                SchemaColumn schemaColumn = ((Dataset)object).getSchema().getColumn(advancedStatsDatasetMetric.getColumn());
                if (!schemaColumn.getType().isPrimitive()) {
                    return null;
                }
                return new SparkColumnMetricsEngine.SparkColumnMetricsEngineRun(advancedStatsDatasetMetric.getColumn()).with(new MetricComputation(probe, this, metric, 3.0));
            }
            return null;
        }

        @Override
        public void addAggregations(ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public boolean handleResult(List<QueryRunResult.ScriptRunResultColumn> columns, String[] row, MetricComputation computation) throws Exception {
            return this.subComputer.handleResult(columns, row, computation);
        }

        @Override
        public String getAggregate(MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(computation);
        }

        @Override
        public String getColumn(MetricComputation computation) {
            AdvancedStatsDatasetMetric advancedStatsDatasetMetric = (AdvancedStatsDatasetMetric)computation.metric;
            return advancedStatsDatasetMetric.getColumn();
        }
    }

    public static class AdvancedStatsDatasetMetric
    extends Metric {
        public AdvancedStatsDatasetMetrics metricType;
        public String column;
        public int numberTopValues = -1;

        public AdvancedStatsDatasetMetric(AdvancedStatsDatasetMetrics metricType, String column, Type columnType, int numberTopValues) {
            super(AdvancedStatsDatasetProbeType.TYPE, metricType.getDataTypeFromMetricType(columnType));
            this.metricType = metricType;
            this.column = column;
            this.numberTopValues = numberTopValues;
            this.id = Metric.serializeMetric(this);
        }

        public AdvancedStatsDatasetMetric(AdvancedStatsDatasetMetrics metricType, String column, Type columnType) {
            this(metricType, column, columnType, -1);
        }

        public AdvancedStatsDatasetMetrics getMetricType() {
            return this.metricType;
        }

        @Override
        public String getColumn() {
            return this.column;
        }

        @Override
        public MetricMetadata getMeta() {
            MetricMetadata meta = new MetricMetadata(this.metricType.getMetadata());
            if (this.metricType.equals((Object)AdvancedStatsDatasetMetrics.TOPN)) {
                meta.withFullName("Top " + this.numberTopValues + " of " + this.column);
            } else {
                meta.withFullName(meta.getName() + " of " + this.column);
            }
            return meta;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return new AdvancedStatsDatasetMetric(this.metricType, placeholder, this.dataType).getId();
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            AdvancedStatsDatasetProbeConfiguration conf = new AdvancedStatsDatasetProbeConfiguration();
            AdvancedStatsDatasetProbeColumnConfiguration col = new AdvancedStatsDatasetProbeColumnConfiguration();
            col.column = this.getColumn();
            col.aggregated = this.metricType;
            conf.aggregates.add(col);
            if (this.numberTopValues != -1) {
                conf.numberTopValues = this.numberTopValues;
            }
            return new Probe(this.getType()).withConfiguration(conf).withMeta(ProbeType.getProbeType(AdvancedStatsDatasetProbeType.TYPE).getMeta());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AdvancedStatsDatasetMetrics {
        MODE{
            public final transient MetricMetadata metadata = new MetricMetadata().withName("Mode").withFormat("longReadableNumber");

            @Override
            public String computeAggregate(MetricComputation computation, List<AdvancedStatsDSSGrouperComputer.ValueAndCount> valueAndCounts) {
                return valueAndCounts.get((int)(valueAndCounts.size() - 1)).value;
            }

            @Override
            public Type getDataTypeFromMetricType(Type columnType) {
                return columnType;
            }

            @Override
            public MetricMetadata getMetadata() {
                return this.metadata;
            }

            @Override
            public String getAggregate(MetricComputation computation) {
                AdvancedStatsJdbcMetricsEngineComputer.AdvancedStatsJdbcComputerSession session = (AdvancedStatsJdbcMetricsEngineComputer.AdvancedStatsJdbcComputerSession)computation.session;
                return !session.results.isEmpty() ? session.results.get(0) : null;
            }

            @Override
            public boolean isSelectable() {
                return true;
            }
        }
        ,
        TOP10{
            public final transient MetricMetadata metadata = new MetricMetadata().withName("Top 10 values");

            @Override
            public String computeAggregate(MetricComputation computation, List<AdvancedStatsDSSGrouperComputer.ValueAndCount> valueAndCounts) {
                int numberTopValues = computation.probe.getConfigurationAs(AdvancedStatsDatasetProbeConfiguration.class).numberTopValues;
                ArrayList values = Lists.newArrayList();
                for (int i = valueAndCounts.size() - 1; i >= Math.max(0, valueAndCounts.size() - numberTopValues); --i) {
                    values.add(valueAndCounts.get((int)i).value);
                }
                return JSON.json((Object)values);
            }

            @Override
            public Type getDataTypeFromMetricType(Type columnType) {
                return Type.ARRAY;
            }

            @Override
            public MetricMetadata getMetadata() {
                return this.metadata;
            }

            @Override
            public String getAggregate(MetricComputation computation) {
                AdvancedStatsJdbcMetricsEngineComputer.AdvancedStatsJdbcComputerSession session = (AdvancedStatsJdbcMetricsEngineComputer.AdvancedStatsJdbcComputerSession)computation.session;
                return JSON.json(session.results);
            }

            @Override
            public boolean isSelectable() {
                return true;
            }
        }
        ,
        TOPN{
            public final transient MetricMetadata metadata = new MetricMetadata().withName("Top N values");

            @Override
            public String computeAggregate(MetricComputation computation, List<AdvancedStatsDSSGrouperComputer.ValueAndCount> valueAndCounts) {
                int numberTopValues = computation.probe.getConfigurationAs(AdvancedStatsDatasetProbeConfiguration.class).numberTopValues;
                ArrayList values = Lists.newArrayList();
                for (int i = valueAndCounts.size() - 1; i >= Math.max(0, valueAndCounts.size() - numberTopValues); --i) {
                    values.add(valueAndCounts.get((int)i).value);
                }
                return JSON.json((Object)values);
            }

            @Override
            public Type getDataTypeFromMetricType(Type columnType) {
                return Type.ARRAY;
            }

            @Override
            public MetricMetadata getMetadata() {
                return this.metadata;
            }

            @Override
            public String getAggregate(MetricComputation computation) {
                AdvancedStatsJdbcMetricsEngineComputer.AdvancedStatsJdbcComputerSession session = (AdvancedStatsJdbcMetricsEngineComputer.AdvancedStatsJdbcComputerSession)computation.session;
                return JSON.json(session.results);
            }

            @Override
            public boolean isSelectable() {
                return false;
            }
        }
        ,
        TOP10_WITH_COUNTS{
            public final transient MetricMetadata metadata = new MetricMetadata().withName("Top 10 values (with counts)");

            @Override
            public String computeAggregate(MetricComputation computation, List<AdvancedStatsDSSGrouperComputer.ValueAndCount> valueAndCounts) {
                int numberTopValues = computation.probe.getConfigurationAs(AdvancedStatsDatasetProbeConfiguration.class).numberTopValues;
                ArrayList values = Lists.newArrayList();
                for (int i = valueAndCounts.size() - 1; i >= Math.max(0, valueAndCounts.size() - numberTopValues); --i) {
                    HashMap pair = Maps.newHashMap();
                    String value = valueAndCounts.get((int)i).value;
                    if (value == null) {
                        value = "";
                    }
                    pair.put(value, valueAndCounts.get((int)i).count);
                    values.add(pair);
                }
                return JSON.json((Object)values);
            }

            @Override
            public Type getDataTypeFromMetricType(Type columnType) {
                return Type.ARRAY;
            }

            @Override
            public MetricMetadata getMetadata() {
                return this.metadata;
            }

            @Override
            public String getAggregate(MetricComputation computation) {
                AdvancedStatsJdbcMetricsEngineComputer.AdvancedStatsJdbcComputerSession session = (AdvancedStatsJdbcMetricsEngineComputer.AdvancedStatsJdbcComputerSession)computation.session;
                ArrayList values = Lists.newArrayList();
                int numberTopValues = computation.probe.getConfigurationAs(AdvancedStatsDatasetProbeConfiguration.class).numberTopValues;
                for (int i = 0; i < Math.min(numberTopValues, session.results.size()); ++i) {
                    HashMap pair = Maps.newHashMap();
                    String value = session.results.get(i);
                    if (value == null) {
                        value = "";
                    }
                    pair.put(value, session.counts.get(i));
                    values.add(pair);
                }
                return JSON.json((Object)values);
            }

            @Override
            public boolean isSelectable() {
                return true;
            }
        };


        public abstract String computeAggregate(MetricComputation var1, List<AdvancedStatsDSSGrouperComputer.ValueAndCount> var2);

        public abstract Type getDataTypeFromMetricType(Type var1);

        public abstract MetricMetadata getMetadata();

        public abstract String getAggregate(MetricComputation var1);

        public abstract boolean isSelectable();
    }

    public static class AdvancedStatsDatasetProbeHint {
        public List<AdvancedStatsDatasetProbeColumnHint> columns = Lists.newArrayList();
    }

    public static class AdvancedStatsDatasetProbeColumnHint {
        public String column;
        public List<AdvancedStatsDatasetProbeMetricHint> metrics = Lists.newArrayList();

        AdvancedStatsDatasetProbeColumnHint(String column) {
            this.column = column;
        }
    }

    public static class AdvancedStatsDatasetProbeConfiguration
    implements ProbeConfiguration {
        public List<AdvancedStatsDatasetProbeColumnConfiguration> aggregates = Lists.newArrayList();
        public Integer numberTopValues = 10;
    }

    public static class AdvancedStatsDatasetProbeColumnConfiguration {
        public String column;
        public AdvancedStatsDatasetMetrics aggregated;
    }

    public static class AdvancedStatsDatasetProbeMetricHint {
        public String name;
        public AdvancedStatsDatasetMetrics aggregated;
        public boolean active;
        public boolean disabled;

        AdvancedStatsDatasetProbeMetricHint(String name, AdvancedStatsDatasetMetrics aggregated, boolean active, boolean disabled) {
            this.name = name;
            this.aggregated = aggregated;
            this.active = active;
            this.disabled = disabled;
        }
    }

    public static class AdvancedStatsDatasetMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof AdvancedStatsDatasetMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            AdvancedStatsDatasetMetric advancedStatsDatasetMetric = (AdvancedStatsDatasetMetric)metric;
            if (advancedStatsDatasetMetric.getMetricType() == AdvancedStatsDatasetMetrics.TOPN) {
                return Metric.buildMetricIdFromParts(AdvancedStatsDatasetProbeType.TYPE, advancedStatsDatasetMetric.getMetricType().name(), advancedStatsDatasetMetric.getColumn(), Integer.toString(advancedStatsDatasetMetric.numberTopValues));
            }
            return Metric.buildMetricIdFromParts(AdvancedStatsDatasetProbeType.TYPE, advancedStatsDatasetMetric.getMetricType().name(), advancedStatsDatasetMetric.getColumn());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() >= 3 && parts.get(0).equals(AdvancedStatsDatasetProbeType.TYPE)) {
                AdvancedStatsDatasetMetrics type = AdvancedStatsDatasetMetrics.valueOf(parts.get(1));
                if (parts.size() == 4 && type == AdvancedStatsDatasetMetrics.TOPN) {
                    return new AdvancedStatsDatasetMetric(type, parts.get(2), Type.STRING, Integer.parseInt(parts.get(3)));
                }
                if (parts.size() == 3 && type != AdvancedStatsDatasetMetrics.TOPN) {
                    return new AdvancedStatsDatasetMetric(AdvancedStatsDatasetMetrics.valueOf(parts.get(1)), parts.get(2), Type.STRING);
                }
            }
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
        }
    }
}

