/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.notifications;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.notifications.NotificationsRouter;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.server.notifications.backend.JobStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.MLTaskStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.UserChangedEvent;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.PersistentNotificationsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TrackingService;
import com.dataiku.dip.server.services.TrackingSessionUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersistentNotificationsNotificationsRouter
implements NotificationsRouter {
    @Autowired
    private FlowExecutionService2 flowExecutionService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TrackingService trackingService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private PersistentNotificationsService service;
    @Autowired
    private RequestsService requestsService;
    @Autowired
    private UsersService usersService;
    private static Logger logger = Logger.getLogger((String)"dku.notifications.pnotifications");

    @Override
    @PostConstruct
    public void init() {
        logger.debug((Object)"Init persistent notifications service");
        this.pubSub.subscribe("timeline-item", tie -> {
            try {
                if (tie.item.objectType == ITaggingService.TaggableType.DATA_COLLECTION) {
                    return;
                }
                Set<String> users = this.interestsService.getEffectiveWatchingUsers_NT(tie.item.objectType, tie.item.projectKey, tie.item.objectId, tie.item.user, tie.item.workspaceKey);
                String id = this.service.getFullyQualifiedDSSObjectId(tie.item.objectType, tie.item.projectKey, tie.item.objectId, tie.item.workspaceKey);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Dispatching TIE object=" + id + " interestedUsers=" + StringUtils.join(users, (String)",")));
                }
                for (String user : users) {
                    this.service.push(user, id, tie, false);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to store timeline notification", (Throwable)e);
            }
        });
        this.pubSub.subscribe("export-state-change", esce -> {
            ExportStatus status = esce.status;
            if (status.state != JobState.DONE && status.state != JobState.FAILED) {
                return;
            }
            this.service.push(status.userId, status.exportId, esce, false);
        });
        this.pubSub.subscribe("ui-state-changed", evt -> {
            try {
                String id;
                TrackingService.TrackingSession session = this.trackingService.getSession(evt.getUserLogin(), evt.getWebSocketSessionId());
                TrackingSessionUtils.ObjectDesc desc = TrackingSessionUtils.getTaggableObjectDesc(session);
                if (desc != null) {
                    this.service.acknowledgeObject(evt.getUserLogin(), desc.projectKey, desc.objectType, desc.objectId, desc.workspaceKey);
                }
                if (StringUtils.isNotBlank((String)(id = TrackingSessionUtils.getNonTaggableObjectIdOrNull(session)))) {
                    this.service.acknowledgeObject(evt.getUserLogin(), id);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create project timeline", (Throwable)e);
            }
        });
        this.pubSub.subscribe("job-state-change", jsce -> {
            if (jsce.state != JobState.DONE && jsce.state != JobState.FAILED && jsce.state != JobState.ABORTED) {
                return;
            }
            try {
                EnhancedSerializedJobStatus status = this.flowExecutionService.getStatus_NT(jsce.projectKey, jsce.jobId);
                try (Transaction t = this.transactionService.beginRead();){
                    this.flowExecutionService.addInitiator(status);
                }
                String initiator = status.baseStatus.def.initiator;
                if (this.userIsOnRecipePage((JobStateChangedEvent)jsce, status, initiator)) {
                    return;
                }
                if (this.userIsOnJobPage((JobStateChangedEvent)jsce, status, initiator)) {
                    return;
                }
                boolean markAsRead = jsce.state != JobState.FAILED && jsce.state != JobState.ABORTED;
                this.service.push(initiator, jsce.jobId, jsce, markAsRead);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to store job notifications", (Throwable)e);
            }
        });
        this.pubSub.subscribe("mltask-state-change", ce -> {
            String initiator = ce.initiator;
            boolean markAsRead = this.userIsOnModelsListPage((MLTaskStateChangedEvent)ce);
            if (!ce.isRunning) {
                this.service.push(initiator, ce.taskId, ce, markAsRead);
            }
        });
        this.pubSub.subscribe("user-edited", evt -> {
            if (evt.action == UserChangedEvent.ActionType.DELETED) {
                this.service.deleteForUser(evt.getUserLogin());
            }
        });
        this.pubSub.subscribe("commit-mention", evt -> {
            String id = evt.author + "$" + evt.mentionedUser + "$" + String.valueOf((Object)evt.objectType) + "$" + evt.projectKey + "$" + evt.objectId;
            this.service.push(evt.mentionedUser, id, evt, false);
        });
        this.pubSub.subscribe("discussion-mention", evt -> {
            String id = evt.author + "$" + evt.mentionedUser + "$" + String.valueOf((Object)evt.objectType) + "$" + evt.projectKey + "$" + evt.objectId;
            if (StringUtils.isNotBlank((String)evt.workspaceKey)) {
                id = id + "$" + evt.workspaceKey;
            }
            this.service.push(evt.mentionedUser, id, evt, false);
        });
        this.pubSub.subscribe("discussion-reply", evt -> {
            if (evt.newReply) {
                Set<String> users = this.interestsService.getEffectiveWatchingUsers_NT(evt.objectType, evt.projectKey, evt.objectId, evt.user, evt.workspaceKey);
                String id = evt.user + "$" + String.valueOf((Object)evt.objectType) + "$" + evt.projectKey + "$" + evt.objectId;
                if (StringUtils.isNotBlank((String)evt.workspaceKey)) {
                    id = id + "$" + evt.workspaceKey;
                }
                for (String user : users) {
                    this.service.push(user, id, evt, false);
                }
            }
        });
        this.pubSub.subscribe("discussion-close", evt -> {
            Set<String> users = this.interestsService.getEffectiveWatchingUsers_NT(evt.objectType, evt.projectKey, evt.objectId, evt.user, evt.workspaceKey);
            String id = evt.user + "$" + String.valueOf((Object)evt.objectType) + "$" + evt.projectKey + "$" + evt.objectId;
            if (StringUtils.isNotBlank((String)evt.workspaceKey)) {
                id = id + "$" + evt.workspaceKey;
            }
            for (String user : users) {
                this.service.push(user, id, evt, false);
            }
        });
        this.pubSub.subscribe("access-request", evt -> {
            String id = evt.getUserLogin() + "$" + evt.getProjectKey() + "$" + evt.getObjectId();
            if (StringUtils.isNotBlank((String)evt.getWorkspaceKey())) {
                id = id + "$" + evt.getWorkspaceKey();
            }
            for (String user : this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), evt.getRequest().objectProjectKey)) {
                this.service.push(user, id, evt, false);
            }
        });
        this.pubSub.subscribe("plugin-request", evt -> {
            String id = evt.getUserLogin() + "$" + evt.getObjectId();
            for (String user : this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), null)) {
                this.service.push(user, id, evt, false);
            }
        });
        this.pubSub.subscribe("code-env-request", evt -> {
            String id = evt.getUserLogin() + "$" + String.valueOf((Object)evt.getObjectType()) + "$" + evt.getObjectId();
            for (String user : this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), null)) {
                this.service.push(user, id, evt, false);
            }
        });
        this.pubSub.subscribe("instance-access-request", evt -> {
            String id = evt.getUserLogin() + "$" + String.valueOf((Object)evt.getObjectType()) + "$" + evt.getObjectId();
            for (String user : this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), null)) {
                this.service.push(user, id, evt, false);
            }
        });
        this.pubSub.subscribe("profile-upgrade-request", evt -> {
            String id = evt.getUserLogin() + "$" + String.valueOf((Object)evt.getObjectType()) + "$" + evt.getObjectId();
            for (String user : this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), null)) {
                this.service.push(user, id, evt, false);
            }
        });
        this.pubSub.subscribe("access-granted", evt -> {
            String id = evt.getUserLogin() + "$" + evt.getProjectKey() + "$" + evt.getObjectId();
            if (StringUtils.isNotBlank((String)evt.getWorkspaceKey())) {
                id = id + "$" + evt.getWorkspaceKey();
            }
            this.service.push(evt.getUserLogin(), id, evt, false);
        });
        this.pubSub.subscribe("plugin-request-granted", evt -> {
            UsersService.UIUser user;
            try (Transaction tx = this.transactionService.beginRead();){
                user = this.usersService.getUserOrNull_NoLeak(evt.getUserLogin());
            }
            if (user != null && user.enabled.booleanValue()) {
                String id = evt.getUserLogin() + "$" + String.valueOf((Object)evt.getObjectType()) + "$" + evt.getObjectId();
                this.service.push(evt.getUserLogin(), id, evt, false);
            }
        });
        this.pubSub.subscribe("code-env-request-granted", evt -> {
            String id = evt.getUserLogin() + "$" + String.valueOf((Object)evt.getObjectType()) + "$" + evt.getObjectId();
            this.service.push(evt.getUserLogin(), id, evt, false);
        });
        logger.debug((Object)"Done init persistent notifications service");
    }

    private boolean userIsOnRecipePage(JobStateChangedEvent jsce, EnhancedSerializedJobStatus status, String userName) {
        if (JobDef.JobTriggerType.RECIPE != jsce.triggeredFrom) {
            return false;
        }
        Iterator<SerializedJobActivityStatus> it = status.baseStatus.activities.values().iterator();
        if (it.hasNext()) {
            SerializedJobActivityStatus a = it.next();
            String recipeName = a.recipeName;
            String projectKey = jsce.projectKey;
            for (TrackingService.TrackingSession session : this.trackingService.listSessions()) {
                if (!session.getUser().login.equals(userName) || !TrackingSessionUtils.isOnObjectPage(session, ITaggingService.TaggableType.RECIPE, projectKey, recipeName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean userIsOnJobPage(JobStateChangedEvent jsce, EnhancedSerializedJobStatus status, String userName) {
        for (TrackingService.TrackingSession session : this.trackingService.listSessions()) {
            if (!session.getUser().login.equals(userName) || !TrackingSessionUtils.isOnFQObjectPage(session, jsce.jobId)) continue;
            return true;
        }
        return false;
    }

    private boolean userIsOnModelsListPage(MLTaskStateChangedEvent ce) {
        for (TrackingService.TrackingSession session : this.trackingService.listSessions()) {
            if (!session.getUser().login.equals(ce.getUserLogin()) || !TrackingSessionUtils.isOnModelsListPage(session, ce.projectKey, ce.taskId)) continue;
            return true;
        }
        return false;
    }
}

