/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.dss.aggregators.DateForbiddenAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import java.io.IOException;

public class AverageAggregator
extends DateForbiddenAggregator {
    private static final String ERROR_MESSAGE = "Cannot average non numeric values.";

    public AverageAggregator(Aggregation req) {
        super(req, ERROR_MESSAGE);
    }

    public AverageAggregator(Aggregation req, int[] numBins) {
        super(req, numBins, ERROR_MESSAGE);
    }

    public AverageAggregator(Aggregation req, int bins) {
        super(req, bins, ERROR_MESSAGE);
    }

    @Override
    public Double getValue(Double value, long count) {
        return this.getDoubleValue(value, count);
    }

    @Override
    public Double getValue(Double value, long count, boolean toRealType) {
        return this.getDoubleValue(value, count);
    }

    @Override
    public double getDoubleValue(double value, long count) {
        if (count <= 0L) {
            return value;
        }
        return value / (double)count;
    }

    @Override
    public void mergeEnd(AxisHandler.Axis[] axes, LongDataTensor countTensor) throws IOException {
        super.mergeEnd(axes, countTensor);
        long[] counts = this.getMergeDT().hasNullValues ? this.getMergeDT().nonNullCounts : countTensor.tensor;
        for (int i = 0; i < this.getMergeDT().tensorSize; ++i) {
            this.getMergeDT().setAsDouble(i, this.getDoubleValue(this.getMergeDT().getAsDouble(i), counts[i]));
        }
    }
}

