/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.cache;

import com.dataiku.dip.pivot.backend.sql.cache.CacheContext;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Iterator;

public class PerDatasetCache {
    private Cache<String, CacheContext> cache = CacheBuilder.newBuilder().maximumSize(10L).softValues().build();

    public synchronized void invalidateDataset(String fullDatasetName) {
        Iterator it = this.cache.asMap().keySet().iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).endsWith("###" + fullDatasetName)) continue;
            it.remove();
        }
    }

    public synchronized void invalidateProject(String projectKey) {
        Iterator it = this.cache.asMap().keySet().iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).contains("###" + projectKey + ".")) continue;
            it.remove();
        }
    }

    public synchronized CacheContext getFor(String sampleId, String fullName) {
        String key = sampleId + "###" + fullName;
        CacheContext ctx = (CacheContext)this.cache.getIfPresent((Object)key);
        if (ctx == null) {
            ctx = new CacheContext();
            this.cache.put((Object)key, (Object)ctx);
        }
        return ctx;
    }
}

