/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.processors;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.fs.AzureBlobStorageFSProvider;
import com.dataiku.dip.datasets.fs.BlobLikeFSProvider;
import com.dataiku.dip.datasets.fs.BlobLikeResplitOutputWriter;
import com.dataiku.dip.datasets.fs.FSProviderConnectionFactory;
import com.dataiku.dip.datasets.fs.GoogleCloudStorageFSProvider;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.datasets.fs.S3FSProvider;
import com.dataiku.dip.datasets.streamwrite.CurrentTimestampTargetPartitionComputer;
import com.dataiku.dip.datasets.streamwrite.TargetPartitionComputer;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.formats.LineFormatExtractor;
import com.dataiku.dip.output.FileNamingAbleOutputWriter;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.output.ResplittableExtensibleFileOutputWriter;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.processors.AbstractProcessor;
import com.dataiku.dip.processors.ConnectionPathTargetProcessorSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.cache.Cache;
import com.dataiku.dss.shadelib.com.google.common.cache.CacheBuilder;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ConnectionPathTargetProcessor<T>
implements AbstractProcessor<T> {
    private ConnectionPathTargetProcessorSettings settings;
    private final boolean useRunAs;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private TransactionService transactionService;
    private PartitioningScheme partitioningScheme;
    private Class<? extends FSProvider> fsProviderType;
    private Cache<String, OpenOutputPartition> openPartitions = CacheBuilder.newBuilder().recordStats().removalListener(partition -> ((OpenOutputPartition)partition.getValue()).close()).build();
    private final TargetPartitionComputer targetPartitionComputer;
    private final CurrentTimestampTargetPartitionComputer.ComputationTimezone computationTimezone = CurrentTimestampTargetPartitionComputer.ComputationTimezone.LOCAL;
    private WarningsContext wc;
    protected AuthCtx authCtx;
    private final ColumnFactory cf = new StreamColumnFactory();
    private final RowFactory rf = new StreamRowFactory();
    private Column lineColumn;
    private ScheduledExecutorService ses;
    private ScheduledFuture<?> scheduledFuture;
    protected boolean invalidConfiguration = false;

    protected ConnectionPathTargetProcessor(ConnectionPathTargetProcessorSettings settings, boolean useRunAs) {
        this.settings = settings;
        this.useRunAs = useRunAs;
        this.partitioningScheme = PartitioningScheme.createTimePartitioningScheme((TimeDimension.Period)settings.partitioningPeriod);
        this.targetPartitionComputer = new CurrentTimestampTargetPartitionComputer(this.partitioningScheme, this.computationTimezone);
        if (settings.flushEveryS > 0L) {
            this.ses = Executors.newScheduledThreadPool(1);
            this.scheduledFuture = this.ses.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectionPathTargetProcessor.this.getLogger().info((Object)"Performing periodic flush");
                        ConnectionPathTargetProcessor.this.flush();
                    }
                    catch (IOException e) {
                        ConnectionPathTargetProcessor.this.getLogger().error((Object)"Periodic flush failed");
                    }
                }
            }, settings.flushEveryS, settings.flushEveryS, TimeUnit.SECONDS);
        }
        this.getLogger().info((Object)("Finished setup with settings " + JSON.json((Object)settings)));
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void init() throws IOException, DKUSecurityException, CodedException {
        this.lineColumn = this.cf.column("line");
        this.authCtx = this.createAuthCtx();
        if (this.authCtx == null) {
            this.invalidConfiguration = true;
            return;
        }
        try (CredentialsRemoteFetchConfigurationProvider.FetchAsAuthCtx authCtxForRemote = CredentialsRemoteFetchConfigurationProvider.fetchAs(this.authCtx);
             FSProvider fsProvider = this.createFSProvider();){
            this.fsProviderType = fsProvider != null ? fsProvider.getClass() : null;
        }
    }

    @Nullable
    private AuthCtx createAuthCtx() {
        if (!this.useRunAs) {
            return DSSAuthCtx.newNone();
        }
        if (StringUtils.isEmpty((String)this.settings.runAs)) {
            this.getLogger().errorV("No user name defined for this %s, the target is disabled.", new Object[]{this.getProcessorName()});
            return null;
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtxCreationService authCtxCreationService = (AuthCtxCreationService)SpringUtils.getBean(AuthCtxCreationService.class);
            AuthCtx ctx = authCtxCreationService.createOrNull(this.settings.runAs);
            if (ctx == null) {
                this.getLogger().errorV("Invalid user name '%s' defined for this %s, the target is disabled.", new Object[]{this.settings.runAs, this.getProcessorName()});
            }
            AuthCtx authCtx = ctx;
            return authCtx;
        }
    }

    private FSProvider createFSProvider() throws IOException, DKUSecurityException, CodedException {
        DSSConnection connection;
        if (StringUtils.isEmpty((String)this.settings.fileLikeConnectionName)) {
            this.invalidConfiguration = true;
            this.getLogger().errorV("No connection defined for this %s, the target is disabled.", new Object[]{this.getProcessorName()});
            return null;
        }
        try (Transaction t = this.transactionService.beginRead();){
            connection = this.connectionsDAO.getConnection(this.authCtx, this.settings.fileLikeConnectionName);
        }
        if (connection == null) {
            this.invalidConfiguration = true;
            this.getLogger().errorV("Invalid connection '%s' defined for this %s, the target is disabled.", new Object[]{this.settings.fileLikeConnectionName, this.getProcessorName()});
            return null;
        }
        new FSProviderConnectionFactory().prepareConnectionForProvider(connection.getType(), this.authCtx, connection);
        switch (connection.type) {
            case "Filesystem": {
                return new LocalFSProvider(connection, this.settings.fileLikePathWithinConnection);
            }
            case "EC2": {
                String chbucket;
                EC2Connection.Params s3Params = ((EC2Connection)connection).params;
                if (StringUtils.isNotBlank((String)s3Params.chbucket)) {
                    chbucket = s3Params.chbucket;
                    this.getLogger().infoV("Using bucket '%s' from connection", new Object[]{chbucket});
                } else if (StringUtils.isNotBlank((String)this.settings.bucket)) {
                    chbucket = this.settings.bucket;
                    this.getLogger().infoV("Using bucket '%s' from target settings", new Object[]{chbucket});
                } else {
                    throw new IllegalArgumentException("Cannot use a S3 connection without bucket");
                }
                return new S3FSProvider(this.authCtx, connection, this.settings.fileLikePathWithinConnection, chbucket);
            }
            case "Azure": {
                String chcontainer;
                AzureConnection.AzureParam azParams = ((AzureConnection)connection).params;
                if (StringUtils.isNotBlank((String)azParams.chcontainer)) {
                    chcontainer = azParams.chcontainer;
                    this.getLogger().infoV("Using container '%s' from connection", new Object[]{chcontainer});
                } else if (StringUtils.isNotBlank((String)this.settings.bucket)) {
                    chcontainer = this.settings.bucket;
                    this.getLogger().infoV("Using container '%s' from target settings", new Object[]{chcontainer});
                } else {
                    throw new IllegalArgumentException("Cannot use a Azure connection without container");
                }
                return new AzureBlobStorageFSProvider(this.authCtx, connection, this.settings.fileLikePathWithinConnection, chcontainer, ApplicationConfigurator.getProxySettings(), false);
            }
            case "GCS": {
                String chbucket;
                GCSConnection.Params gcsParams = ((GCSConnection)connection).params;
                if (StringUtils.isNotBlank((String)gcsParams.chbucket)) {
                    chbucket = gcsParams.chbucket;
                    this.getLogger().infoV("Using bucket '%s' from connection.", new Object[]{chbucket});
                } else if (StringUtils.isNotBlank((String)this.settings.bucket)) {
                    chbucket = this.settings.bucket;
                    this.getLogger().infoV("Using bucket '%s' from target settings.", new Object[]{chbucket});
                } else {
                    throw new IllegalArgumentException("Cannot use a GCS connection without bucket");
                }
                return new GoogleCloudStorageFSProvider(this.authCtx, connection, this.settings.fileLikePathWithinConnection, chbucket, ApplicationConfigurator.getProxySettings());
            }
        }
        throw new IllegalArgumentException("Cannot use connection type " + connection.type);
    }

    private String sanitizePathElement(String pathElement) {
        return pathElement.replace('/', '_').replace('.', '_');
    }

    private OpenOutputPartition getOrOpenPartition(String topic, String routingKey, String partitionId) throws Exception {
        OpenOutputPartition oop;
        Object lookupKey = "";
        if (this.settings.folderByTopic) {
            lookupKey = (String)lookupKey + topic + "-";
        }
        if (this.settings.folderByRoutingKey && routingKey != null) {
            lookupKey = (String)lookupKey + routingKey + "-";
        }
        if ((oop = (OpenOutputPartition)this.openPartitions.getIfPresent(lookupKey = (String)lookupKey + partitionId)) != null) {
            return oop;
        }
        this.getLogger().info((Object)("Opening partition " + partitionId + " (lookup: " + (String)lookupKey + ")"));
        oop = new OpenOutputPartition();
        oop.partition = PartitionFactory.fromIdentifier(this.partitioningScheme, partitionId);
        Object prefix = FilePartitioner.computePartitionRelPathAsFolder(oop.partition, this.partitioningScheme);
        if (StringUtils.isNotBlank((String)this.settings.nodeFolder)) {
            prefix = "/" + this.sanitizePathElement(this.settings.nodeFolder) + (String)prefix;
        }
        if (this.settings.folderByRoutingKey && routingKey != null) {
            prefix = "/" + this.sanitizePathElement(routingKey) + (String)prefix;
        }
        if (this.settings.folderByTopic) {
            prefix = "/" + this.sanitizePathElement(topic) + (String)prefix;
        }
        String formatType = "line";
        LineFormatExtractor.Config formatParams = new LineFormatExtractor.Config();
        formatParams.charset = "utf8";
        if (BlobLikeFSProvider.class.isAssignableFrom(this.fsProviderType)) {
            BlobLikeResplitOutputWriter eow = new BlobLikeResplitOutputWriter(this.authCtx, "NO_PROJECT_KEY", (BlobLikeFSProvider)this.createFSProvider(), (String)prefix, 0, 1, formatType, (FormatParams)formatParams, new Schema(), new WarningsContext(), Output.WriteMode.APPEND, "gz", new SerializedDataset.ReadWriteOptions());
            oop.writer = eow;
            eow.setFileNamingMode(FileNamingAbleOutputWriter.FileNamingMode.TIMESTAMP, null);
            eow.withTransactionalMode();
        } else if (LocalFSProvider.class.isAssignableFrom(this.fsProviderType)) {
            ResplittableExtensibleFileOutputWriter<FSProvider> eow;
            oop.writer = eow = new ResplittableExtensibleFileOutputWriter<FSProvider>(this.authCtx, "NO_PROJECT_KEY", this.createFSProvider(), (String)prefix, 0, 1, formatType, formatParams, new Schema(), new WarningsContext(), Output.WriteMode.APPEND, "gz", new SerializedDataset.ReadWriteOptions());
            eow.setFileNamingMode(FileNamingAbleOutputWriter.FileNamingMode.TIMESTAMP, null);
            eow.withTransactionalMode();
        } else {
            throw new IllegalArgumentException("Can't use FS Provider class " + String.valueOf(this.fsProviderType));
        }
        oop.writer.init(this.cf);
        oop.lookupKey = lookupKey;
        oop.logger = this.getLogger();
        this.openPartitions.put(lookupKey, (Object)oop);
        return oop;
    }

    private void closePartition(OpenOutputPartition oop) {
        this.getLogger().info((Object)("Closing partition " + oop.lookupKey));
        oop.close();
        this.openPartitions.invalidate((Object)oop.lookupKey);
    }

    protected void process_internal(JsonObject jo, String topic, String routingKey) throws Exception {
        Row row = this.rf.row();
        row.put(this.lineColumn, jo.toString());
        String partitionId = this.targetPartitionComputer.compute(row);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("Will write row to " + partitionId));
        }
        OpenOutputPartition oop = this.getOrOpenPartition(topic, routingKey, partitionId);
        try {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)("[p=" + oop.lookupKey + "] Emitting row (writtenBefore=" + oop.writer.writtenBytes() + ")"));
            }
            oop.writer.emitRow(row);
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)("[p=" + oop.lookupKey + "] Emitted row (writtenAfter=" + oop.writer.writtenBytes() + ")"));
            }
            if (this.settings.flushEveryBytes > 0L && oop.writer.writtenBytes() > this.settings.flushEveryBytes) {
                this.getLogger().info((Object)("Closing partition " + partitionId + " (flushEveryBytes reached)"));
                this.closePartition(oop);
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Failed to emit row", (Throwable)e);
        }
    }

    @Override
    public synchronized void shutdown() throws IOException, InterruptedException {
        if (this.scheduledFuture != null) {
            this.getLogger().info((Object)"Canceling the refresh future");
            this.scheduledFuture.cancel(true);
            this.ses.shutdown();
            this.ses.awaitTermination(1L, TimeUnit.SECONDS);
        }
        this.getLogger().info((Object)"Flushing open partitions");
        this.flush();
        this.openPartitions = null;
    }

    @Override
    public synchronized void flush() throws IOException {
        try (CredentialsRemoteFetchConfigurationProvider.FetchAsAuthCtx authCtxForRemote = CredentialsRemoteFetchConfigurationProvider.fetchAs(this.authCtx);){
            for (OpenOutputPartition oop : this.openPartitions.asMap().values()) {
                oop.close();
            }
            this.openPartitions.invalidateAll();
            this.getLogger().info((Object)"Flush complete");
        }
    }

    protected abstract DKULogger getLogger();

    static class OpenOutputPartition
    implements Closeable {
        String lookupKey;
        Partition partition;
        OutputWriter writer;
        DKULogger logger;
        boolean alreadyClosed = false;

        OpenOutputPartition() {
        }

        @Override
        public void close() {
            if (!this.alreadyClosed) {
                this.alreadyClosed = true;
                try {
                    this.logger.info((Object)("Closing open partition: " + String.valueOf(this.partition) + " (lookup:" + this.lookupKey + ")"));
                    this.writer.lastRowEmitted();
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Failed to close writer for " + String.valueOf(this.partition)), (Throwable)e);
                }
            }
        }
    }
}

