/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.impala;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.hive.HiveQLQueryRecipeUtils;
import com.dataiku.dip.recipes.code.impala.AbstractImpalaRecipeRunner;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeMeta;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;

public class ImpalaRecipeRunner
extends AbstractImpalaRecipeRunner {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.impala");

    public ImpalaRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    protected QueryBunch getQueryBunch(ImpalaSQLDialect dialect) throws Exception {
        return QueryBunch.fromScript(dialect, this.code);
    }

    @Override
    protected boolean getStreamMode() {
        ImpalaRecipeMeta.ImpalaRecipeParams params = RecipeRegistry.getParamsAs(this.activity, ImpalaRecipeMeta.ImpalaRecipeParams.class);
        return params != null ? params.runInStreamMode : true;
    }

    @Override
    protected String prepareMainQuery(String mainQuery, Dataset targetDataset, Partition targetPartition) throws IOException {
        return HiveQLQueryRecipeUtils.insertOverwriteFragment(targetDataset, targetPartition, Output.WriteMode.APPEND, true) + "\n" + mainQuery;
    }
}

