/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sparksql;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.code.scala.ScalaService;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryRecipeTester;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.PreprocessedQueryForSubstitution;
import com.dataiku.dip.server.recipes.RecipeVariablesHelper;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.Pair;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkSQLRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScalaService scalaService;
    @Autowired
    private GenericRecipesValidationService validationService;
    private String query;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.sparksql.schema.computer");

    public SparkSQLRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.query = payload;
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        Pair<String[], Integer[]> expandedSqlStatementsAndOffsets;
        SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
        Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
        if (((SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams)this.recipe.params).useGlobalMetastore) {
            throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY_WITH_RECIPE_CONFIG, "Cannot compute output schema of SparkSQL recipe when using global metastore");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.recipe.name = "testRecipe";
            FlowGraph graph = new FlowGraph();
            FlowRecipe frecipe = graph.buildSingleRecipe(this.recipe);
            subgraphCallable = this.validationService.getValidationRunnableSubgraph(this.authCtx, frecipe, null);
        }
        RecipeRunnableSubgraph subgraph = subgraphCallable.call_NT();
        PreprocessedQueryForSubstitution preprocessedQuery = PreprocessedQueryForSubstitution.preprocess_NT(this.query, new SparkSQLDialect());
        try (Transaction t = this.transactionService.beginRead();){
            RecipeVariablesHelper.RecipeSubstitutionVariablesResult vres = new RecipeVariablesHelper().getRecipeVariablesAndSubstitute(this.authCtx, this.recipe.projectKey, subgraph, preprocessedQuery, null);
            vres.throwIfSubstitutionError();
            expandedSqlStatementsAndOffsets = vres.substitutedAndSplit;
        }
        AbstractSQLQueryRecipeTester.SQLQuerySimpleValidationResult validation = this.scalaService.validateSparkSQL(this.authCtx, expandedSqlStatementsAndOffsets, this.recipe);
        if (validation.queryResultSchema == null) {
            assert (validation.messages.anyFatal());
            throw ErrorContext.iae((String)("Failed to compute output schema: " + String.valueOf(validation.messages.firstFatal())));
        }
        return Lists.newArrayList((Object[])new Schema[]{validation.queryResultSchema});
    }
}

