/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.eda.worksheets.models.SplitBySpec;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.eda.univariate.UnivariateAnalysisWrapper;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public class UnivariateRecipePayloadParams
extends RecipePayloadParams {
    public boolean addComputationTimestamp = false;
    public List<UnivariateAnalysisWrapper> analyses = new ArrayList<UnivariateAnalysisWrapper>();
    public double confidenceLevel = 0.95;
    @Nullable
    public SplitBySpec splitBy = null;
    public boolean withSummaryStats = true;
    public boolean withFrequencyTable = true;
    public boolean withQuantileTable = true;
    public boolean withConfidenceIntervals = false;

    public UnivariateRecipePayloadParams(boolean withSummaryStats, boolean withFrequencyTable, boolean withQuantileTable, boolean withConfidenceIntervals, double confidenceLevel, @Nullable SplitBySpec splitBy) {
        this.splitBy = splitBy;
        this.withSummaryStats = withSummaryStats;
        this.withFrequencyTable = withFrequencyTable;
        this.withQuantileTable = withQuantileTable;
        this.withConfidenceIntervals = withConfidenceIntervals;
        this.confidenceLevel = confidenceLevel;
    }

    public UnivariateRecipePayloadParams() {
    }

    @Override
    public void validate() {
        if (this.confidenceLevel < 0.0) {
            throw ErrorContext.iae((String)"The confidence level must be positive");
        }
        if (this.confidenceLevel > 1.0) {
            throw ErrorContext.iae((String)"The confidence level must be less than 1");
        }
        for (UnivariateAnalysisWrapper analysis : this.analyses) {
            analysis.validate(this);
        }
    }
}

