/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels.externalmodelidentifier;

import com.dataiku.dip.savedmodels.externalmodelidentifier.ExternalEndpointIdentifier;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SnowparkEndpointIdentifier
extends ExternalEndpointIdentifier {
    public static final String NAME = "snowpark";
    public String database;
    public String schema;
    public String service;
    public String endpoint;

    private SnowparkEndpointIdentifier() {
    }

    public SnowparkEndpointIdentifier(String database, String schema, String service, String endpoint) {
        this.database = database;
        this.schema = schema;
        this.service = service;
        this.endpoint = endpoint;
    }

    public static SnowparkEndpointIdentifier from(String fullId) {
        String[] elems = fullId.split("\\.");
        if (elems.length != 4) {
            throw new IllegalArgumentException("Snowpark endpoint fullId should be in the format '\"db\".\"schema\".\"service\".endpoint'");
        }
        String database = SnowparkEndpointIdentifier.removeQuotes(elems[0]);
        String schema = SnowparkEndpointIdentifier.removeQuotes(elems[1]);
        String service = SnowparkEndpointIdentifier.removeQuotes(elems[2]);
        String endpoint = elems[3];
        return new SnowparkEndpointIdentifier(database, schema, service, endpoint);
    }

    private static String removeQuotes(String str) {
        return StringUtils.strip((String)str, (String)"\"");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnowparkEndpointIdentifier that = (SnowparkEndpointIdentifier)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.schema, that.schema) && Objects.equals(this.service, that.service) && Objects.equals(this.endpoint, that.endpoint);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.database, this.schema, this.service, this.endpoint);
    }
}

