/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels.proxymodels;

import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.savedmodels.proxymodels.AzureMLProxyConfiguration;
import com.dataiku.dip.savedmodels.proxymodels.DSSProxyModelConfiguration;
import com.dataiku.dip.savedmodels.proxymodels.DatabricksProxyConfiguration;
import com.dataiku.dip.savedmodels.proxymodels.KServeProxyModelConfiguration;
import com.dataiku.dip.savedmodels.proxymodels.SagemakerProxyConfiguration;
import com.dataiku.dip.savedmodels.proxymodels.VertexAIProxyConfiguration;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NullChecker;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.j2ts.annotations.UIModel;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@PolyJSON(value={@Mapping(value=DSSProxyModelConfiguration.class, type="dss-api-node"), @Mapping(value=KServeProxyModelConfiguration.class, type="kserve"), @Mapping(value=AzureMLProxyConfiguration.class, type="azure-ml"), @Mapping(value=SagemakerProxyConfiguration.class, type="sagemaker"), @Mapping(value=VertexAIProxyConfiguration.class, type="vertex-ai"), @Mapping(value=DatabricksProxyConfiguration.class, type="databricks")}, typeProperty="protocol")
@UIModel
public abstract class ProxyModelConfiguration {
    public String protocol;
    @Nullable
    public String connection;
    @Nullable
    public String region;
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.proxymodels.configuration");

    public void validate() {
        NullChecker.checkObject((Object)this);
    }

    public void setFromSavedModel(SavedModel savedModel) {
        this.setFromSavedModel(savedModel, true);
    }

    public void setFromSavedModel(SavedModel savedModel, boolean checkConsistency) {
        if (savedModel.proxyModelConfiguration == null) {
            throw new IllegalArgumentException("The parent Saved Model must have a proxy configuration.");
        }
        if (checkConsistency && !StringUtils.isEmpty((String)this.connection) && !StringUtils.equals((String)this.connection, (String)savedModel.proxyModelConfiguration.connection)) {
            throw new IllegalArgumentException("Saved Model Version connection must match its parent Saved Model connection.");
        }
        if (!StringUtils.isEmpty((String)this.protocol) && !StringUtils.equals((String)this.protocol, (String)savedModel.proxyModelConfiguration.protocol)) {
            throw new IllegalArgumentException("Saved Model Version protocol must match its parent Saved Model protocol.");
        }
        this.connection = savedModel.proxyModelConfiguration.connection;
        if (StringUtils.isEmpty((String)this.connection)) {
            this.connection = null;
        }
    }
}

