/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.reports.IReflectedEventsService;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.triggers.GraceDelaySettings;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.scheduler.triggers.TriggerRegistry;
import com.dataiku.dip.scheduler.triggers.TriggerRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ReflectedEventEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ScenarioRunsService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class ActiveTriggerLifecycleThread
extends Thread {
    private final String activeTriggerId;
    private final Scenario scenario;
    private final Trigger trigger;
    private final DSSAuthCtx runAsUser;
    private final ScenariosTriggerService scenariosTriggerService;
    private final ScenarioRunsService scenarioRunsService;
    private final FutureService futureService;
    private volatile boolean invalidated;
    private volatile ActiveTriggerStage stage = null;
    private volatile boolean forceTriggerExecution;
    private volatile boolean running;
    private volatile boolean crashed;
    private final QueueingInfo queueingInfo = new QueueingInfo();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.scenario.activetrigger.thread");

    public ActiveTriggerLifecycleThread(ScenariosTriggerService.ActiveTrigger activeTrigger, ScenariosTriggerService scenariosTriggerService, ScenarioRunsService scenarioRunsService, FutureService futureService) {
        this.scenariosTriggerService = scenariosTriggerService;
        this.scenarioRunsService = scenarioRunsService;
        this.futureService = futureService;
        this.setName("ActiveTriggerLifecycleThread_" + this.getId());
        this.setDaemon(true);
        this.activeTriggerId = activeTrigger.id();
        this.scenario = activeTrigger.scenario;
        this.trigger = activeTrigger.trigger;
        this.runAsUser = activeTrigger.runAsUser;
        this.running = true;
    }

    public String getActiveTriggerId() {
        return this.activeTriggerId;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean hasCrashed() {
        return this.crashed;
    }

    public boolean hasSameDefinition(ScenariosTriggerService.ActiveTrigger activeTrigger) {
        if (this.trigger.getDelay() != activeTrigger.trigger.getDelay()) {
            return false;
        }
        if (!JSON.jsonEquals((Object)this.trigger.getGraceDelaySettings(), (Object)activeTrigger.trigger.getGraceDelaySettings())) {
            return false;
        }
        if (!JSON.jsonEquals((Object)this.trigger.getParams(), (Object)activeTrigger.trigger.getParams())) {
            return false;
        }
        return StringUtils.equals((String)this.trigger.getName(), (String)activeTrigger.trigger.getName());
    }

    public synchronized void invalidate() {
        this.invalidated = true;
        this.interrupt();
    }

    public synchronized void forceExecution(boolean interrupt) {
        this.forceTriggerExecution = true;
        if (interrupt) {
            this.interrupt();
        }
    }

    public synchronized boolean isValid() {
        return this.invalidated;
    }

    public synchronized void checkValidity() throws TriggerInvalidatedException {
        if (this.invalidated) {
            throw new TriggerInvalidatedException();
        }
    }

    public synchronized void setStage(ActiveTriggerStage stage) {
        this.stage = stage;
    }

    public synchronized ActiveTriggerStage getStage() {
        return this.stage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)("Starting thread to handle trigger " + this.trigger.getName() + " (type=" + this.trigger.getType() + ", id=" + this.trigger.getId() + ")"));
        try {
            boolean loopStarting = true;
            while (this.running) {
                TriggerFire triggerFire;
                String currentTriggerState;
                this.checkValidity();
                this.setStage(ActiveTriggerStage.WAITING);
                try {
                    currentTriggerState = this.scenariosTriggerService.getTriggerState(this.scenario, this.trigger);
                }
                catch (SQLException e) {
                    logger.warnV((Throwable)e, "(triggerId: %s) Unable to get trigger state, assuming none", new Object[]{this.trigger.id});
                    currentTriggerState = null;
                }
                try {
                    int delayToUse = Math.max(0, TriggerRegistry.getMeta(this.trigger).getForcedTriggerLoopDelay(this.trigger, currentTriggerState, loopStarting));
                    loopStarting = false;
                    QueueingInfo queueingInfo = this.queueingInfo;
                    synchronized (queueingInfo) {
                        this.queueingInfo.at = DKUDateUtils.isoFormatUTCNow();
                        this.queueingInfo.delayToUse = delayToUse;
                        this.queueingInfo.currentTriggerState = currentTriggerState;
                    }
                    if (!this.forceTriggerExecution) {
                        int millisecondsPerSecond = ApplicationConfigurator.getParams().getIntParam("dku.scenarios.triggers.millisecondsPerSecond", Integer.valueOf(1000));
                        Thread.sleep((long)delayToUse * (long)millisecondsPerSecond);
                    }
                }
                catch (InterruptedException e) {
                    logger.infoV((Throwable)e, "(triggerId: %s) Interrupted while waiting for the next execution", new Object[]{this.trigger.id});
                }
                this.forceTriggerExecution = false;
                this.checkValidity();
                this.setStage(ActiveTriggerStage.EXECUTING);
                if (this.dontRunTriggerWhenScenarioRuns() || (triggerFire = this.executeOnce()) == null) continue;
                GraceDelaySettings graceDelaySettings = this.trigger.getGraceDelaySettings();
                if (graceDelaySettings.getDelay() > 0) {
                    try {
                        this.scenariosTriggerService.addPendingTriggerFire(this.scenario, triggerFire);
                    }
                    catch (SQLException e) {
                        logger.errorV((Throwable)e, "(triggerId: %s) Failed to add pending scenario run", new Object[]{this.trigger.id});
                        continue;
                    }
                    logger.infoV("(triggerId: %s) Trigger fired, entering grace delay loop", new Object[]{this.trigger.id});
                    while (this.running) {
                        this.checkValidity();
                        this.setStage(ActiveTriggerStage.GRACE);
                        try {
                            Thread.sleep(graceDelaySettings.getDelay() * 1000);
                        }
                        catch (InterruptedException e) {
                            logger.infoV((Throwable)e, "(triggerId: %s) Interrupted while waiting for the grace delay", new Object[]{this.trigger.id});
                        }
                        if (!graceDelaySettings.shouldCheckAgainAfterGraceDelay()) break;
                        this.checkValidity();
                        if (this.dontRunTriggerWhenScenarioRuns()) {
                            logger.infoV("(triggerId: %s) Pending trigger cancelled because scenario started", new Object[]{this.trigger.id});
                            this.scenariosTriggerService.cancelPendingTriggerFire(this.scenario, triggerFire);
                            triggerFire = null;
                            break;
                        }
                        this.setStage(ActiveTriggerStage.CHECKING);
                        TriggerFire newTriggerFire = this.executeOnce();
                        if (newTriggerFire == null) break;
                        logger.infoV("(triggerId: %s) Trigger fired again, grace delay reset", new Object[]{this.trigger.id});
                        try {
                            this.scenariosTriggerService.replacePendingTriggerFire(this.scenario, triggerFire, newTriggerFire);
                        }
                        catch (SQLException e) {
                            logger.errorV((Throwable)e, "(triggerId: %s) Failed to add pending scenario run", new Object[]{this.trigger.id});
                            triggerFire = null;
                            break;
                        }
                        triggerFire = newTriggerFire;
                    }
                }
                if (triggerFire == null) continue;
                this.checkValidity();
                if (this.dontRunTriggerWhenScenarioRuns()) continue;
                try {
                    this.scenariosTriggerService.fire(this.scenario, triggerFire, null, null);
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "(triggerId: %s) Failed to fire scenario run", new Object[]{this.trigger.id});
                }
            }
        }
        catch (TriggerInvalidatedException e) {
            logger.infoV("(triggerId: %s) Exiting thread for trigger execution because its setup was invalidated", new Object[]{this.trigger.id});
        }
        catch (Throwable t) {
            logger.errorV(t, "(triggerId: %s) Trigger crashed", new Object[]{this.trigger.id});
            this.crashed = true;
            IReflectedEventsService.ReflectedEvent evt = new IReflectedEventsService.ReflectedEvent("trigger-crashed", t);
            ((PubSubService)((Object)SpringUtils.getBean(PubSubService.class))).publish((DSSEvent)new ReflectedEventEvent(evt));
        }
        finally {
            this.running = false;
        }
    }

    void stopGracefully() throws InterruptedException {
        logger.info((Object)("Stopping thread to handle trigger " + this.trigger.getName() + " (type=" + this.trigger.getType() + ", id=" + this.trigger.getId() + ")"));
        this.running = false;
        this.interrupt();
        this.join();
        logger.info((Object)("Done stopping thread to handle trigger " + this.trigger.getName() + " (type=" + this.trigger.getType() + ", id=" + this.trigger.getId() + ")"));
    }

    private boolean dontRunTriggerWhenScenarioRuns() {
        return this.scenario.getDelayedTriggersBehavior().suppressTriggersWhileRunning && this.scenarioRunsService.isRunning(this.scenario);
    }

    private TriggerFire executeOnce() {
        ScenarioTriggerExecutionThread execution = new ScenarioTriggerExecutionThread(TriggerRegistry.buildRunner(this.scenario, this.trigger));
        try {
            FutureResponse fr = this.futureService.runFuture(execution, 100L, new TypeToken<FutureResponse<TriggerFire>>(){});
            fr = this.futureService.waitForFinalResponse(fr);
            return (TriggerFire)fr.result;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to evaluate trigger", (Throwable)e);
            return null;
        }
    }

    public FuturePayload buildFuturePayload(Scenario scenario, Trigger trigger) {
        FuturePayload fp = new FuturePayload();
        fp.action = "run_trigger";
        fp.targets.add(DSSFuturePayloadUtils.forTaggableObject(scenario).withPart("triggers"));
        fp.displayName = "Run trigger " + trigger.getId() + " of scenario " + scenario.getName() + " in project " + scenario.getProjectKey();
        return fp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueingInfo getQueueingInfo() {
        QueueingInfo queueingInfo = this.queueingInfo;
        synchronized (queueingInfo) {
            QueueingInfo info = new QueueingInfo(this.queueingInfo);
            info.alive = this.isAlive();
            return info;
        }
    }

    public static enum ActiveTriggerStage {
        WAITING,
        EXECUTING,
        GRACE,
        CHECKING;

    }

    public static class QueueingInfo {
        public int delayToUse;
        public String currentTriggerState;
        public String at;
        public boolean alive;

        public QueueingInfo(QueueingInfo o) {
            this.at = o.at;
            this.delayToUse = o.delayToUse;
            this.currentTriggerState = o.currentTriggerState;
        }

        public QueueingInfo() {
        }
    }

    private static class TriggerInvalidatedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private TriggerInvalidatedException() {
        }
    }

    private class ScenarioTriggerExecutionThread
    extends SimpleFutureThread<TriggerFire> {
        private final FuturePayload futurePayload;
        private final TriggerRunner triggerRunner;

        public ScenarioTriggerExecutionThread(TriggerRunner triggerRunner) {
            super((AuthCtx)ActiveTriggerLifecycleThread.this.runAsUser);
            this.triggerRunner = triggerRunner;
            this.futurePayload = ActiveTriggerLifecycleThread.this.buildFuturePayload(ActiveTriggerLifecycleThread.this.scenario, ActiveTriggerLifecycleThread.this.trigger);
        }

        /*
         * Exception decompiling
         */
        @Override
        protected TriggerFire compute() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public String getPayloadForStartDoneMessage() {
            return "trigger:" + ActiveTriggerLifecycleThread.this.activeTriggerId + " - type:" + ActiveTriggerLifecycleThread.this.trigger.getType();
        }
    }
}

