/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RunScenarioStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return RunScenarioStepParams.class;
        }

        @Override
        public String getType() {
            return "run_scenario";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new RunScenarioStepRunner(scenario, step, step.getParamsAs(RunScenarioStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            RunScenarioStepParams stepParams = step.getParamsAs(RunScenarioStepParams.class);
            return "run scenario " + (stepParams != null && stepParams.scenarioId != null ? stepParams.scenarioId : "");
        }

        @Override
        public String buildId(Step step) {
            RunScenarioStepParams stepParams = step.getParamsAs(RunScenarioStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("run_scenario");
            if (stepParams != null) {
                sb.append("_");
                if (StringUtils.isBlank((String)stepParams.getProjectKey())) {
                    sb.append(stepParams.getProjectKey());
                    sb.append(".");
                }
                sb.append(stepParams.getScenarioId());
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final RunScenarioStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ScenariosTriggerService scenariosTriggerService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.runscenario");

    RunScenarioStepRunner(Scenario scenario, Step step, RunScenarioStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        Scenario scenarioToRun;
        logger.info((Object)("Start step " + this.step.name));
        String projectKey = this.params.getProjectKey() != null ? this.params.getProjectKey() : this.scenario.getProjectKey();
        String scenarioId = this.params.getScenarioId();
        DSSAuthCtx runAsUser = stepRun.getScenarioRun().getRunAsUser();
        try (Transaction t = this.transactionService.beginRead();){
            if (!this.permissionsService.hasProjectPrivilege((AuthCtx)runAsUser, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                throw new SecurityException("User " + runAsUser.getIdentifier() + " does not have the required permission on project " + projectKey);
            }
            scenarioToRun = this.scenariosService.getMandatory(projectKey, scenarioId);
        }
        TriggerFire subTrigger = new TriggerFire().withScenario(scenarioToRun).withParams(stepRun.getScenarioRun().getTrigger().getParams());
        subTrigger.withTrigger(new Trigger().withType("sub").withId("sub").withName("From scenario"));
        FutureResponse future = this.scenariosTriggerService.fire(scenarioToRun, subTrigger, stepRun.getScenarioRun().getVariables(), runAsUser);
        if (future != null) {
            future = this.futureService.waitForFinalResponse(future);
        }
        if (subTrigger.cancelled || future == null || !future.hasResult || future.result == null) {
            throw new Exception("Scenario didn't run");
        }
        this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(projectKey, scenarioId), null, null, stepRun.getScenarioRun(), stepRun, (ReportItem)future.result);
        if (((ReportItem)future.result).outcome == ReportItem.Outcome.WARNING) {
            stepReportItem.withOutcome(this.params.handleWarningsAs);
        } else {
            stepReportItem.withOutcome(((ReportItem)future.result).outcome);
        }
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class RunScenarioStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String projectKey;
        public String scenarioId;
        public ReportItem.Outcome handleWarningsAs = ReportItem.Outcome.WARNING;

        public String getProjectKey() {
            return this.projectKey;
        }

        public String getScenarioId() {
            return this.scenarioId;
        }

        public RunScenarioStepParams withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public RunScenarioStepParams withScenarioId(String scenarioId) {
            this.scenarioId = scenarioId;
            return this;
        }
    }
}

